<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
ini_set('max_execution_time', 500);

function create_timesheet($data,$folder,$filename,$student) 
{
	error_reporting(E_ALL);
	ini_set('display_errors', TRUE);
	ini_set('display_startup_errors', TRUE);

	define('EOL',(PHP_SAPI == 'cli') ? PHP_EOL : '<br />');
	date_default_timezone_set('Europe/London');
	require_once dirname(__FILE__) . '/Classes/PHPExcel.php';
	
	$objPHPExcel = new PHPExcel();
	
	$objPHPExcel->getProperties()->setCreator("Maarten Balliauw")
								 ->setLastModifiedBy("Maarten Balliauw")
								 ->setTitle("Office 2007 XLSX Test Document")
								 ->setSubject("Office 2007 XLSX Test Document")
								 ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
								 ->setKeywords("office 2007 openxml php")
								 ->setCategory("Test result file");

	$borderStyle = array('borders' =>
			                array('outline' =>
			                        array('style' => PHPExcel_Style_Border::BORDER_THIN,
			                                'color' => array('argb' => '000000'),   ),),);
	
	$objPHPExcel->getActiveSheet()->setCellValue('A1','Exam Name : ' .strtoupper($data['exam_name']));
	
	$objPHPExcel->getActiveSheet()->setCellValue('A2', 'Exam Type');
	$objPHPExcel->getActiveSheet()->setCellValue('A3', 'Exam Sub Type');	
	$objPHPExcel->getActiveSheet()->setCellValue('A4', 'Exam Name');
	$objPHPExcel->getActiveSheet()->setCellValue('A5', 'Exam Code');
	$objPHPExcel->getActiveSheet()->setCellValue('A6', 'Class');
	$objPHPExcel->getActiveSheet()->setCellValue('A7', 'Subject');
	$objPHPExcel->getActiveSheet()->setCellValue('A8', 'Maximum Mark');
	$objPHPExcel->getActiveSheet()->setCellValue('A9', 'Pass Mark');
	$objPHPExcel->getActiveSheet()->setCellValue('A10', 'Exam Date');
	$objPHPExcel->getActiveSheet()->setCellValue('C2', $data['exam_type_name']);
	$objPHPExcel->getActiveSheet()->setCellValue('C3', $data['exam_sub_type_name']);
	$objPHPExcel->getActiveSheet()->setCellValue('C4', $data['exam_name']);
	$objPHPExcel->getActiveSheet()->setCellValue('C5', $data['exam_id']);
	$objPHPExcel->getActiveSheet()->setCellValue('C6', $data['number'].'-'.$data['syllabus_name']);
	$objPHPExcel->getActiveSheet()->setCellValue('C7', $data['subject_child_name']);
	$objPHPExcel->getActiveSheet()->setCellValue('C8', $data['maximum_mark']);
	$objPHPExcel->getActiveSheet()->setCellValue('C9', $data['pass_mark']);
	$objPHPExcel->getActiveSheet()->setCellValue('C10', $data['exam_date']);		
	$objPHPExcel->getActiveSheet()->setCellValue('A14', 'No');
	$objPHPExcel->getActiveSheet()->setCellValue('B14', 'Student Code');
	$objPHPExcel->getActiveSheet()->setCellValue('C14', 'Student Name');
	$objPHPExcel->getActiveSheet()->setCellValue('D14', 'Mark Obtained');
	
		$i=15;
		foreach ($student as $student)
 		{
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$i, $i-14);
			$objPHPExcel->getActiveSheet()->setCellValue('B'.$i, $student['student_id']);
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$i, $student['first_name'].' '.$student['last_name']);

			$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':B'.$i)->applyFromArray($borderStyle);
			$objPHPExcel->getActiveSheet()->getStyle('B'.$i.':C'.$i)->applyFromArray($borderStyle);
			$objPHPExcel->getActiveSheet()->getStyle('C'.$i.':D'.$i)->applyFromArray($borderStyle);

			$objPHPExcel->getActiveSheet()->getStyle('A15:D'.$i)->applyFromArray(
			array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'F4D2D2')
					)
				)
			);

			$i++;
		}
	$heading = array(
		'font'  => array(
			'bold'  => true,
			'color' => array('rgb' => 'FFFFFF'),
			'size'  => 18,
			'name'  => 'Calibri'
		),
		'alignment' => array(
            'wrap'       => true,
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        ),
	);	
	$categoryheaderstyle = array(
		'font'  => array(
			'bold'  => true,
			'color' => array('rgb' => '000000'),
			'size'  => 12,
			'name'  => 'Calibri'
		),
		'alignment' => array(
            'wrap'       => true,
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        ),
	);
	
	$columnheaderstyle = array(
		'font'  => array(
			'bold'  => true,
			'color' => array('rgb' => '000000'),
			'size'  => 12,
			'name'  => 'Calibri'
		),
		'alignment' => array(
            'wrap'       => true,
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        ),
	);

	$borderStyle = array('borders' =>
			                array('outline' =>
			                        array('style' => PHPExcel_Style_Border::BORDER_THIN,
			                                'color' => array('argb' => '000000'),   ),),);

	$objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(30);
	$objPHPExcel->getActiveSheet()->getRowDimension('14')->setRowHeight(30);	
	// $objPHPExcel->getActiveSheet()->getRowDimension('3')->setRowHeight(20);
	// $objPHPExcel->getActiveSheet()->getRowDimension('4')->setRowHeight(35);
	// $objPHPExcel->getActiveSheet()->getRowDimension('5')->setRowHeight(30);

	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:C1');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A2:B2');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A3:B3');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A4:B4');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A5:B5');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A6:B6');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A7:B7');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A8:B8');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A9:B9');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A10:B10');
	// $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A2:C9');

	$objPHPExcel->getActiveSheet()->getStyle('A2:C10')->applyFromArray(
		array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'F4D2D2')
			)
		)
	);
	
	$objPHPExcel->getActiveSheet()->getStyle('A1:C1')->applyFromArray(
		array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '771f5c')
			)
		)
	);

	$objPHPExcel->getActiveSheet()->getStyle('A14:D14')->applyFromArray(
	array(
		'fill' => array(
			'type' => PHPExcel_Style_Fill::FILL_SOLID,
			'color' => array('rgb' => 'F4D2D2')
			)
		)
	);

	$objPHPExcel->getActiveSheet()->getStyle('D15:D'.($i-1))->applyFromArray(
	array(
		'fill' => array(
			'type' => PHPExcel_Style_Fill::FILL_SOLID,
			'color' => array('rgb' => 'F4D2D2')
			)
		)
	);

	
	$objPHPExcel->getActiveSheet()->getStyle('A1:C1')->applyFromArray($heading);
	$objPHPExcel->getActiveSheet()->getStyle('C2:C10')->applyFromArray($categoryheaderstyle);
	$objPHPExcel->getActiveSheet()->getStyle('A2:A10')->applyFromArray($categoryheaderstyle);
	$objPHPExcel->getActiveSheet()->getStyle('A2:C10')->applyFromArray($borderStyle);
	// $objPHPExcel->getActiveSheet()->getStyle('A14:C14')->applyFromArray($categoryheaderstyle);
	$objPHPExcel->getActiveSheet()->getStyle('A14:D14')->applyFromArray($columnheaderstyle);

	$objPHPExcel->getActiveSheet()->getStyle('A14:B14')->applyFromArray($borderStyle);
	$objPHPExcel->getActiveSheet()->getStyle('B14:C14')->applyFromArray($borderStyle);
	$objPHPExcel->getActiveSheet()->getStyle('C14:D14')->applyFromArray($borderStyle);

	
	$objPHPExcel->getActiveSheet()
    ->getStyle('A')
    ->getAlignment()
    ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

    $objPHPExcel->getActiveSheet()
    ->getStyle('B')
    ->getAlignment()
    ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	
	
	
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(6);
	$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
	$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
	$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
    
	$objPHPExcel->getActiveSheet()->getHeaderFooter()->setOddHeader('&L&G&C&HPlease treat this document as confidential!');
	$objPHPExcel->getActiveSheet()->getHeaderFooter()->setOddFooter('&L&B' . $objPHPExcel->getProperties()->getTitle() . '&RPage &P of &N');

	$objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
	$objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);

	$objPHPExcel->getActiveSheet()->setTitle('Printing');

	$objPHPExcel->setActiveSheetIndex(0);

	$callStartTime = microtime(true);	
	
	
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
	$objWriter->save($folder.'/'.$filename.date('dmY').'.xlsx');
	return 1;
}
function Create_Attendance_timesheet($result,$folder,$name,$selected_date)
{
	error_reporting(E_ALL);
	ini_set('display_errors', TRUE);
	ini_set('display_startup_errors', TRUE);

	define('EOL',(PHP_SAPI == 'cli') ? PHP_EOL : '<br />');
	date_default_timezone_set('Europe/London');
	
	require_once dirname(__FILE__) . '/Classes/PHPExcel.php';
	
	$objPHPExcel = new PHPExcel();

	
	$objPHPExcel->getProperties()->setCreator("Maarten Balliauw")
								 ->setLastModifiedBy("Maarten Balliauw")
								 ->setTitle("Office 2007 XLSX Test Document")
								 ->setSubject("Office 2007 XLSX Test Document")
								 ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
								 ->setKeywords("office 2007 openxml php")
								 ->setCategory("Test result file");
	
	$objPHPExcel->getActiveSheet()->setCellValue('A1',$result[0]['number'].'-'.$result[0]['division_name']);
	
	$objPHPExcel->getActiveSheet()->setCellValue('A2', 'Class Name');
	$objPHPExcel->getActiveSheet()->setCellValue('A3', 'Class Id');	
	$objPHPExcel->getActiveSheet()->setCellValue('A4', 'Division Name');
	$objPHPExcel->getActiveSheet()->setCellValue('A5', 'Division id');
	$objPHPExcel->getActiveSheet()->setCellValue('A6', 'Date');
	$objPHPExcel->getActiveSheet()->setCellValue('A7', 'Academic Year');
	$objPHPExcel->getActiveSheet()->setCellValue('G2', 'Present Status');
	$objPHPExcel->getActiveSheet()->setCellValue('C2', $result[0]['number']);
	$objPHPExcel->getActiveSheet()->setCellValue('C3', $result[0]['id']);
	$objPHPExcel->getActiveSheet()->setCellValue('C4', $result[0]['division_name'].' '.$result[0]['calendar_year_name']);
	$objPHPExcel->getActiveSheet()->setCellValue('C5', $result[0]['division_id']);
	$objPHPExcel->getActiveSheet()->setCellValue('C6', $selected_date);
	$objPHPExcel->getActiveSheet()->setCellValue('C7', $result[0]['calendar_year_id']);	
	$objPHPExcel->getActiveSheet()->setCellValue('A10', 'No');
	$objPHPExcel->getActiveSheet()->setCellValue('B10', 'Student Id');
	$objPHPExcel->getActiveSheet()->setCellValue('C10', 'Student Name');
	$objPHPExcel->getActiveSheet()->setCellValue('D10', 'Present/Absent');
	$objPHPExcel->getActiveSheet()->setCellValue('E10', 'Reason');
	$objPHPExcel->getActiveSheet()->setCellValue('G3', 'Present');
	$objPHPExcel->getActiveSheet()->setCellValue('H3', 'P');
	$objPHPExcel->getActiveSheet()->setCellValue('G4', 'Absent');
	$objPHPExcel->getActiveSheet()->setCellValue('H4', 'A');
		$i=11;
		foreach ($result as $student)
 		{
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$i, $i-10);
			$objPHPExcel->getActiveSheet()->setCellValue('B'.$i, $student['student_id']);
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$i, $student['first_name'].' '.$student['last_name']);
			$i++;
		}
		
		// print_r($selected_date);die;	
			// $objPHPExcel->getActiveSheet()->setCellValue('D10',$selected_date);

	$heading = array(
		'font'  => array(
			'bold'  => true,
			'color' => array('rgb' => 'FFFFFF'),
			'size'  => 18,
			'name'  => 'Calibri'
		),
		'alignment' => array(
            'wrap'       => true,
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        ),
	);	
	$categoryheaderstyle = array(
		'font'  => array(
			'bold'  => true,
			'color' => array('rgb' => '000000'),
			'size'  => 12,
			'name'  => 'Calibri'
		),
		'alignment' => array(
            'wrap'       => true,
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        ),
	);
	
	$columnheaderstyle = array(
		'font'  => array(
			'bold'  => true,
			'color' => array('rgb' => '000000'),
			'size'  => 12,
			'name'  => 'Calibri'
		),
		'alignment' => array(
            'wrap'       => true,
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        ),
	);
	$borderStyle = array('borders' =>
			                array('outline' =>
			                        array('style' => PHPExcel_Style_Border::BORDER_THIN,
			                                'color' => array('argb' => '000000'),   ),),);
	$objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(30);

	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:C1');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A2:B2');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A3:B3');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A4:B4');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A5:B5');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A6:B6');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A7:B7');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A8:C8');
	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('G2:H2');
	
	// for($i=11;$i<sizeof($student);$i++)
	// {
	// 	$objPHPExcel->setActiveSheetIndex(0)->mergeCells('B'.$i.':C'.$i);
	// }
	
	$objPHPExcel->getActiveSheet()->getStyle('A1:C1')->applyFromArray(
		array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '771f5c')
			)
		)
	);
	$objPHPExcel->getActiveSheet()->getStyle('G2:H4')->applyFromArray(
		array(
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'F4D2D2')
			)
		)
	);
	
	$objPHPExcel->getActiveSheet()->getStyle('A1:C1')->applyFromArray($heading);
	$objPHPExcel->getActiveSheet()->getStyle('C2:C7')->applyFromArray($categoryheaderstyle);
	$objPHPExcel->getActiveSheet()->getStyle('A2:A7')->applyFromArray($categoryheaderstyle);
	$objPHPExcel->getActiveSheet()->getStyle('G2:H4')->applyFromArray($borderStyle);
	$objPHPExcel->getActiveSheet()->getStyle('A8:C8')->applyFromArray($categoryheaderstyle);
	$objPHPExcel->getActiveSheet()->getStyle('A10:E10')->applyFromArray($columnheaderstyle);
	$objPHPExcel->getActiveSheet()->getStyle('G2:H2')->applyFromArray($columnheaderstyle);
	$objPHPExcel->getActiveSheet()->getStyle('D9')->applyFromArray($columnheaderstyle);
	
	$objPHPExcel->getActiveSheet()
    ->getStyle('A10:A1000')
    ->getAlignment()
    ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

    $objPHPExcel->getActiveSheet()
    ->getStyle('B')
    ->getAlignment()
    ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	
	
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(6);
	$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
	$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
	$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
	$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
	// $column = 'D';
	// $lastRow = $objPHPExcel->getActiveSheet()->getHighestRow();
	// for ($row = 10; $row <= $lastRow; $row++) 
	// {
	//     $cell = $objPHPExcel->getActiveSheet()->getCell($column.$row);
	//     $objPHPExcel->getActiveSheet()->getColumnDimension($cell)->setWidth(6);
	// }
	
    
	$objPHPExcel->getActiveSheet()->getHeaderFooter()->setOddHeader('&L&G&C&HPlease treat this document as confidential!');
	$objPHPExcel->getActiveSheet()->getHeaderFooter()->setOddFooter('&L&B' . $objPHPExcel->getProperties()->getTitle() . '&RPage &P of &N');

	$objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
	$objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);

	$objPHPExcel->getActiveSheet()->setTitle('Printing');

	$objPHPExcel->setActiveSheetIndex(0);

	$callStartTime = microtime(true);	
	
	
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
	$objWriter->save($folder.'/'.$name.date('dmY').'.xlsx');
	return 1;
}
function read_sheet($file)
{
	require_once dirname(__FILE__) . '/Classes/PHPExcel/IOFactory.php';


	$inputFileName = $file;

	//  Read your Excel workbook
	try {
		$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
		$objReader = PHPExcel_IOFactory::createReader($inputFileType);
		$objPHPExcel = $objReader->load($inputFileName);
	} catch (Exception $e) {
		die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
	}
	
	$rowIterator = $objPHPExcel->getActiveSheet()->getRowIterator();
	$array_data = array();
	
	$index=0;
	foreach ($rowIterator as $row) {
		
		
		
		$cellIterator = $row->getCellIterator();
		// $cellIterator->setIterateOnlyExistingCells(false);
		$rowIndex = $row->getRowIndex();	
		$array_data[$rowIndex]= array('A' => '', 'B' => '', 'C' => '', 'D' => '', 'E' => '');
		// echo '<pre>';
		// print_r($cellIterator);die;

		foreach ($cellIterator as $cell) 
		{
			if ('A' == $cell->getColumn()) {
				$array_data[$rowIndex][$cell->getColumn()] = $cell->getCalculatedValue();	
			} else if ('B' == $cell->getColumn()) {
				$array_data[$rowIndex][$cell->getColumn()] = $cell->getCalculatedValue();
			} else if ('C' == $cell->getColumn()) {
				$array_data[$rowIndex][$cell->getColumn()] = $cell->getCalculatedValue();
			} 
			else if ('D' == $cell->getColumn()) {
				$array_data[$rowIndex][$cell->getColumn()] = $cell->getCalculatedValue();
			} 


		}
		$index++;
		if($index==100)
		{
			break;
		}

		
	}
	// echo'<pre>';
	// 	print_r($array_data);die;
	// unset($array_data[1]);
	// unset($array_data[2]);
	
	//echo '<pre>';
	return $array_data;
}
function read_sheet_attendance($file)
{
	require_once dirname(__FILE__) . '/Classes/PHPExcel/IOFactory.php';


	$inputFileName = $file;

	//  Read your Excel workbook
	try {
		$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
		$objReader = PHPExcel_IOFactory::createReader($inputFileType);
		$objPHPExcel = $objReader->load($inputFileName);
	} catch (Exception $e) {
		die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
	}
	$array_data = array();
	
		$lastColumn =$objPHPExcel->getActiveSheet()->getHighestDataColumn();
		$lastRow =$objPHPExcel->getActiveSheet()->getHighestDataRow();
		$highestColumnIndex = PHPExcel_Cell::columnIndexFromString($lastColumn);
			$row2=10;
			$i=0;
			$class_id = $objPHPExcel->getActiveSheet()->getCellByColumnAndRow('2','3');
			$class_id =$class_id->getValue();
			$division_id = $objPHPExcel->getActiveSheet()->getCellByColumnAndRow('2','5');
			$division_id =$division_id->getValue();
			$date = $objPHPExcel->getActiveSheet()->getCellByColumnAndRow('2','6');
			$date =$date->getValue();
			$calendar_year_id = $objPHPExcel->getActiveSheet()->getCellByColumnAndRow('2','7');
			$calendar_year_id =$calendar_year_id->getValue();
			$data['class_id']=$class_id;
			$data['division_id']=$division_id;
			$data['date']=$date;
			$data['calendar_year_id']=$calendar_year_id;
			for ($row=11; $row <=$lastRow; $row++)
			 {
			 	$student_id = $objPHPExcel->getActiveSheet()->getCellByColumnAndRow('1', $row);
			 	$data['data'][$i]['student_id'] =$student_id->getValue();
			 	
			 	$val=array();

				$cell = $objPHPExcel->getActiveSheet()->getCellByColumnAndRow('3', $row);
				$reson = $objPHPExcel->getActiveSheet()->getCellByColumnAndRow('4', $row);
				if(($cell->getValue()=='A')||($cell->getValue()=='a'))
				{
					$val=$cell->getValue();
					$reason=$reson->getValue();
					$data['data'][$i]['reason']=$reason;
				}
				if($cell->getValue()=='P')
				{
					$val=$cell->getValue();
				}
				
				
				$data['data'][$i]['status']=$val;
				$i++;
			
			}

	return $data;
}
?>
