<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
function pdf_create($html, $filename='', $stream=TRUE ,$invoice_id, $type) 
{
    require_once("dompdf/dompdf_config.inc.php");
	
	if (get_magic_quotes_gpc()){
		$html = stripslashes($html);
	}
	
    $dompdf = new DOMPDF();
	
    $dompdf->load_html($html);
	
	$dompdf->set_paper("a4", "portrait");
	
    $dompdf->render();
		
	$timestamp = date('YmdGis').$invoice_id;

	$filename = $timestamp.'.pdf';	
	
    if ($stream) {
        $dompdf->stream($filename);
    } else {
		if($type=='payout_report')
		{
			$CI =& get_instance();
			$CI->load->helper('file');
			write_file("payout_report/".$filename, $dompdf->output());
			return $filename;
		}	
		if($type=='psr_county')
		{
			$CI =& get_instance();
			$CI->load->helper('file');
			write_file("report/production_report/county/".$filename, $dompdf->output());
			return $filename;
		}
		if($type=='psr_city')
		{
			$CI =& get_instance();
			$CI->load->helper('file');
			write_file("report/production_report/city/".$filename, $dompdf->output());
			return $filename;
		}	
		if($type=='psr_agent')
		{
			$CI =& get_instance();
			$CI->load->helper('file');
			write_file("report/production_report/agent/".$filename, $dompdf->output());
			return $filename;
		}	
		if($type=='psr_subagent')
		{
			$CI =& get_instance();
			$CI->load->helper('file');
			write_file("report/production_report/subagent/".$filename, $dompdf->output());
			return $filename;
		}	
		if($type=='psr_product')
		{
			$CI =& get_instance();
			$CI->load->helper('file');
			write_file("report/production_report/product/".$filename, $dompdf->output());
			return $filename;
		}	
		if($type=='psr_county_commission')
		{
			$CI =& get_instance();
			$CI->load->helper('file');
			write_file("report/commission_report/county/".$filename, $dompdf->output());
			return $filename;
		}
		if($type=='psr_agent_commission')
		{
			$CI =& get_instance();
			$CI->load->helper('file');
			write_file("report/commission_report/agent/".$filename, $dompdf->output());
			return $filename;
		}	
		if($type=='psr_subagent_commission')
		{
			$CI =& get_instance();
			$CI->load->helper('file');
			write_file("report/commission_report/subagent/".$filename, $dompdf->output());
			return $filename;
		}			
    }
}
?>