<?php

class timetable_model extends model
{
	function add_timetable_details($timetable_info)
	{
		$this->db->insert('SL_time_table', $timetable_info);
		$return_value = $this->db->insert_id();
		return 	$return_value;
	}
	function get_last_row()
	{
		$query = $this->db->query("SELECT MAX(time_table_id) as last_id 
										FROM SL_time_table"
								);
		$return_array = $query->row_array();		
		return $return_array['last_id']+1;
	}
	function get_corresponding_period($day_of_week,$class,$syllabus,$period_number)
	{
		$query = $this->db->query("SELECT period_id
										FROM SL_period
										WHERE day_of_week_id=".$day_of_week."
										AND class_id=".$class."
										AND syllabus_id=".$syllabus."
										AND period_number=".$period_number
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
	function get_current_class_id($class_id)
	{
		$query = $this->db->query("SELECT *
										FROM SL_class
										WHERE id=".$class_id."
										AND school_id=".$this->session->userdata('school_id')
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
	function get_current_division($divison_id)
	{
		$query = $this->db->query("SELECT cd.id as division,cd.name,cd.syllabus_id,cd.calendar_year_id,sy.syllabus_name,cy.calendar_year_name
										FROM SL_class_division as cd 
										INNER JOIN SL_syllabus as sy 
										ON cd.syllabus_id=sy.syllabus_id
										INNER JOIN SL_calendar_year as cy 
										ON cd.calendar_year_id=cy.calendar_year_id
										WHERE cd.id=".$divison_id."
										AND cd.end_date='".('2099-12-12 23:59:59')."'"
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
	function get_current_day_of_week($day_of_week)
	{
		$query = $this->db->query("SELECT *
										FROM SL_day_of_week
										WHERE day_of_week_id=".$day_of_week
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
	function get_all_period_details_class($class_id,$syllabus_id)
	{
		$query = $this->db->query("SELECT DISTINCT pd.period_name
										FROM SL_period as pd
										INNER JOIN SL_day_of_week as dw
										ON pd.day_of_week_id=dw.day_of_week_id
										WHERE pd.class_id=".$class_id."
										AND pd.syllabus_id=".$syllabus_id
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	function get_count_day_of_week($class_id,$syllabus_id)
	{
		$query = $this->db->query("SELECT  DISTINCT dw.day_of_week
										FROM SL_period as pd
										INNER JOIN SL_day_of_week as dw
										ON pd.day_of_week_id=dw.day_of_week_id
										WHERE pd.class_id=".$class_id."
										AND pd.syllabus_id=".$syllabus_id."
										ORDER BY dw.day_of_week_id ASC"
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	function get_all_subject_curent_class($class_id,$syllabus_id)
	{
		$query = $this->db->query("SELECT *
										FROM SL_subject_child
										WHERE class_id=".$class_id."
										AND syllabus_id=".$syllabus_id."
										AND end_date='".date('2099-12-12 23:59:59')."'"
								);
		$return_array = $query->result_array();	
		// echo $this->db->last_query();die;	
		return $return_array;
	}
	function get_subject_tutor($subject_id)
	{
		$query = $this->db->query("SELECT sct.*,sc.subject_child_name,tt.first_name,tt.last_name,tt.tutor_id
										FROM SL_subject_class_tutor as sct
										INNER JOIN SL_subject_child as sc
										ON sct.subject_child_id=sc.subject_child_id
										INNER JOIN SL_tutor as tt 
										ON sct.tutor_id=tt.tutor_id
										WHERE sct.subject_child_id=".$subject_id."
										AND sct.staff_release_date='".date('2099-12-12 23:59:59')."'
										AND tt.school_id=".$this->session->userdata('school_id')."
										AND sc.end_date='".date('2099-12-12 23:59:59')."'"
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	
	function get_timetable_details($division)
	{
		$query = $this->db->query("SELECT tt.time_table_id,tt.day_of_week_id,tu.tutor_id,p.period_name,p.period_id,tu.first_name,tu.last_name,tt.subject_child_id,sbc.subject_child_name,p.start_time,p.end_time
										FROM SL_time_table as tt
										INNER JOIN SL_tutor as tu
										ON tt.subject_class_tutor_id=tu.tutor_id
										INNER JOIN SL_subject_child as sbc
										ON tt.subject_child_id=sbc.subject_child_id
										INNER JOIN SL_period as p 
										ON tt.period_id=p.period_id
										WHERE tt.class_division_id=".$division."
										AND sbc.end_date='".date('2099-12-12 23:59:59')."'
										AND tt.end_date='".date('2099-12-12 23:59:59')."'
										AND tu.school_id=".$this->session->userdata('school_id')."
										ORDER BY p.period_id  ASC
										limit 0,35"

								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	function get_curent_period_number($condition)
	{
		$query = $this->db->query("SELECT *
										FROM SL_period
										WHERE ".$condition
								);
		$return_array = $query->result_array();		
		return $return_array;
	}

	function get_all_tutor($timetable)
	{
		$query = $this->db->query("SELECT tt.period_id, tu.first_name,tu.last_name,tt.subject_child_id,tt.id, tu.tutor_id, tt.subject_class_tutor_id
										FROM SL_time_table as tt
										INNER JOIN SL_tutor as tu
										ON tt.subject_class_tutor_id=tu.tutor_id
										WHERE tt.id=".$timetable."
										AND tu.school_id=".$this->session->userdata('school_id')
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	function get_all_time_table_details($class_id,$divison_id)
	{
		$query = $this->db->query("SELECT *
										FROM SL_time_table
										WHERE class_id=".$class_id."
										AND class_division_id=".$divison_id
								);
		$return_array = $query->row_array();		
		return $return_array;
	}

	function get_timetable($timetable)
	{
		$query = $this->db->query("SELECT *
										FROM SL_time_table
										WHERE id=".$timetable
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
		function update_timetable_details($timetable_info,$timetable,$old_start_date)
	{
		$this->db->where('time_table_id', $timetable);
		$this->db->where('start_date', $old_start_date);
		$this->db->update('SL_time_table', $timetable_info);
		$result=$this->db->affected_rows();	
		
		return $result;
	}
	function get_individual_time_table_details($timetable)
	{
		$query = $this->db->query("SELECT tt.*,cl.number,p.period_name,dw.day_of_week,tu.first_name,tu.last_name, sc.subject_child_name,sy.syllabus_name,cy.calendar_year_name,cd.name
										FROM SL_time_table as tt
										INNER JOIN SL_tutor as tu
									    ON tt.subject_class_tutor_id=tu.tutor_id
										INNER JOIN SL_subject_child as sc
										ON tt.subject_child_id=sc.subject_child_id
										INNER JOIN SL_class_division as cd
										ON tt.class_division_id=cd.id
										INNER JOIN SL_class as cl
										ON cd.class_id=cl.id
										INNER JOIN SL_day_of_week as dw 
										ON tt.day_of_week_id=dw.day_of_week_id
										INNER JOIN SL_period as p
										ON tt.period_id=p.period_id
										INNER JOIN SL_syllabus as sy
										ON tt.syllabus_id=sy.syllabus_id
										INNER JOIN SL_calendar_year as cy
										ON tt.calendar_year_id=cy.calendar_year_id
										WHERE tt.time_table_id=".$timetable."
										AND sc.end_date='".date('2099-12-12 23:59:59')."'
										AND tu.school_id=".$this->session->userdata('school_id')."
										AND cl.school_id=".$this->session->userdata('school_id')."
										AND tt.end_date='".date('2099-12-12 23:59:59')."'"
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
	function get_all_day_of_week()
	{
		$query = $this->db->query("SELECT *
										FROM SL_day_of_week"
										
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	function get_all_period_student($classid)
	{
		$query = $this->db->query("SELECT *
										FROM SL_period
										WHERE class_id=".$classid." ORDER BY period_number ASC"
										
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	function get_all_period($classid,$syllabus_id)
	{
		$query = $this->db->query("SELECT *
										FROM SL_period
										WHERE class_id=".$classid."
										AND syllabus_id=".$syllabus_id."
										ORDER BY period_number ASC"
										
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	function get_current_period($period_id)
	{
		$query = $this->db->query("SELECT *
										FROM SL_period
										WHERE id=".$period_id
										
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
	function get_current_class($division)
	{
		$query = $this->db->query("SELECT c.id as classid
										FROM SL_class_division as cd
										INNER JOIN SL_class as c 
										ON c.id=cd.class_id
										WHERE cd.id=".$division."
										AND c.school_id=".$this->session->userdata('school_id')
										
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
	function get_all_division_name($class_id,$tutor_id)
	{
		$query = $this->db->query("SELECT cd.id, cd.name
										FROM SL_subject_class_tutor as sct 
										INNER JOIN SL_class_division as cd 
										ON sct.class_division_id=cd.id
										WHERE cd.class_id=".$class_id."
										AND sct.tutor_id=".$tutor_id."
										AND cd.end_date='".date('2099-12-12 23:59:59')."'
										GROUP BY cd.name"
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	function get_curesponding_syllabus($division_id)
	{
		$query = $this->db->query("SELECT syllabus_id
										FROM SL_class_division 
										WHERE id=".$division_id."
										AND end_date='".date('2099-12-12 23:59:59')."' "
										
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
	function get_parent_students($user_id)
	{
		$query = $this->db->query("SELECT st.student_id,st.first_name,st.last_name
										FROM SL_parent_student_relation as psr 
										INNER JOIN SL_student as st 
										ON psr.student_id=st.student_id
										WHERE psr.parent_id=".$user_id."
										AND st.school_id=".$this->session->userdata('school_id')."
										AND psr.end_date='".date('2099-12-12 23:59:59')."'
										GROUP BY st.student_id"
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	function get_student_division($user_id)
	{
		$query = $this->db->query("SELECT sac.class_division_id,cd.class_id,cd.syllabus_id
										FROM SL_student_academic as sac 
										INNER JOIN SL_class_division as cd 
										ON sac.class_division_id=cd.id
										WHERE sac.student_id=".$user_id."
										AND cd.end_date='".date('2099-12-12 23:59:59')."'
										AND sac.completing_date='".date('2099-12-12 23:59:59')."'"
								);
		$return_array = $query->row_array();		
		return $return_array;
	}
	function get_student_class($user_id)
	{
		$query = $this->db->query("SELECT st.student_id,st.first_name,st.last_name
										FROM SL_student_academic as sac
										INNER JOIN SL_student as st 
										ON sac.student_id=st.student_id
										WHERE sac.student_id=".$user_id."
										AND st.school_id=".$this->session->userdata('school_id')."
										AND sac.completing_date='".date('2099-12-12 23:59:59')."'
										GROUP BY st.student_id"
								);
		$return_array = $query->result_array();		
		return $return_array;
	}
	
	

}

?>