<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class TeacherDetail extends Controller {

	function TeacherDetail()
	{
		
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}

		$this->load->model('teacher_model');
	}
	
	function index()
	{
		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');

		$teacher_id=$_GET['tutor_id'];
		$show_data['teacher_details'] = $this->teacher_model->get_teacher_details($teacher_id);
		if(isset($_POST['edit_tutor']))
		{
			$this->load->library('form_validation');			
			$config = array(	
           array(
                 'field'   => 'f_name', 
                 'label'   => 'First Name', 
                 'rules'   => 'required'
              ),
           array(
                 'field'   => 'm_name', 
                 'label'   => 'Middle Name', 
                 //'rules'   => 'required'
              ),
		   array(
                 'field'   => 'l_name', 
                 'label'   => 'Last Name', 
                 'rules'   => 'required'
              ),
		   array(
                 'field'   => 'dob', 
                 'label'   => 'Date Of Birth', 
                 'rules'   => 'required'
                ),
		      array(
                 'field'   => 'address', 
                 'label'   => 'Address', 
                 'rules'   => 'required'
                ),

		   array(
                 'field'   => 'place', 
                 'label'   => 'Place', 
                 'rules'   => 'required'
                //'rules'   => 'required|exact_length[10]'
                // 'rules'   => 'required|is_unique[ls_agent.email]|valid_email'
              ),	
              array(
                 'field'   => 'city', 
                 'label'   => 'City', 
                 'rules'   => 'required'
              ),
                 array(
                 'field'   => 'postal_code', 
                 'label'   => 'Postal Code', 
                 'rules'   => 'required'
              ),	
                 array(
                 'field'   => 'email', 
                 'label'   => 'Email', 
                 'rules'   => 'required|is_unique[ls_agent.email]|valid_email'
              ),
                 array(
                 'field'   => 'contact_number', 
                 'label'   => 'Contact Number', 
                 'rules'   => 'required'
              ),
                array(
                 'field'   => 'card_type', 
                 'label'   => 'Card Type', 
                 'rules'   => 'required'
              ),
                array(
                 'field'   => 'id_card_code', 
                 'label'   => 'Card Code', 
                 'rules'   => 'required'
              ),
                array(
                 'field'   => 'subject', 
                 'label'   => 'Subject', 
                 'rules'   => 'required'
              ),	
                 array(
                 'field'   => 'twitter_id', 
                 'label'   => 'Twitter', 
                 'rules'   => 'required'
              ),
              array(
                 'field'   => 'facebook_id', 
                 'label'   => 'Facebook', 
                 'rules'   => 'required'
              )              
			);

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				
				$teacher_info = array();				
				$teacher_id = $this->input->post('tutor_id');
				$teacher_info['first_name'] = $this->input->post('f_name');
				$teacher_info['middle_name'] = $this->input->post('m_name');
				$teacher_info['last_name'] = $this->input->post('l_name');
				$dob = new DateTime($this->input->post('dob'));
				$teacher_info['date_of_birth'] =$dob->format('Y-m-d');
				$teacher_info['address'] = $this->input->post('address');
				$teacher_info['place'] = $this->input->post('place');
				$teacher_info['city'] = $this->input->post('city');
				$teacher_info['postal_code'] = $this->input->post('postal_code');
				$teacher_info['email'] = $this->input->post('email');
				$mobile_no= substr($this->input->post('contact_number'),-9);
				$teacher_info['contact_no']  = str_pad($mobile_no,13,'+254',STR_PAD_LEFT);
				$teacher_info['id_card_type_id'] = $this->input->post('card_type');
				$teacher_info['id_card_type_code'] = $this->input->post('id_card_code');
				$teacher_info['status'] =1;
				$teacher_info['subject_id'] = $this->input->post('subject');
				$teacher_info['twitter_id'] = $this->input->post('twitter_id');
				$teacher_info['facebook_id'] = $this->input->post('facebook_id');
				$teacher_info['about_us'] = 'tutor  '.$this->input->post('f_name').' '.$this->input->post('last_name').'  and your address is  '.$this->input->post('address').' '.$this->input->post('place').'	'.$this->input->post('city').'	details';
				session_start();
				if(isset($_SESSION['crop_image']))
				{
				$file_name=explode('/', $_SESSION['crop_image']);
				$teacher_info['profile_pic'] = $file_name[3];
				
				}
				session_destroy();
				$result = $this->teacher_model->updated_teacher_details($teacher_id,$teacher_info);		
				if ($result>0)
				{
					$this->success('<p class="success">Tutor Details has been Updated successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
					exit;
				}
				else
				{
					$this->success('<p class="success">Tutor Details has been Updated unsuccessfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
			}
		}
		if(isset($_POST['edit_tutors_about_us']))
		{
				$this->load->library('form_validation');			
				$config = array(	
				      array(
	                     'field'   => 'about_us', 
	                     'label'   => 'About Us', 
	                     'rules'   => 'required'
	                    )
					);

				$this->form_validation->set_rules($config);
				if($this->form_validation->run() != false)
				{
					
					$teacher_info = array();
					$teacher_id =$this->input->post('tutor_id');				
					$teacher_info['about_us'] = $this->input->post('about_us');

					$result = $this->teacher_model->updated_teacher_details($teacher_id,$teacher_info);		
					if ($result>0)
					{
						$this->success('<p class="success">Tutor About Us has been Updated successfully</p>');
						redirect($_SERVER['HTTP_REFERER']);
						exit;
					}
					else
					{
						$this->success('<p class="success">Tutor About Us has been Updated unsuccessfully</p>');
						redirect($_SERVER['HTTP_REFERER']);
					}
				}
		}
		$this->load->view('teacherdetails_view',$show_data);
	}
		function edit()
	{

		$ret_result='';
		if(isset($_POST['id']))
		{
			$tutor_id=$_POST['id'];
			$tutor_details=$this->teacher_model->get_teacher_details($tutor_id);
			$select_subject=$this->teacher_model->get_all_subject();
			if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
			{
			 $ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
							<script>
						        $(document).ready(function(){			
									$("#dob").datepicker({
									maxDate: 0,
									changeMonth: true,
									changeYear: true,
									showButtonPanel: true,
									dateFormat: "dd-mm-yy",
									yearRange:"1900:"
								}); 
								});
						      </script>
						      <div class="pogin__popuphd" style="text-transform:uppercase">
								<h2> Edit Tutor Details</h2>
								<div class="close__btn" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="edit_teacher_registration" id="edit_teacher_registration" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												First Name				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$tutor_details['first_name'].'" class="input" name="f_name" id="f_name" placeholder="First Name">
												<div id="error_f_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Middle Name				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$tutor_details['middle_name'].'" class="input" name="m_name" id="m_name" placeholder="Middle Name">
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Last Name				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$tutor_details['last_name'].'" class="input" name="l_name" id="l_name" placeholder="Last Name">	
												<div id="error_l_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Date Of Birth				
											</label>
											<div class="input__area">				
												<input type="date" value="'.$tutor_details['date_of_birth'].'" class="input" name="dob" id="dob" placeholder="Date Of Birth">
												<div id="error_dob" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Contact No				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$tutor_details['contact_no'].'" class="input" name="contact_number" id="contact_number" placeholder="Contact Number">
												<div id="error_contact_number" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>';
										switch ($tutor_details['id_card_type_id']) 
													{
														case 'Election ID':
															$selected = '<option value="">Select Card Type</option>
					                                            		<option value="Election ID" selected>Election ID</option>
					                                            		<option value="Pand Card">Pand Card</option>
					                                            		<option value="Driving ID">Driving ID</option>
						                                            	<option value="Passport ID">Passport ID</option>';
														break;

														case 'Pand Card':
															$selected = '<option value="">Select Card Type</option>
					                                            		<option value="Election ID">Election ID</option>
					                                            		<option value="Pand Card" selected>Pand Card</option>
					                                            		<option value="Driving ID">Driving ID</option>
						                                            	<option value="Passport ID">Passport ID</option>';
														break;

														case 'Driving ID':
															$selected = '<option value="">Select Card Type</option>
					                                            		<option value="Election ID">Election ID</option>
					                                            		<option value="Pand Card">Pand Card</option>
					                                            		<option value="Driving ID" selected>Driving ID</option>
						                                            	<option value="Passport ID">Passport ID</option>';

														break;

														case 'Passport ID':
															$selected = '<option value="">Select Card Type</option>
					                                            		<option value="Election ID">Election ID</option>
					                                            		<option value="Pand Card">Pand Card</option>
					                                            		<option value="Driving ID">Driving ID</option>
						                                            	<option value="Passport ID" selected>Passport ID</option>';
														break;
													}
									$ret_result.='<div class="content_form" role="user-name">
											<label style="padding:0;">
												ID Card Type				
											</label>
											<div class="input__area">
												<select class="input arrow" name="card_type" id="card_type">';
                                            	$ret_result.=$selected;
                                            	 $ret_result.='</select>			
												<div id="error_card_type" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												ID Card Code				
											</label>
											<div class="input__area">				
												<input type="text" value="'.$tutor_details['id_card_type_code'].'" class="input" name="id_card_code" id="id_card_code" placeholder="ID Card Code">
												<div id="error_id_card_code" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Specification		
											</label>
											<div class="input__area">					
												<select class="input arrow" name="subject" id="subject">
	                                            	<option value="">Select Specification</option>';

	                                            		foreach ($select_subject as $subject) 
	                                            		{
	                                            			$selected = $tutor_details['subject_id']==$subject['subject_id']?'selected':'';
	                                            			$ret_result.='<option value="'.$subject['subject_id'].'"'.$selected.'>'.$subject['subject_name'].'</option>';
	                                            		}


											    $ret_result.='</select>
											    <div id="error_subject" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Address				
											</label>
											<div class="input__area">				
												<textarea name="address" id="address" class="input">'.$tutor_details['address'].'</textarea>
												<div id="error_address" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Place				
											</label>
											<div class="input__area">				
												<input type="text" value="'.$tutor_details['place'].'" class="input" name="place" id="place" placeholder="Place">
												<div id="error_place" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>						
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												City				
											</label>
											<div class="input__area">				
												<input type="text" value="'.$tutor_details['city'].'" class="input" name="city" id="city" placeholder="City">
												<div id="error_city" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>		

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Postal Code				
											</label>
											<div class="input__area">				
												<input type="text" value="'.$tutor_details['postal_code'].'" class="input" name="postal_code" id="postal_code" placeholder="Postal Code">
												<div id="error_postal_code" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>		
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Email				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$tutor_details['email'].'" class="input" name="email" id="email" placeholder="Email">
												<div id="error_email" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>	
										<div class="field" role="user-name">
											<label style="padding:0;">
												Twitter				
											</label>	
											<div class="input__area">			
												<input type="text" value="'.$tutor_details['twitter_id'].'" class="input" name="twitter_id" id="twitter_id" placeholder="Twitter">
												<div id="error_twitter_id" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="field" role="user-name">
											<label style="padding:0;">
												Facebook				
											</label>
											<div class="input__area">				
												<input type="text" value="'.$tutor_details['facebook_id'].'" class="input" name="facebook_id" id="facebook_id" placeholder="Facebook">
												<div id="error_facebook_id" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="field" role="user-name">
											<label style="padding:0;">
												Profile Pic				
											</label>
											<div class="input__area">			
												<a class="attendance_view_link" href="javascript:void(0);" alt="register" onclick="crop_image()">
													<div class="profile_crop_image" id="crop_again"></div>
												</a>
												<div id=" " class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>	
										<div class="field" role="user-name">
											<label style="padding:0;">			
											</label>
											<div class="button">				
												<input type="submit" name="edit_tutor" id="edit_tutor" class="submit__button" value="Submit" onclick="return edit_teacher_registration_validation()">
												<input type="hidden" name="tutor_id" value="'.$tutor_id.'">
												<input type="reset" name="edit_tutor" id="edit_tutor" class="submit__button" value="Cancel">
											</div>
										</div>									
									</div>
								</div>
							</form>
							';
									
									
					echo $ret_result;
					//exit;
			}
	 	}
	}
	function edit_about_us()
	{

		$ret_result='';
		if(isset($_POST['id']))
		{
			$tutor_id=$_POST['id'];
			$tutor_details=$this->teacher_model->get_teacher_details($tutor_id);
			if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
			{
			 $ret_result.=' <div class="pogin__popuphd" style="text-transform:uppercase">
								<h2> Edit About Us</h2>
								<div class="close__btn" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="edit_tutor_about_us" id="edit_tutor_about_us" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												About Us				
											</label>
											<div class="input__area">				
												<textarea style="height:371px;width: 294px;"name="about_us" id="about_us" class="input">'.$tutor_details['about_us'].'</textarea>
												<div id="error_about_us" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="field" role="user-name">
											<label style="padding:0;">			
											</label>
											<div style="margin: 0 15px 0 auto;">				
												<input type="submit" name="edit_tutors_about_us" id="edit_tutors_about_us" class="submit__button_tutor" value="Submit" onclick="return edit_tutor_about_us_validation()">
												<input type="hidden" name="tutor_id" value="'.$tutor_id.'">
												<input type="reset" name="edit_tutors_about_us" id="edit_tutors_about_us" class="submit__button_tutor" style="margin-left:65px !important;" value="Cancel">
											</div>
										</div>									
									</div>
								</div>
							</form>
							';
									
									
					echo $ret_result;
					//exit;
			}
	 	}
	}
 private function success($message)
  {
        $userdata = array(
            'success' => $message
        );
        $this->session->set_userdata($userdata);
    }

    private function clearmessage() {
        $userdata = array(
            'success' => ''
        );
        $this->session->set_userdata($userdata);
    }
}
?>