<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Teacher extends Controller {

	function Teacher()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
		$this->load->model('teacher_model');
		$this->load->model('home_model');
		$this->load->helper('security');
	}
	
	function index()
	{

		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');


		/*----------------- pagination starts -----------------------*/

		$this->load->helper('form');
	 	$this->load->helper('url');
	 	$this->load->library('table');
		$this->load->library('pagination');
		

		// Config setup
		$num_rows=$this->db->count_all("SL_tutor");

	 	$config['base_url'] = base_url().'index.php/teacher?page=1';
	 	$config['total_rows'] = $num_rows;
	 	$config['per_page'] = 8;
	 	$config['num_links'] = $num_rows;
	 	$config['use_page_numbers'] = TRUE;
	 	$this->pagination->initialize($config);

		$total_pages = ceil($num_rows / $config['per_page']); 

			if (isset($_GET["page"])) { $page  = $_GET["page"]; } else { $page=1; };

			$start_from = ($page-1) * $config['per_page'];
			$end_to = $config['per_page']; 


		if(isset($_POST['tutor_experience']))
		{
			$this->load->library('form_validation');			
			$config = array(
               array(
                     'field'   => 'post_name', 
                     'label'   => 'Post Name', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'institute', 
                     'label'   => 'Institute', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'type_of_role', 
                     // 'label'   => 'Grade Class', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'from_date', 
                     'label'   => 'From Date', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'to_date', 
                     'label'   => 'To Date', 
                     'rules'   => 'required'
                  )
			   );

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				for ($i=0; $i <sizeof($this->input->post('post_name')) ; $i++) 
				{ 
					$post_name=$this->input->post('post_name')[$i];
					$institute=$this->input->post('institute')[$i];
					$type_of_role=$this->input->post('type_of_role')[$i];
					$from_date=date('Y-m-d',strtotime($this->input->post('from_date')[$i]));
					$to_date= date('Y-m-d',strtotime($this->input->post('to_date')[$i]));
					$tutor_experience_info = array();
					$tutor_experience_info['tutor_id']= $this->input->post('tutor_id');
					$tutor_experience_info['institute_name']=$institute; 
					$tutor_experience_info['name_of_post']=$post_name;  
					$tutor_experience_info['from_date'] = $from_date; 
					$tutor_experience_info['to_date'] =$to_date; 
					$tutor_experience_info['type_of_role']=$type_of_role;
					$result = $this->teacher_model->add_teacher_experience($tutor_experience_info);
				}
				
				if(sizeof($result)>0)
				{	
					$this->success('<p class="success">Tutor Experience has been successfully</p>');
					redirect(base_url().'index.php/teacher?page=1');
				}
				else
				{
					$this->success('<p class="success">Tutor Experience has been created Failed</p>');
					redirect(base_url().'index.php/teacher?page=1');
				}
			}
		}

			$show_data['total_pages'] = $total_pages;
			$show_data['teachers_data'] = $this->teacher_model->fetch_data($start_from, $end_to);
			//print_r($show_data['teachers_data']);die;

		/*------------------------- end ---------------------------*/

		if(isset($_GET["content"]))
		{
			$content = $_GET["content"];
			if($content != '')
			{
				$show_data['teachers_data'] = $this->teacher_model->get_all_search_content($content);
			}
			else
			{
				$show_data['error'] = "You have to insert value to search";
			}
			//print_r($show_data);die;
		}

		$show_data['teacher_count'] = $this->teacher_model->get_all_teacher_count();
		$this->load->view('teacherReg_view',$show_data);
	}
	function addteacher()
	{

		$this->load->library('form_validation');			
		$config = array(
			 array(
                 'field'   => 'join_date', 
                 'label'   => 'Joining Date', 
                 'rules'   => 'required'
              ),
           array(
                 'field'   => 'f_name', 
                 'label'   => 'First Name', 
                 'rules'   => 'required'
              ),
           array(
                 'field'   => 'm_name', 
                 'label'   => 'Middle Name', 
                 //'rules'   => 'required'
              ),
		   array(
                 'field'   => 'l_name', 
                 'label'   => 'Last Name', 
                 'rules'   => 'required'
              ),
		   array(
                 'field'   => 'radio', 
                 //'label'   => 'Country', 
                 'rules'   => 'required'
                ),
		   array(
                 'field'   => 'dob', 
                 'label'   => 'Date Of Birth', 
                 'rules'   => 'required'
                ),
		      array(
                 'field'   => 'address', 
                 'label'   => 'Address', 
                 'rules'   => 'required'
                ),

		   array(
                 'field'   => 'place', 
                 'label'   => 'Place', 
                 'rules'   => 'required'
                //'rules'   => 'required|exact_length[10]'
                // 'rules'   => 'required|is_unique[ls_agent.email]|valid_email'
              ),	
              array(
                 'field'   => 'city', 
                 'label'   => 'City', 
                 'rules'   => 'required'
              ),
                 array(
                 'field'   => 'postal_code', 
                 'label'   => 'Postal Code', 
                 'rules'   => 'required'
              ),	
                 array(
                 'field'   => 'email', 
                 'label'   => 'Email', 
                 'rules'   => 'required|is_unique[ls_agent.email]|valid_email'
              ),
                 array(
                 'field'   => 'contact_no', 
                 'label'   => 'Contact No', 
                 'rules'   => 'required'
              ),
                array(
                 'field'   => 'card_type', 
                 'label'   => 'Card Type', 
                 'rules'   => 'required'
              ),
                array(
                 'field'   => 'id_card_code', 
                 'label'   => 'Card Code', 
                 'rules'   => 'required'
              ),
                array(
                 'field'   => 'subject', 
                 'label'   => 'Subject', 
                 'rules'   => 'required'
              ),	
                 array(
                 'field'   => 'twitter_id', 
                 'label'   => 'Twitter', 
                 'rules'   => 'required'
              ),
              array(
                 'field'   => 'facebook_id', 
                 'label'   => 'Facebook', 
                 'rules'   => 'required'
              )              
			);

		$this->form_validation->set_rules($config);
		if($this->form_validation->run() != false)
		{
			
			$teacher_info = array();				
			$last_id = $this->teacher_model->get_last_row();
			$teacher_info['tutor_id'] =$last_id;
			$teacher_info['school_id'] =$this->session->userdata('school_id');
			$join_date = new DateTime($this->input->post('join_date'));
			$teacher_info['joining_date'] =$join_date->format('Y-m-d');
			$teacher_info['first_name'] = $this->input->post('f_name');
			$teacher_info['middle_name'] = $this->input->post('m_name');
			$teacher_info['last_name'] = $this->input->post('l_name');
			$teacher_info['gender'] = $this->input->post('radio');
			$dob = new DateTime($this->input->post('dob'));
			$teacher_info['date_of_birth'] =$dob->format('Y-m-d');
			$teacher_info['address'] = $this->input->post('address');
			$teacher_info['place'] = $this->input->post('place');
			$teacher_info['city'] = $this->input->post('city');
			$teacher_info['postal_code'] = $this->input->post('postal_code');
			$teacher_info['email'] = $this->input->post('email');
			$mobile_no= substr($this->input->post('contact_no'),-9);
			$teacher_info['contact_no']  = str_pad($mobile_no,13,'+254',STR_PAD_LEFT);
			$teacher_info['id_card_type_id'] = $this->input->post('card_type');
			$teacher_info['id_card_type_code'] = $this->input->post('id_card_code');
			$teacher_info['status'] =1;
			$teacher_info['subject_id'] = $this->input->post('subject');
			$teacher_info['twitter_id'] = $this->input->post('twitter_id');
			$teacher_info['facebook_id'] = $this->input->post('facebook_id');
			$teacher_info['start_date'] = date("Y-m-d H:i:s");
			$teacher_info['end_date'] = date("2099-12-12 23:59:59");
			$teacher_info['about_us'] = 'tutor '.$this->input->post('f_name').' '.$this->input->post('last_name').'  and your address is  '.$this->input->post('address').' '.$this->input->post('place').'	'.$this->input->post('city').'	details';
			session_start();
			if(isset($_SESSION['crop_image']))
			{
			$file_name=explode('/', $_SESSION['crop_image']);
			$teacher_info['profile_pic'] = $file_name[3];
			
			}
			session_destroy();
			$result = $this->teacher_model->add_teacherdetails($teacher_info);
			if(sizeof($result)>0)
			{
				$last_id = $this->teacher_model->get_last_row();
				$tutor_id=$last_id-1;
				$teacher_info = array();									
				$teacher_info['username']='SCL-TR-'.str_pad($tutor_id, 4, '0', STR_PAD_LEFT);
				$password = $this->randomPassword();
				$teacher_info['password']= dohash($password, 'md5');
				$teacher_info['users_details_id'] = $tutor_id;
				$teacher_info['role_id'] = 2;
				$teacher_info['school_id'] =$this->session->userdata('school_id');
				
				$uresult = $this->teacher_model->add_teacher_credential_details($teacher_info);
				if(sizeof($uresult)>0)
				{
					if(($this->input->post('email'))!='')
					{
						$message = '';
						$message .= 'You have successfully registered as Tutor <br /><br />';
						$message .= 'First Name: '.$this->input->post('f_name').'<br /><br />';
						$message .= 'LastName: '.$this->input->post('l_name').'<br /><br />';
						$message .= 'E-mail Address: '.$this->input->post('email').'<br /><br />';
						$message .= 'User Name: '.$teacher_info['username'].'<br /><br />';
						$message .= 'Password: '.$password.'<br /><br />';
						
						$this->load->library('email');
						$this->email->to($this->input->post('email'));
						$this->email->cc('muhammedilyasy20@gmail.com');
						$this->email->from('no-reply@school.com');
						$this->email->subject('Tutor Details');
						$this->email->message($message);
						
						if($this->email->send())
						{
							// $ilri_message = 'Dear '.$this->input->post('f_name').' '.$this->input->post('l_name').': Your Username : '.$teacher_info['username'].' Password : '.$password;
							// $this->send_sms($ilri_message,$teacher_info['contact_no']);								
							// $this->success('<p class="success">Tutor Registration has been created successfully</p>');
							// redirect($_SERVER['HTTP_REFERER']);
							// exit;
						}
						else
						{
							// $this->success('<p class="success">Tutor Registration has been created.Email Sending Failed</p>');
							// redirect($_SERVER['HTTP_REFERER']);
						}
					}						
				}	
			}
			$last_id = $this->teacher_model->get_last_row();
			$tutor_id=$last_id-1;
			echo $tutor_id;		
		}
	}
	function add_tutor_academic()
	{ 
		$this->load->library('form_validation');			
			$config = array(
               array(
                     'field'   => 'course_name', 
                     'label'   => 'Course Name', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'institute', 
                     'label'   => 'Institute', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'grade_class', 
                     'label'   => 'Grade Class', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'course_start[]', 
                     'label'   => 'Course Start', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'course_end[]', 
                     'label'   => 'Course End', 
                     'rules'   => 'required'
                  )
			   );

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				for ($i=0; $i <sizeof($this->input->post('course_name')) ; $i++) 
				{ 
					$course_name=$this->input->post('course_name')[$i];
					$institute=$this->input->post('institute')[$i];
					$grade_class=$this->input->post('grade_class')[$i];
					$course_start=date('Y-m-d',strtotime($this->input->post('course_start')[$i]));
					$course_end= date('Y-m-d',strtotime($this->input->post('course_end')[$i]));
					$tutor_academic_info = array();
					$tutor_academic_info['tutor_id']= $this->input->post('tutor_id');
					$tutor_academic_info['course']=$course_name; 
					$tutor_academic_info['institute']=$institute;  
					$tutor_academic_info['grade_class']=$grade_class; 
					$tutor_academic_info['course_starting_date'] = $course_start; 
					$tutor_academic_info['course_completion_date'] =$course_end; 
					$result = $this->teacher_model->add_teacher_academic($tutor_academic_info);
				}
				$last_id = $this->teacher_model->get_last_row();
				$tutor_id=$last_id-1;
				echo $tutor_id;	
			}
	}
	

	function add()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
		{
			$country_name = $this->home_model->get_country_name();
			$select_subject=$this->teacher_model->get_all_subject();
			
						$ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    								   <script src="'. base_url().'js/jquery-ui.js"></script>
   
										<script>
									        $(document).ready(function(){			
												$("#dob").datepicker({
												maxDate: 0,
												changeMonth: true,
												changeYear: true,
												showButtonPanel: true,
												dateFormat: "dd-mm-yy",
												yearRange:"1900:"
											}); 
											$("#join_date").datepicker({
									            minDate: 0,
												changeMonth: true,
												changeYear: true,
												showButtonPanel: true,
												dateFormat: "dd-mm-yy",          
									          });
											});
											 $("#add_teacher_registration").submit(function(e){
											     e.preventDefault();
											  var form = $("#add_teacher_registration").serialize();
											    var pathstring = String(window.location);
												  var patharray  = pathstring.split("/");   
												  var path=patharray[0]+"//"+patharray[2]+"/"+patharray[3];
												  var url = path+"/index.php/teacher";
												  $.ajax({
												       type: "POST",
												       url: path+"/index.php/teacher/addteacher",
												       data: form,

												       success: function(data){
												        tutor_academic_addpopup(data);
												       }

												     });
											  }); 
						      			</script>



						<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Tutor Registeration Part-1</h2>
								<div class="close__btn" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="add_teacher_registration" id="add_teacher_registration" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label style="padding:0;font-family: font;">
												Joining Date				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="join_date" id="join_date" placeholder="Joining Date">
												<div id="error_join_date" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												First Name				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="f_name" id="f_name" placeholder="First Name">
												<div id="error_f_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Middle Name				
											</label>					
												<input type="text" value="" class="input" name="m_name" id="m_name" placeholder="Middle Name">
										</div>
										
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Last Name				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="l_name" id="l_name" placeholder="Last Name">	
												<div id="error_l_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Gender	
											</label>
											<div class="input__area">		
												<div class="radio_button">		
													<input type="radio" value="male" class="radio" name="radio" id="radio1">	
													<label  for="radio1" class="radiolabel_male radiolabel"></label><div class="male">Male</div>
													<input type="radio" value="female" class="radio" name="radio" id="radio2">
													<label for="radio2" class="radiolabel_female radiolabel"></label><div class="female">Female</div>
												</div>
											<div id="error_radio" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Date Of Birth				
											</label>
											<div class="input__area">				
												<input type="date" value="" class="input" name="dob" id="dob" placeholder="Date Of Birth">
												<div id="error_dob" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Address				
											</label>
											<div class="input__area">				
												<textarea name="address" id="address" class="input"></textarea>
												<div id="error_address" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Place				
											</label>
											<div class="input__area">				
												<input type="text" value="" class="input" name="place" id="place" placeholder="Place">
												<div id="error_place" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
									
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												City				
											</label>
											<div class="input__area">				
												<input type="text" value="" class="input" name="city" id="city" placeholder="City">
												<div id="error_city" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>	
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Postal Code				
											</label>
											<div class="input__area">				
												<input type="text" value="" class="input" name="postal_code" id="postal_code" placeholder="Postal Code">
												<div id="error_postal_code" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>		
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Email				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="email" id="email" placeholder="Email">
												<div id="error_email" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Contact No				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="contact_no" id="contact_no" placeholder="Contact No">
												<div id="error_contact_no" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												ID Card Type				
											</label>
											<div class="input__area">	
												<select class="input arrow" name="card_type" id="card_type">
                                            		<option value="">Select Card Type</option>
                                            		<option value="Election ID">Election ID</option>
                                            		<option value="Pand Card">Pand Card</option>
                                            		<option value="Driving ID">Driving ID</option>
	                                            	<option value="Passport ID">Passport ID</option>	
                                            	</select>			
												<div id="error_card_type" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												ID Card Code				
											</label>
											<div class="input__area">				
												<input type="text" value="" class="input" name="id_card_code" id="id_card_code" placeholder="ID Card Code">
												<div id="error_id_card_code" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Specification		
											</label>
											<div class="input__area">					
												<select class="input arrow" name="subject" id="subject">
	                                            	<option value="">Select Specification</option>';

	                                            		foreach ($select_subject as $subject) 
	                                            		{
	                                            			$ret_result.='<option value="'.$subject['subject_id'].'">'.$subject['subject_name'].'</option>';
	                                            		}


											    $ret_result.='</select>
											    <div id="error_subject" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="field" role="user-name">
											<label style="padding:0;">
												Twitter				
											</label>	
											<div class="input__area">			
												<input type="text" value="" class="input" name="twitter_id" id="twitter_id" placeholder="Twitter">
												<div id="error_twitter_id" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="field" role="user-name">
											<label style="padding:0;">
												Facebook				
											</label>
											<div class="input__area">				
												<input type="text" value="" class="input" name="facebook_id" id="facebook_id" placeholder="Facebook">
												<div id="error_facebook_id" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="field" role="user-name">
											<label style="padding:0;">
												Profile Pic				
											</label>
											<div class="input__area">			
												<a class="attendance_view_link" href="javascript:void(0);" alt="register" onclick="crop_image()">
													<div class="profile_crop_image" id="crop_again"></div>
												</a>
												<div id=" " class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>


										<div class="field" role="user-name">
											<label style="padding:0;">
												&nbsp;				
											</label>	
												<div class="button">				
													<input type="submit" name="create_teacher" id="create_teacher" class="submit__button" value="Submit" onclick="return add_teacher_registration_validation()">
													<input type="reset" name="reset" id="reset" class="submit__button cancel__button" value="Cancel">
												</div>
										</div>										
									</div>
								</div>
							</form>
							';		
									
					echo $ret_result;
					//exit;
		}
					
	}
	function add_academic()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
		{
			$tutor_id=$this->input->post("id");
			$ret_result.='<script>
					        $(document).ready(function(){			
								$(".dob").datepicker({
								maxDate: 0,
								changeMonth: true,
								changeYear: true,
								showButtonPanel: true,
								dateFormat: "dd-mm-yy",
								yearRange:"1900:"
							}); 
							});
							$("#add_new_academic_tutor").submit(function(e){
							   e.preventDefault();
							  var form = $("#add_new_academic_tutor").serialize();
							    var pathstring = String(window.location);
								  var patharray  = pathstring.split("/");   
								  var path=patharray[0]+"//"+patharray[2]+"/"+patharray[3];
								  var url = path+"/index.php/teacher";
								  $.ajax({
							       type: "POST",
							       url: path+"/index.php/teacher/add_tutor_academic",
							       data: form,

							       success: function(data){
							        tutor_experience_addpopup(data);
							       }

							     });
							  });
						</script>

						 <div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Add Academic Part-2</h2>
								<div class="close__btn" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" id="add_new_academic_tutor"  name="add_new_academic_tutor" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">';
									if($tutor_id!=0)
										{
											$ret_result.='<div class="success_register">Tutor has been created successfully</div>';
										}
								$ret_result.='<div class="acadamic" id="acadamic">
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Course Name				
												</label>
												<div class="input__area">					
													<input type="text" value="" class="input" name="course_name[]" id="course_name" placeholder="Course Name">
													<div id="error_course_name" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>		
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Institute				
												</label>
												<div class="input__area">					
													<input type="text" value="" class="input" name="institute[]" id="institute" placeholder="Institute">	
													<div id="error_institute" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Grade Class				
												</label>
												<div class="input__area">					
													<input type="text" value="" class="input" name="grade_class[]" id="grade_class" placeholder="Grade Class">
													<div id="error_grade_class" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Course Start				
												</label>
												<div class="input__area">				
													<input type="date" value="" class="input dob" name="course_start[]" id="course_start" placeholder="Course Start">
													<div id="error_course_start" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Course Complete				
												</label>
												<div class="input__area">				
													<input type="date" value="" class="input dob" name="course_end[]" id="course_end" placeholder="Course Complete">
													<div id="error_course_end" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<hr class="hrz_line"></hr>
											
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">			
											</label>	
											<div class="button">				
												<input type="button" name="create_new_academic" id="create_new_academic" class="submit__button" value="ADD" onclick="add_new_academic()">
											</div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">			
											</label>	
												<div class="button">				
													<input type="submit" name="tutor_academin" id="tutor_academin" class="submit__button" value="Submit" onclick="return teacher_add_academic_validation()">
													<input type="hidden" name="tutor_id" id="tutor_id" value="'.$tutor_id.'">
													<input type="reset" name="reset" id="reset" class="submit__button" value="Cancel">
												</div>
										</div>										
									</div>
								</div>
							</form>
							';									
									
					echo $ret_result;
					//exit;
		}
	}
	function add_experience()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
		{
			$tutor_id=$this->input->post("id");
			$ret_result.='<script>
					        $(document).ready(function(){			
								$(".dob").datepicker({
								maxDate: 0,
								changeMonth: true,
								changeYear: true,
								showButtonPanel: true,
								dateFormat: "dd-mm-yy",
								yearRange:"1900:"
							}); 
							});
						</script>

						 <div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Add Experience Part-3</h2>
								<div class="close__btn" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" id="add_new_experience_tutor"  name="add_new_experience_tutor" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">';
									if($tutor_id!=0)
										{
											$ret_result.='<div class="success_register">Tutor Academic has been created successfully</div>';
										}
								$ret_result.='<div class="experience" id="experience">
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Post Name				
												</label>
												<div class="input__area">					
													<input type="text" value="" class="input" name="post_name[]" id="post_name" placeholder="Post Name">
													<div id="error_post_name" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>		
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Institute				
												</label>
												<div class="input__area">					
													<input type="text" value="" class="input" name="institute[]" id="institute" placeholder="Institute">	
													<div id="error_institute" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Type Of Role				
												</label>
												<div class="input__area">	
													<select class="input arrow" name="type_of_role[]" id="type_of_role">
	                                            		<option value="">Select Role</option>
	                                            		<option value="Permanent">Permanent</option>
	                                            		<option value="Temporary">Temporary</option>
	                                            	</select>			
													<div id="error_type_of_role" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													From Date				
												</label>
												<div class="input__area">				
													<input type="date" value="" class="input dob" name="from_date[]" id="from_date" placeholder="From Date">
													<div id="error_from_date" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													To Date				
												</label>
												<div class="input__area">				
													<input type="date" value="" class="input dob" name="to_date[]" id="to_date" placeholder="To Date">
													<div id="error_to_date" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<hr class="hrz_line"></hr>
											
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">			
											</label>	
											<div class="button">				
												<input type="button" name="create_new_experience" id="create_new_experience" class="submit__button" value="ADD" onclick="add_new_experience()">
											</div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">			
											</label>	
												<div class="button">				
													<input type="submit" name="tutor_experience" id="tutor_experience" class="submit__button" value="Submit" onclick="return teacher_add_experience_validation()">
													<input type="hidden" name="tutor_id" id="tutor_id" value="'.$tutor_id.'">
													<input type="reset" name="reset" id="reset" class="submit__button" value="Cancel">
												</div>
										</div>										
									</div>
								</div>
							</form>
							';									
									
					echo $ret_result;
					//exit;
		}
	}
	 private function success($message) {
        $userdata = array(
            'success' => $message
        );
        $this->session->set_userdata($userdata);
    }

    private function clearmessage() {
        $userdata = array(
            'success' => ''
        );
        $this->session->set_userdata($userdata);
    }
    function randomPassword() 
	{
		$alphabet = "0123456789";
		$pass = array();
		$alphaLength = strlen($alphabet) - 1;
		for ($i = 0; $i < 8; $i++) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
		}
		return implode($pass);
	}
	private function send_sms($message,$numbers)
	{
		// Be sure to include the file you've just downloaded
		require_once('includes/AfricasTalkingGateway.php');
		$status = '';
		
		// Specify your login credentials
		$username = "VivacomLimited";
		$apikey = "4266b972ced0fc27a7839393ea67751c7cd8de5414391a17d0d084bc278fa016";
		
		// Specify the numbers that you want to send to in a comma-separated list
		// Please ensure you include the country code (+254 for Kenya in this case)
		$recipients = $numbers;
		
		// And of course we want our recipients to know what we really do
		$message = $message;
		
		// Create a new instance of our awesome gateway class
		$gateway = new AfricasTalkingGateway($username, $apikey);
		
		// Any gateway errors will be captured by our custom Exception class below,
		// so wrap the call in a try-catch block
		try
		{
			// Thats it, hit send and we'll take care of the rest.
			$results = $gateway->sendMessage($recipients, $message);
			foreach($results as $result) {
				// Note that only the Status "Success" means the message was sent
				// echo " Number: " .$result->number;
				
				$status=$result->status;
				
				// echo " Status: " .$result->status;
				// echo " MessageId: " .$result->messageId;
				// echo " Cost: " .$result->cost."\n";
			}
		}
		catch(AfricasTalkingGatewayException $e)
		{
			$status="Encountered an error while sending: ".$e->getMessage();
		}
		if($status=='Success')
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}
?>