<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Students extends Controller {

	function Students()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
	
		$this->load->model('student_model');
		$this->load->helper('security');
	}
	
	function index()
	{
		
		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');


		/*----------------- pagination starts -----------------------*/

		$this->load->helper('form');
	 	$this->load->helper('url');
	 	$this->load->library('table');
		$this->load->library('pagination');
		

		// Config setup
		$num_rows=$this->db->count_all("SL_student");

	 	$config['base_url'] = base_url().'index.php/students?page=1';
	 	$config['total_rows'] = $num_rows;
	 	$config['per_page'] = 8;
	 	$config['num_links'] = $num_rows;
	 	$config['use_page_numbers'] = TRUE;
	 	$this->pagination->initialize($config);

		$total_pages = ceil($num_rows / $config['per_page']); 

			if (isset($_GET["page"])) 
			{ 
				$page  = $_GET["page"]; 
			} 
			else 
			{ 
				$page=1; 
			};

			$start_from = ($page-1) * $config['per_page'];
			$end_to = $config['per_page']; 

			$show_data['total_pages'] = $total_pages;
			$show_data['student_data'] = $this->student_model->fetch_data($start_from,$end_to);

		/*------------------------- end ---------------------------*/


		

		if(isset($_GET["content"]))
		{
			$content = $_GET["content"];
			
			if($content != '')
			{
				$show_data['student_data'] = $this->student_model->get_all_search_content($content);
			}
			else
			{
				$show_data['error'] = "You have to insert value to search";
			}
			//print_r($show_data);die;
		}
		$show_data['student_count'] = $this->student_model->get_all_student_count();
		$student_div= $this->student_model->get_division_student_count();
		$data=array();
		foreach ($student_div as $student) 
		{
			$data[$student['number']]['class_id'] = $student['class_id'];
			$data[$student['number']][$student['name']]['count'] = $student['count_of_student'];
			$data[$student['number']][$student['name']]['division_id'] = $student['division_id'];
		}
			// echo "<pre>";
			// print_r($data);die;
		$show_data['student_div'] = $data;
        
		if(isset($_GET['class_id'])||isset($_GET['division_id']))
		{
			$i=$_GET['division_id'];
            $class=$_GET['class_id'];

			if(($_GET['class_id'])=='')
			{
		 		redirect(base_url().'index.php/students?page=1');	
			}
			if(($_GET['division_id'])=='')
			{
		 		redirect(base_url().'index.php/students?page=1');	
			}

			if(($_GET['division_id'])=='0')
			{			  
                $show_data['student_data']=$this->student_model->get_student_details_class_wise($class,$start_from,$end_to);      
			}

			else
			{
				$i=$_GET['division_id'];
				$show_data['student_data']=$this->student_model->get_student_details_class($i,$start_from,$end_to);		
			}
		}

		$show_data['student_count'] = $this->student_model->get_all_student_count();
		$this->load->view('studentReg_view',$show_data);
	}

	function addstudent()
	{
		
			$this->load->library('form_validation');			
			$config = array(
				array(
                     'field'   => 'calendar_year', 
                     'label'   => 'Calendar Year', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'class', 
                     'label'   => 'Class', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'division_id', 
                     'label'   => 'Division', 
                     'rules'   => 'required'
                  ),	
               array(
                     'field'   => 'f_name', 
                     'label'   => 'First Name', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'm_name', 
                     'label'   => 'Middle Name', 
                     //'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'l_name', 
                     'label'   => 'Last Name', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'radio', 
                     //'label'   => 'Country', 
                     'rules'   => 'required'
                    ),
			   array(
                     'field'   => 'dob', 
                     'label'   => 'Date Of Birth', 
                     'rules'   => 'required'
                    ),	
               array(
                     'field'   => 'father_name', 
                     'label'   => 'Father Name', 
                     'rules'   => 'required'
                  ),	
               array(
                     'field'   => 'mother_name', 
                     'label'   => 'mother Name', 
                     'rules'   => 'required'
                  ),
                array(
                     'field'   => 'contact_number', 
                     'label'   => 'Contact Number', 
                     'rules'   => 'required'
                  ),
			      array(
                     'field'   => 'address', 
                     'label'   => 'Address', 
                     'rules'   => 'required'
                    ),

			   array(
                     'field'   => 'place', 
                     'label'   => 'Place', 
                     'rules'   => 'required'
                  ),	
                  array(
                     'field'   => 'city', 
                     'label'   => 'City', 
                     'rules'   => 'required'
                  ),
                     array(
                     'field'   => 'postal_code', 
                     'label'   => 'Postal Code', 
                     'rules'   => 'required'
                  ),	
                     array(
                     'field'   => 'email', 
                     'label'   => 'Email', 
                     'rules'   => 'required|is_unique[ls_agent.email]|valid_email'
                  )
				);

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				
				$student_info = array();
				$last_id = $this->student_model->get_last_row();
				$student_info['student_id'] =$last_id;		
				$student_info['school_id'] = $this->session->userdata('school_id');		
				$student_info['first_name'] = $this->input->post('f_name');
				$student_info['middle_name'] = $this->input->post('m_name');
				$student_info['last_name'] = $this->input->post('l_name');
				$student_info['gender'] = $this->input->post('radio');
				$student_info['status'] =1;
				$dob = new DateTime($this->input->post('dob'));
				$student_info['date_of_birth'] =$dob->format('Y-m-d');
				$student_info['address'] = $this->input->post('address');
				$student_info['place'] = $this->input->post('place');
				$student_info['city'] = $this->input->post('city');
				$student_info['postal_code'] = $this->input->post('postal_code');
				$student_info['father_name'] = $this->input->post('father_name');
				$student_info['mother_name'] = $this->input->post('mother_name');
				$mobile_no= substr($this->input->post('contact_number'),-9);
				$student_info['contact_number']  = str_pad($mobile_no,13,'+254',STR_PAD_LEFT);
				$student_info['email'] = $this->input->post('email');
				// $student_info['admission_no']='SCL-ST-'.str_pad($result, 4, '0', STR_PAD_LEFT);
				$student_info['joining_class_id'] = $this->input->post('class');
				$student_info['joining_class_division_id'] = $this->input->post('division_id');
				$student_info['joining_accadamic_year_id'] = $this->input->post('calendar_year');
				$student_info['joining_date'] = date("Y-m-d H:i:s");
				$student_info['start_date'] = date("Y-m-d H:i:s");
				$student_info['end_date'] = date("2099-12-12 23:59:59");
				$student_info['about_us'] = 'students  '.$this->input->post('f_name').' '.$this->input->post('last_name').'	and your address is '.$this->input->post('address').'	'.$this->input->post('place').'	'.$this->input->post('city').'	details';
				if($this->input->post('physically_status')==1)
				{
					$student_info['physically_status'] =1;
					$student_info['physically']=$this->input->post('type_of_disabilty');
				}
				else
				{
					$student_info['physically_status'] =0;
				}
				session_start();
				if(isset($_SESSION['crop_image']))
				{
				$file_name=explode('/', $_SESSION['crop_image']);
				$student_info['profile_pic'] = $file_name[3];
				
				}
				session_destroy();

				$result = $this->student_model->add_studentsdetails($student_info);
	
				if(sizeof($result)>0)
				{
					$last_id = $this->student_model->get_last_row();
					$student_id=$last_id-1;
					$student_academic = array();
					$student_academic['student_id'] =$student_id;
					$student_academic['class_division_id'] = $this->input->post('division_id');
					$student_academic['academic_year_id'] = $this->input->post('calendar_year');
					$student_academic['is_active'] =1;
					$student_academic['starting_date'] = date("Y-m-d H:i:s");
					$student_academic['completing_date'] = date("2099-12-12 23:59:59");
					$result2 = $this->student_model->add_student_academic($student_academic);	
				}
				if(sizeof($result2)>0)
				{
					$last_id = $this->student_model->get_last_row();
					$student_id=$last_id-1;
					$student_info = array();									
					$student_info['username']='SCL-ST-'.str_pad($student_id, 4, '0', STR_PAD_LEFT);
					$password = $this->randomPassword();
					$student_info['password']= dohash($password, 'md5');
					$student_info['users_details_id'] =$student_id;
					$student_info['role_id'] = 4;
					$student_info['school_id'] =$this->session->userdata('school_id');
					
					$uresult = $this->student_model->add_students_credential_details($student_info);
					if(sizeof($uresult)>0)
					{
						if(($this->input->post('email'))!='')
						{
							$message = '';
							$message .= 'You have successfully registered as Student <br /><br />';
							$message .= 'First Name: '.$this->input->post('f_name').'<br /><br />';
							$message .= 'LastName: '.$this->input->post('l_name').'<br /><br />';
							$message .= 'E-mail Address: '.$this->input->post('email').'<br /><br />';
							$message .= 'User Name: '.$student_info['username'].'<br /><br />';
							$message .= 'Password: '.$password.'<br /><br />';
							
							$this->load->library('email');
							$this->email->to($this->input->post('email'));
							$this->email->cc('muhammedilyasy20@gmail.com');
							$this->email->from('no-reply@school.com');
							$this->email->subject('Student Details');
							$this->email->message($message);
							
							// if ($this->email->send())
							// {
							// 	$this->success('<p class="success">Student Registration has been created successfully</p>');
							// 	//redirect($_SERVER['HTTP_REFERER']);
							// 	exit;
							// }
							// else
							// {
							// 	$this->success('<p class="success">Student Registration has been created.Email Sending Failed</p>');
							// 	//redirect($_SERVER['HTTP_REFERER']);
							// }
						}						
					}	
				}
				$last_id = $this->student_model->get_last_row();
				$student_id=$last_id-1;
				echo $student_id;
			}
	}

	function add()
	{
		$ret_result='';
		$this->load->model('parent_model');
		$this->load->model('adddivision_model');
		$this->load->model('addclass_model');

		$select_class = $this->addclass_model->get_all_addclass1();
		$select_calendar_year= $this->student_model->get_all_calendar_year();
		$select_devision=$this->adddivision_model->get_all_division();
		$select_parent = $this->parent_model->get_all_parent_details();
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
		{
			 $ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
							<script>
						        $(document).ready(function(){			
									$("#dob").datepicker({
									maxDate: 0,
									changeMonth: true,
									changeYear: true,
									showButtonPanel: true,
									dateFormat: "dd-mm-yy",
									yearRange:"1900:"
								}); 
								});
								 $("#add_student_registration").submit(function(e){
									     e.preventDefault();
									  var form = $("#add_student_registration").serialize();
									    var pathstring = String(window.location);
										  var patharray  = pathstring.split("/");   
										  var path=patharray[0]+"//"+patharray[2]+"/"+patharray[3];
										  var url = path+"/index.php/students";
										  $.ajax({
										       type: "POST",
										       url: path+"/index.php/students/addstudent",
										       data: form,

										       success: function(data){
										          parentsaddpopup(data);
										       }

										     });
									  });
									   $(".physically_status").change(function () {
								        if (document.getElementById("physically_status").checked==true)
								        {
								            $(".physically").show("slow", "linear");
								        }
								        else
								        {
								            $(".physically").hide("slow", "linear");
								        }
								    }); 
						      </script>
						      <div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Student Registeration-Part1</h2>
								<div class="close__btn3" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="add_student_registration" id="add_student_registration" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Calendar year		
											</label>
											<div class="input__area">					
												<select class="input arrow" name="calendar_year" id="calendar_year">
	                                            	<option value="">Select Year</option>';

	                                            		foreach ($select_calendar_year as $calendar_year) 
	                                            		{
	                                            			$ret_result.='<option value="'.$calendar_year['calendar_year_id'].'">'.$calendar_year['calendar_year_name'].'</option>';
	                                            		}


											    $ret_result.='</select>
											    <div id="error_calendar_year" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Class		
											</label>
											<div class="input__area">					
												<select class="input arrow" name="class" id="class" onchange="get_division_student(this)" >
	                                            	<option value="">Select Class</option>';

	                                            		foreach ($select_class as $class) 
	                                            		{
	                                            			$ret_result.='<option value="'.$class['id'].'">'.$class['number'].'</option>';
	                                            		}


											    $ret_result.='</select>
											    <div id="error_class" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												 Division				
											</label>
											<div class="input__area">					
												<select class="input arrow" name="division_id" id="division_id">
		                                            	<option value="">select division</option>
												  </select>
											    <div id="error_division_id" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												First Name				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="f_name" id="f_name" placeholder="First Name">
												<div id="error_f_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Middle Name				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="m_name" id="m_name" placeholder="Middle Name">
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Last Name				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="l_name" id="l_name" placeholder="Last Name">	
												<div id="error_l_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Gender	
											</label>
											<div class="input__area">	
												<div class="radio_button">		
													<input type="radio" value="male" class="radio" name="radio" id="radio1">	
													<label  for="radio1" class="radiolabel_male radiolabel"></label><div class="male">Male</div>
													<input type="radio" value="female" class="radio" name="radio" id="radio2">
													<label for="radio2" class="radiolabel_female radiolabel"></label><div class="female">Female</div>
												</div>
												<div id="error_radio" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Date Of Birth				
											</label>
											<div class="input__area">				
												<input type="date" value="" class="input" name="dob" id="dob" placeholder="Date Of Birth">
												<div id="error_dob" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Father Name				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="father_name" id="father_name" placeholder="Father Name">
												<div id="error_father_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Mother Name				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="mother_name" id="mother_name" placeholder="Mother Name">
												<div id="error_mother_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Contact No				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="contact_number" id="contact_number" placeholder="Contact Number">
												<div id="error_contact_number" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Address				
											</label>
											<div class="input__area">				
												<textarea name="address" id="address" class="input"></textarea>
												<div id="error_address" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Place				
											</label>
											<div class="input__area">				
												<input type="text" value="" class="input" name="place" id="place" placeholder="Place">
												<div id="error_place" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>						
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												City				
											</label>
											<div class="input__area">				
												<input type="text" value="" class="input" name="city" id="city" placeholder="City">
												<div id="error_city" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>		

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Postal Code				
											</label>
											<div class="input__area">				
												<input type="text" value="" class="input" name="postal_code" id="postal_code" placeholder="Postal Code">
												<div id="error_postal_code" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>		
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Email				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="email" id="email" placeholder="Email">
												<div id="error_email" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>	
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												IS Any Physically Challenge?
											</label>
											<div class="input__area">
												<input type="radio" value="1" id="physically_status" name="physically_status" class="physically_status" />Yes
												<input type="radio" value="0"id="physically_status1" name="physically_status" class="physically_status" />No
											</div>
											<div class="clear"></div>
										</div>
										<div class="physically" style="display:none;">
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Type of disabilty		
												</label>
												<div class="input__area">
													<input type="text" value="" class="input" name="type_of_disabilty" id="type_of_disabilty" placeholder="">
													<div id="" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
										</div>
										<div class="field" role="user-name">
											<label style="padding:0;">
												Profile Pic				
											</label>
											<div class="input__area">			
												<a class="attendance_view_link" href="javascript:void(0);" alt="register" onclick="crop_image()">
													<div class="profile_crop_image" id="crop_again"></div>
												</a>
												<div id=" " class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>	
										<div class="field" role="user-name">
											<label style="padding:0;">			
											</label>
											<div class="button">				
												<input type="submit" name="create_student" id="create_student" class="submit_button31" value="Next" onclick="return add_student_registration_validation()">
												<input type="reset" name="reset" id="reset" class="submit_button3" value="Cancel">
											</div>
										</div>									
									</div>
								</div>
							</form>
							';
									
									
					echo $ret_result;
					//exit;
		}
	}
	private function success($message) {
        $userdata = array(
            'success' => $message
        );
        $this->session->set_userdata($userdata);
    }

    private function clearmessage() {
        $userdata = array(
            'success' => ''
        );
        $this->session->set_userdata($userdata);
    }
    	function randomPassword() 
	{
		$alphabet = "0123456789";
		$pass = array();
		$alphaLength = strlen($alphabet) - 1;
		for ($i = 0; $i < 8; $i++) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
		}
		return implode($pass);
	}
	function image_crop()
	{   
		$ret_result='';

		$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
							<h2>Contact Image</h2>
							<div class="close__btn_profile" onclick="closemorePopup()" id="btn_ok"></div>
							<iframe id="image_crop_frame" width="500px" height="575px"  frameBorder="0" src="'.base_url().'image-cropper/image_crop.html"></iframe>
							
						</div>';
		echo $ret_result;
					//exit;
		
	}
	function get_division1()
	{
		$result='<option value="">select</option>';
		if(isset($_POST['class_id']))
		{	
			$this->load->model('adddivision_model');
			$this->load->model('addclass_model');
			$this->load->model('studentrecord_model');
			$class_id=$_POST['class_id'];
			$division_name=$this->student_model->get_all_division($class_id);	
			//print_r($division_name);die;
	       if(sizeof($division_name)>0)
			{
              foreach($division_name as $division)
				{
					$result.='<option value="'.$division['id'].'">'.$division['name'].'</option>';
				}		
			}
        }
        echo $result;
	   exit();
    }
	
}
?>