<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class StudentDetail extends Controller {

	function StudentDetail()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}

		$this->load->model('student_model');
	}
	
	function index()
	{
		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');

		$student_id=$_GET['student_id'];
		$show_data['student_details'] = $this->student_model->get_student_details($student_id);

		if(isset($_POST['edit_student']))
		{
			$this->load->library('form_validation');			
			$config = array(	
               array(
                     'field'   => 'f_name', 
                     'label'   => 'First Name', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'm_name', 
                     'label'   => 'Middle Name', 
                     //'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'l_name', 
                     'label'   => 'Last Name', 
                     'rules'   => 'required'
                  ),
			   array(
                     'field'   => 'dob', 
                     'label'   => 'Date Of Birth', 
                     'rules'   => 'required'
                    ),	
               array(
                     'field'   => 'father_name', 
                     'label'   => 'Father Name', 
                     'rules'   => 'required'
                  ),	
               array(
                     'field'   => 'mother_name', 
                     'label'   => 'mother Name', 
                     'rules'   => 'required'
                  ),
                array(
                     'field'   => 'contact_number', 
                     'label'   => 'Contact Number', 
                     'rules'   => 'required'
                  ),
			      array(
                     'field'   => 'address', 
                     'label'   => 'Address', 
                     'rules'   => 'required'
                    ),

			   array(
                     'field'   => 'place', 
                     'label'   => 'Place', 
                     'rules'   => 'required'
                  ),	
                  array(
                     'field'   => 'city', 
                     'label'   => 'City', 
                     'rules'   => 'required'
                  ),
                     array(
                     'field'   => 'postal_code', 
                     'label'   => 'Postal Code', 
                     'rules'   => 'required'
                  ),	
                     array(
                     'field'   => 'email', 
                     'label'   => 'Email', 
                     'rules'   => 'required|is_unique[ls_agent.email]|valid_email'
                  )
				);

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				
				$student_info = array();
				$student_id =$this->input->post('student_id');				
				$student_info['first_name'] = $this->input->post('f_name');
				$student_info['middle_name'] = $this->input->post('m_name');
				$student_info['last_name'] = $this->input->post('l_name');
				$student_info['status'] =1;
				$dob = new DateTime($this->input->post('dob'));
				$student_info['date_of_birth'] =$dob->format('Y-m-d');
				$student_info['address'] = $this->input->post('address');
				$student_info['place'] = $this->input->post('place');
				$student_info['city'] = $this->input->post('city');
				$student_info['postal_code'] = $this->input->post('postal_code');
				$student_info['father_name'] = $this->input->post('father_name');
				$student_info['mother_name'] = $this->input->post('mother_name');
				$mobile_no= substr($this->input->post('contact_number'),-9);
				$student_info['contact_number']  = str_pad($mobile_no,13,'+254',STR_PAD_LEFT);
				$student_info['email'] = $this->input->post('email');
				session_start();
				if(isset($_SESSION['crop_image']))
				{
					$file_name=explode('/', $_SESSION['crop_image']);
					$student_info['profile_pic'] = $file_name[3];
				
				}
				session_destroy();

				$result = $this->student_model->updated_students_details($student_id,$student_info);		
				if ($result>0)
				{
					$this->success('<p class="success">Student Details has been Updated successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
					exit;
				}
				else
				{
					$this->success('<p class="success">Student Details has been Updated unsuccessfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
			}
		}
		if(isset($_POST['edit_students_about_us']))
		{
			
				$this->load->library('form_validation');			
				$config = array(	
				      array(
	                     'field'   => 'about_us', 
	                     'label'   => 'About Us', 
	                     'rules'   => 'required'
	                    )
					);

				$this->form_validation->set_rules($config);
				if($this->form_validation->run() != false)
				{
					
					$student_info = array();
					$student_id =$this->input->post('student_id');				
					$student_info['about_us'] = $this->input->post('about_us');

					$result = $this->student_model->updated_students_details($student_id,$student_info);		
					if ($result>0)
					{
						$this->success('<p class="success">Student About Us has been Updated successfully</p>');
						redirect($_SERVER['HTTP_REFERER']);
						exit;
					}
					else
					{
						$this->success('<p class="success">Student About Us has been Updated unsuccessfully</p>');
						redirect($_SERVER['HTTP_REFERER']);
					}
				}
		}
		$this->load->view('studentdetail_view',$show_data);
	}
	function edit()
	{

		$ret_result='';
		if(isset($_POST['id']))
		{
			$student_id=$_POST['id'];
			$studetnt_details=$this->student_model->get_student_details($student_id);
			if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
			{
			 $ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
							<script>
						        $(document).ready(function(){			
									$("#dob").datepicker({
									maxDate: 0,
									changeMonth: true,
									changeYear: true,
									showButtonPanel: true,
									dateFormat: "dd-mm-yy",
									yearRange:"1900:"
								}); 
								});
						      </script>
						      <div class="pogin__popuphd" style="text-transform:uppercase">
								<h2> Edit Student Details</h2>
								<div class="close__btn3" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="edit_student_registration" id="edit_student_registration" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												First Name				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$studetnt_details['first_name'].'" class="input" name="f_name" id="f_name" placeholder="First Name">
												<div id="error_f_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Middle Name				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$studetnt_details['middle_name'].'" class="input" name="m_name" id="m_name" placeholder="Middle Name">
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Last Name				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$studetnt_details['last_name'].'" class="input" name="l_name" id="l_name" placeholder="Last Name">	
												<div id="error_l_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Date Of Birth				
											</label>
											<div class="input__area">				
												<input type="date" value="'.$studetnt_details['date_of_birth'].'" class="input" name="dob" id="dob" placeholder="Date Of Birth">
												<div id="error_dob" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Father Name				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$studetnt_details['father_name'].'" class="input" name="father_name" id="father_name" placeholder="Father Name">
												<div id="error_father_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Mother Name				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$studetnt_details['mother_name'].'" class="input" name="mother_name" id="mother_name" placeholder="Mother Name">
												<div id="error_mother_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Contact No				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$studetnt_details['contact_number'].'" class="input" name="contact_number" id="contact_number" placeholder="Contact Number">
												<div id="error_contact_number" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Address				
											</label>
											<div class="input__area">				
												<textarea name="address" id="address" class="input">'.$studetnt_details['address'].'</textarea>
												<div id="error_address" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Place				
											</label>
											<div class="input__area">				
												<input type="text" value="'.$studetnt_details['place'].'" class="input" name="place" id="place" placeholder="Place">
												<div id="error_place" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>						
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												City				
											</label>
											<div class="input__area">				
												<input type="text" value="'.$studetnt_details['city'].'" class="input" name="city" id="city" placeholder="City">
												<div id="error_city" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>		

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Postal Code				
											</label>
											<div class="input__area">				
												<input type="text" value="'.$studetnt_details['postal_code'].'" class="input" name="postal_code" id="postal_code" placeholder="Postal Code">
												<div id="error_postal_code" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>		
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Email				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$studetnt_details['email'].'" class="input" name="email" id="email" placeholder="Email">
												<div id="error_email" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>	
										<div class="field" role="user-name">
											<label style="padding:0;">
												Profile Pic				
											</label>
											<div class="input__area">			
												<a class="attendance_view_link" href="javascript:void(0);" alt="register" onclick="crop_image()">
													<div class="profile_crop_image" id="crop_again"></div>
												</a>
												<div id=" " class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>	
										<div class="field" role="user-name">
											<label style="padding:0;">			
											</label>
											<div class="button">				
												<input type="submit" name="edit_student" id="edit_student" class="submit_button31" value="Submit" onclick="return edit_student_registration_validation()">
												<input type="hidden" name="student_id" value="'.$student_id.'">
												<input type="reset" name="edit_student" id="edit_student" class="submit_button3" value="Cancel">
											</div>
										</div>									
									</div>
								</div>
							</form>
							';
									
									
					echo $ret_result;
					//exit;
			}
	 	}
	}
	function edit_about_us()
	{

		$ret_result='';
		if(isset($_POST['id']))
		{
			$student_id=$_POST['id'];
			$student_details=$this->student_model->get_student_details($student_id);
			if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
			{
			 $ret_result.=' <div class="pogin__popuphd" style="text-transform:uppercase">
								<h2> Edit About Us</h2>
								<div class="close__btn3" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="edit_student_about_us" id="edit_student_about_us" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												About Us				
											</label>
											<div class="input__area">				
												<textarea style="height:371px;width: 294px;"name="about_us" id="about_us" class="input">'.$student_details['about_us'].'</textarea>
												<div id="error_about_us" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="field" role="user-name">
											<label style="padding:0;">			
											</label>
											<div style="margin: 0 15px 0 auto;">				
												<input type="submit" name="edit_students_about_us" id="edit_students_about_us" class="submit_button31" value="Submit" onclick="return edit_student_about_us_validation()">
												<input type="hidden" name="student_id" value="'.$student_id.'">
												<input type="reset" name="edit_parent_about_us" id="edit_parent_about_us" class="submit_button3" value="Cancel">
											</div>
										</div>									
									</div>
								</div>
							</form>
							';
									
									
					echo $ret_result;
					//exit;
			}
	 	}
	}

	private function success($message) {
        $userdata = array(
            'success' => $message
        );
        $this->session->set_userdata($userdata);
    }

    private function clearmessage() {
        $userdata = array(
            'success' => ''
        );
        $this->session->set_userdata($userdata);
    }
}
?>