<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Profile extends Controller {

	function Profile()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
		$this->load->model('profile_model');
		$this->load->helper('security');
		
	}
	
	function index()
	{
		
		if(isset($_POST['edit_profile']))
		{
			$this->load->library('form_validation');			
			$config = array(
               array(
                     'field'   => 'first_name', 
                     'label'   => 'First Name', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'middle_name', 
                     'label'   => 'Middle Name', 
                     // 'rules'   => 'required'
                  ),
               array(
                     'field'   => 'last_name', 
                     'label'   => 'Last Name', 
                     'rules'   => 'required'
                  ),
                  array(
                     'field'   => 'address', 
                     'label'   => 'Address', 
                     'rules'   => 'required'
                  ),
                  array(
                     'field'   => 'place', 
                     'label'   => 'Place', 
                     'rules'   => 'required'
                  ),   
                  array(
                     'field'   => 'city', 
                     'label'   => 'City', 
                     'rules'   => 'required'
                  ),   
                  array(
                     'field'   => 'profile_pic', 
                     'label'   => 'Profile Pic', 
                     // 'rules'   => 'required'
                  ),	
                     array(
                     'field'   => 'email', 
                     'label'   => 'Email', 
                     'rules'   => 'required|is_unique[ls_agent.email]|valid_email'
                  )   
				);

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				
			    $user_info = array();
			 //    $user_id=$_POST['edit_profile_id'];
				// $role_id=$_POST['edit_profile_role_id'];
				$user_info['first_name'] =  $this->input->post('first_name');;
				$user_info['middle_name'] = $this->input->post('middle_name');
				$user_info['last_name'] = $this->input->post('last_name');
				$user_info['address'] = $this->input->post('address');
				$user_info['place'] = $this->input->post('place');
				$user_info['city'] = $this->input->post('city');
				$user_info['email'] = $this->input->post('email');
				
				$user_id=$this->session->userdata('user_id');
				session_start();
				if(isset($_SESSION['crop_image']))
				{
				$file_name=explode('/', $_SESSION['crop_image']);
				$user_info['profile_pic'] = $file_name[3];
				
				}
				session_destroy();
				// echo "<pre>";
				// print_r($user_info);die;
				switch ($this->session->userdata('user_type')) 
				{
					case 'admin':$result = $this->profile_model->update_admin_details($user_info,$user_id);break;
					case 'student':$result = $this->profile_model->update_student_details($user_info,$user_id);break;
					case 'parent':$result = $this->profile_model->update_parent_details($user_info,$user_id);break;
					case 'tutor':$result = $this->profile_model->update_tutor_details($user_info,$user_id);break;
					
				}
				
				

				if(sizeof($result)>0)
				{
					$this->success('<p class="success">Profile have been changed successfully</p>');
					if(isset($file_name))
					{


						$userdata = array(
							'user_name' => $user_info['first_name'].' '.$user_info['last_name'],
							'profile_pic' => $user_info['profile_pic']
							
						);
					}
					else
					{
						$userdata = array(
							'user_name' => $user_info['first_name'].' '.$user_info['last_name']
							
						);
					}
				$this->session->set_userdata($userdata);
				redirect($_SERVER['HTTP_REFERER']);
				}
				else
				{
					$this->success('<p class="success">Profile Update failed</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
				
			}
		}
		if (isset($_POST['edit_password']))
		{

            $this->load->library('form_validation');
            $config = array(
                array(
                    'field' => 'new_password',
                    'label' => ' New Password',
                    'rules' => 'trim|required|matches[re_password]|md5'
                )
            );
            $this->form_validation->set_rules($config);
            $result = '';
            if ($this->form_validation->run() != false)
             {
                $user_info = array();
                $user_name=$_POST['user_name'];
                $user_info['password'] = $this->input->post('new_password');
                $result = $this->profile_model->update_password($user_info,$user_name);
                
            } 
            else
             {
               
                $this->success(validation_errors());
                redirect($_SERVER['HTTP_REFERER']);
                exit();
            }
            if ($result > 0) {
                $this->success('<p class="success">Password have been changed successfully</p>');
                redirect($_SERVER['HTTP_REFERER']);
            } else {

                $this->success('<p class="success">Update failed</p>');
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
	}
	private function makeThumbnails($updir, $img)
	{
		$thumbnail_width = 240;
		$thumbnail_height = 240;
		$thumb_beforeword = "thumb/";		
		$arr_image_details = getimagesize("$updir".''."$img"); // pass id to thumb name
		$original_width = $arr_image_details[0];
		$original_height = $arr_image_details[1];
		if ($original_width > $original_height) {
			$new_width = $thumbnail_width;
			$new_height = intval($original_height * $new_width / $original_width);
		} else {
			$new_height = $thumbnail_height;
			$new_width = intval($original_width * $new_height / $original_height);
		}
		$dest_x = intval(($thumbnail_width - $new_width) / 2);
		$dest_y = intval(($thumbnail_height - $new_height) / 2);
		if ($arr_image_details[2] == 1) {
			$imgt = "ImageGIF";
			$imgcreatefrom = "ImageCreateFromGIF";
		}
		if ($arr_image_details[2] == 2) {
			$imgt = "ImageJPEG";
			$imgcreatefrom = "ImageCreateFromJPEG";
		}
		if ($arr_image_details[2] == 3) {
			$imgt = "ImagePNG";
			$imgcreatefrom = "ImageCreateFromPNG";
		}		
		if ($imgt) {
			$old_image = $imgcreatefrom("$updir".''."$img");
			$new_image = imagecreatetruecolor($thumbnail_width, $thumbnail_height);
			ImageCopyResampled($new_image, $old_image, $dest_x, $dest_y, 0, 0, $new_width, $new_height, $original_width, $original_height);
			$imgt($new_image, "$updir" . "$thumb_beforeword" . "$img");
		}
	}
	private function success($message) {
        $userdata = array(
            'success' => $message
        );
        $this->session->set_userdata($userdata);
    }

    private function clearmessage() {
        $userdata = array(
            'success' => ''
        );
        $this->session->set_userdata($userdata);
    }

	function profile_edit()
	{
		$get_user_detail=array();
		$user_id=$this->session->userdata('user_id');
		switch ($this->session->userdata('user_type'))  
		{
			case 'admin':$get_user_detail=$this->profile_model->get_admin_profile_details($user_id);break;
			case 'student':$get_user_detail=$this->profile_model->get_student_profile_details($user_id);break;
			case 'parent':$get_user_detail=$this->profile_model->get_parent_profile_details($user_id);break;
			case 'tutor':$get_user_detail=$this->profile_model->get_tutor_profile_details($user_id);break;
			
			
		}
		$ret_result='';
		if(sizeof($get_user_detail)<=0)
		{

			echo $ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
									<div class="close__btn_profile" onclick="closePopup()"></div>
								</div>
							<div class="loginmsg__box"></div>
							<form action="profile" name="edit_profile_registration" id="edit_profile_registration" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											No Details Found				
										</div>
								</div>
							</form>';
			exit;
		}
		else
		{
			if($this->session->userdata('user_logged')=="yes:schooluser" &&($this->session->userdata('user_type')!='superadmin'))
			{
				$ret_result.='
				<div class="pogin__popuphd" style="text-transform:uppercase">
									<h2>Edit Profile</h2>
									<div class="close__btn_profile" onclick="closePopup()"></div>
								</div>
								<div class="loginmsg__box"></div>
								<form action="profile" name="edit_profile_registration" id="edit_profile_registration" enctype="multipart/form-data" method="post">
									<div class="">
										<div class="form">
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													First Name				
												</label>	
												<div class="input__area">				
													<input type="text" value="'.$get_user_detail['first_name'].'" class="input" name="first_name" id="first_name" placeholder="First Name">
													<div id="error_first_name" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Middle Name
												</label>					
												<input type="text" value="'.$get_user_detail['middle_name'].'" class="input" name="middle_name" id="middle_name" placeholder="Middle Name">
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Last Name				
												</label>	
												<div class="input__area">							
													<input type="text" value="'.$get_user_detail['last_name'].'" class="input" name="last_name" id="last_name" placeholder="Last Name">
													<div id="error_last_name" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Address	
												</label>	
												<div class="input__area">					
													<textarea class="input" name="address" id="address" placeholder="Address">'.$get_user_detail['address'].'</textarea>
													<div id="error_address" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Place	
												</label>
												<div class="input__area">					
													<input type="text" value="'.$get_user_detail['place'].'" class="input" name="place" id="place" placeholder="Place">
													<div id="error_place" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													City	
												</label>
												<div class="input__area">					
													<input type="text" value="'.$get_user_detail['city'].'" class="input" name="city" id="city" placeholder="City">
													<div id="error_city" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Email				
												</label>
												<div class="input__area">					
													<input type="text" value="'.$get_user_detail['email'].'" class="input" name="email" id="email" placeholder="Email">
													<div id="error_email" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>
									
											<div class="content_form" role="user-name">
												<label style="padding:0;">
													Profile Pic					
												</label>
												<div class="input__area">
													<a class="attendance_view_link" href="javascript:void(0);" alt="register" onclick="crop_image()">
														<div class="profile_crop_image" id="crop_again"></div>
													</a>
												<div id=" " class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
											</div>

											<div class="content_form" role="user-name">
												<label style="padding:0;">
												</label>	
													<div class="btn_cal">				
														<input type="submit" name="edit_profile" id="edit_profile" class="submit_button_profile" value="Submit" onclick="return edit_profile_registration_validation()">
														<input type="hidden" value="'.$user_id.'" name="edit_profile_id" id="edit_profile_id">
														<input type="reset" name="edit_profile" id="edit_profile" class="submit_button_profile cancel_btn_align" value="Cancel">
													</div>
											</div>										
										</div>
									</div>
								</form>
								';						
						echo $ret_result;
			}
			else
			{
				echo $ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
										<div class="close__btn_profile" onclick="closePopup()"></div>
									</div>
								<div class="loginmsg__box"></div>
								<form action="profile" name="edit_profile_registration" id="edit_profile_registration" enctype="multipart/form-data" method="post">
									<div class="">
										<div class="form">
											<div class="content_form" role="user-name">
												No Details Found				
											</div>
									</div>
								</form>';
				exit;
			}
		}
	}
	function change_password()
	{
		
		
		$user_name=$this->session->userdata('user_code');
		$user_id=$this->session->userdata('user_id');
		switch ($this->session->userdata('user_type')) 
		{
			case 'admin':$get_user_detail=$this->profile_model->get_admin_profile_details($user_id);break;
			case 'student':$get_user_detail=$this->profile_model->get_student_profile_details($user_id);break;
			case 'parent':$get_user_detail=$this->profile_model->get_parent_profile_details($user_id);break;
			case 'tutor':$get_user_detail=$this->profile_model->get_tutor_profile_details($user_id);break;
			
			
		}
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser")
		{
			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Edit Password</h2>
								<div class="close__btn_profile" onclick="closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="profile" name="edit_password_registration" id="edit_password_registration" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Old Password				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="password" id="password" placeholder="Old Password" onblur="check_old_password(this.value)">
												<div id="error_password" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												New Password
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="new_password" id="new_password" placeholder="New Password">
												<div id="error_new_password" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Re-Enter Password				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input" name="re_password" id="re_password" placeholder="Re-Password">
												<div id="error_re_password" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">			
											</label>	
											<div class="btn_cal">				
												<input type="submit" name="edit_password" id="edit_password" class="submit_button_profile" value="Submit" onclick="return edit_password_validation()">
												<input type="hidden" value="'.$user_name.'" name="user_name" id="user_name">
												<input type="reset" name="edit_password" id="edit_password" class="submit_button_profile cancel_btn_align" value="Cancel">
											</div>
										</div>										
								</div>
							
							</form>
							';						
					echo $ret_result;
		}
	}
	function check_oldpassword() 
	{
        if (isset($_POST['password'])) 
        {
            $password = $_POST['password'];
            $md5_passwd = md5($password);
            $user_name=$this->session->userdata('user_code');

            if(($this->session->userdata('user_code')=='super_admin'))
			{
				$condition = "where username='".$user_name."'";	
			}
			else
			{
				$condition = "where username='".$user_name."' AND school_id=".$this->session->userdata('school_id');
			}

            $user_details = $this->profile_model->get_user_admin_password($condition);
            if ($user_details['password'] == $md5_passwd) {
                echo '1';
            } else {
                echo '0';
            }
        }
    }
    
}
?>