<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_School_Message extends Controller {

	function Manage_School_message()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
		$this->load->model('manage_school_message_model');
		$this->load->helper('security');
	}
	
	function index()
	{	
		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');
		
		if(isset($_POST['create_message']))
		{
			$this->load->library('form_validation');			
			$config = array(
				 array(
                     'field'   => 'no_of_message', 
                     'label'   => 'No Of Messages', 
                     'rules'   => 'required'
                  )
			    
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				$this->load->model('manage_school_message_model');
				
				$user_info = array();			
				
				$user_info['school_id'] = $this->session->userdata('school_id');
				$user_info['requested_count'] = $this->input->post('no_of_message');
				$user_info['requested_date'] =date('Y-m-d h:i:s');
				$user_info['status'] =0;

				$result = $this->manage_school_message_model->add_request_message($user_info);
	
				if($result>0)
				{
					$this->success('<p class="success">Message Requested has been successfully Sent</p>');
					redirect($_SERVER['HTTP_REFERER']);
					exit;
				}
				else
				{
					$this->success('<p class="success">Message Requested has been Sending Failed</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}

			}	
				
		}
		if(isset($_POST['edit_message']))
		{
			$this->load->library('form_validation');			
			$config = array(
                 array(
                     'field'   => 'approved_message', 
                     'label'   => 'Approved Messages', 
                     'rules'   => 'required'
                  )
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{			
				$this->load->model('manage_school_message_model');
				
				$user_info = array();	
				$user_id=$this->input->post('message_id');
				$user_info['approved_count']=$this->input->post('approved_message');
				$user_info['approved_date'] = date('Y-m-d h:i:s');
				$user_info['status'] =$this->input->post('edit_status');				
				
		
						
				
				$result = $this->manage_school_message_model->update_school_message($user_info,$user_id);
				if($user_info['status']==1)
				{

					$school_info = array();
					
					$school_id=$this->input->post('school_id');

					$school = $this->manage_school_message_model->check_school_message_exisist($school_id);
					if(sizeof($school)==0)
					{
						$school_info['school_id']=$this->input->post('school_id');
						$school_info['no_of_message']=$this->input->post('approved_message');
						$result = $this->manage_school_message_model->add_school_messages($school_info);
					}
					else
					{
						$approved_count=$this->input->post('approved_message');


					   	$result_school = $this->manage_school_message_model->update_school_message_management($school_info,$school_id,$approved_count);
					}	

				}	
				
				if($result>0)
				{
					
					$this->success('<p class="success">School  Message have been updated successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
				else
				{
					$this->success('<p class="success">School Message have been  not updated</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
			}
		}
		$condition = array();
		if($this->session->userdata('user_type')=='admin')
		{
			$condition= " WHERE ms.school_id=".$this->session->userdata('school_id');
		}
		else if($this->session->userdata('user_type')=='superadmin')
		{
			$condition= "";
		}
			
		$show_data['coorinator_array'] = $this->manage_school_message_model->get_all_message($condition);
		$show_data['message_count'] = $this->manage_school_message_model->get_all_message_count($condition);
		$this->load->view('manage_school_message_view',$show_data);		
	}

	
	private function success($message)
	{
		$userdata = array(
							'success'    => $message
						);
		$this->session->set_userdata($userdata);		
	}
	
	private function clearmessage()
	{
		$userdata = array(
							'success'    => ''
						);
		$this->session->set_userdata($userdata);
	}
	function randomPassword() 
	{
		$alphabet = "0123456789";
		$pass = array();
		$alphaLength = strlen($alphabet) - 1;
		for ($i = 0; $i < 8; $i++) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
		}
		return implode($pass);
	}
	function add_track()
	{
		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');

		$school_id=$this->session->userdata('school_id');
		$school=$this->manage_school_message_model->get_school_details($school_id);
		$condition = array();
		if($this->session->userdata('user_type')=='admin')
		{
			$condition= " WHERE mt.school_id=".$this->session->userdata('school_id');
		}
		else if($this->session->userdata('user_code')=='super_admin')
		{
			$condition= "";
		}
			
		$show_data['coorinator_array'] = $this->manage_school_message_model->get_all_message_track($condition);

		$this->load->view('school_message_track_view',$show_data);

	}
	
	function add_message()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='admin')||$this->session->userdata('user_code')=='admin')
		{
			$school_id=$this->session->userdata('school_id');
			$school=$this->manage_school_message_model->get_school_details($school_id);

			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Add Message</h2>
								<div class="close__btn2" onclick="closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="message_request" id="message_request" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label class="label_message" style="padding:0;">
												School Name				
											</label>
											<div class="input__area">					
												<input type="text" value="'.$school['school_name'].'" class="input " name="school_name" id="school_name" placeholder="School Name" readonly>
												<div id="error_school_name" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label class="label_message" style="padding:0;">
												No of Messages				
											</label>
											<div class="input__area">					
												<input type="text" value="" class="input " name="no_of_message" id="no_of_message" placeholder="No Of Message">
												<div id="error_no_of_message" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label class="label_message" style="padding:0;">
											</label>	
											<div class="btn_cal">				
												<input type="submit" name="create_message" id="create_message" class="submit_button_profile school_color" value="Submit" onclick="return add_message_request_validation()">
												<input type="reset" name="create_school" id="create_school" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
											</div>
										</div>
										
																				
									</div>
								</div>
							</form>
							';
													
									
					echo $ret_result;
					exit;
		}
	}
	function view_message()
	{
		$ret_result='';
		$track_id=$_POST['id'];
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='admin')||$this->session->userdata('user_code')=='admin')
		{
			$message=$this->manage_school_message_model->get_all_message_track_details($track_id);
			$school_id=$this->session->userdata('school_id');
			$school=$this->manage_school_message_model->get_school_details($school_id);


			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>View Message</h2>
								<div class="close__btn2" onclick="closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="message_request" id="message_request" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label class="label_message" style="padding:0;">
												School Name				
											</label>
											<div class="input__area">					
												<div style="width: 272px;margin-top:10px">'.$school['school_name'].'</div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label class="label_message" style="padding:0;">
												Subject				
											</label>
											<div class="input__area">					
												<div style="width: 272px;margin-top:10px">'.$message['subject'].'</div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Message				
											</label>
											<div class="input__area">				
												<div style="height:auto;width: 272px;margin-left: 40px;margin-top:10px">'.$message['message'].'</div>
											</div>
											<div class="clear"></div>
										</div>
										
																				
									</div>
								</div>
							</form>
							';
													
									
					echo $ret_result;
					exit;
		}
	}
	
	function edit_message()
	{
		$user_details = array();
		$ret_result = '';
		$data=$_POST['id'];

		if($this->session->userdata('user_logged')=="yes:schooluser")
		{			
			$this->load->model('manage_school_message_model');
			$user_details = $this->manage_school_message_model->get_message_details($data);
			if(sizeof($user_details)>0)
			{
				$status = $user_details['status']==0?'<span class="s__pending">Pending</span>':'<span class="s__completed">Approved</span>';
				$disableselect =  $user_details['status']==0?'selected':'';
				$enableselect =  $user_details['status']==1?'selected':'';
				$disableselect =  $user_details['status']==2?'selected':'';


				$condition = array();
				$condition= " WHERE ms.school_id=".$user_details['school_id'];
				$message_count= $this->manage_school_message_model->get_all_message_count($condition);
				if(sizeof($message_count)>0)
				{
					$message_balance=$message_count['no_of_message'];
				}
				else
				{
					$message_balance=0;
				}

				$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
							<h2>Edit Message </h2>
							<div class="close__btn2" onclick="closePopup()"></div>
						</div>
						<div class="loginmsg__box"></div>
						<form action="" name="edit_school_message" id="edit_school_message" enctype="multipart/form-data" method="post">
							<div class="">
								<div class="form">
									<div class="content_form" role="user-name">
					
										<div class="input__area" style="padding-top:9px;">			
											Message Balance : '.$message_balance.'
										</div>
										<div class="clear"></div>
									</div>
									<div class="content_form" role="user-name">
										<label class="label_message" style="padding:0;">
											School Name				
										</label>
										<div class="input__area">					
											<div style="width: 272px;margin-top:10px">'.$user_details['school_name'].'</div>
											</div>
											<div class="clear"></div>
										</div>
									<div class="content_form" role="user-name">
										<label class="label_message" style="padding:0;">
											No of Messages				
										</label>
										<div class="input__area">					
											<div style="width: 272px;margin-top:10px">'.$user_details['requested_count'].'</div>
											</div>
											<div class="clear"></div>
									</div>
									<div class="content_form" role="user-name">
										<label class="label_message" style="padding:0;">
											Message Date				
										</label>
										<div class="input__area">					
											<div style="width: 272px;margin-top:10px">'.date('d-m-Y',strtotime($user_details['requested_date'])).'</div>
											</div>
											<div class="clear"></div>
									</div>
									<div class="content_form" role="user-name">
										<label class="label_message" style="padding:0;">
										  Approved Message				
										</label>
										<div class="input__area">					
											<input type="text" value="'.$user_details['requested_count'].'" class="input " name="approved_message" id="approved_message" placeholder="No Of Approved Message" onblur="check_no_of_messages(this.value)">
											<div id="error_approved_message" class="val__msgbx"></div>
										</div>
										<div class="clear"></div>
									</div>
									<div class=" content_form">
										<label class="label_message">Status</label>
										<div class="input__area">
											<select class="input arrow status_text" name="edit_status" id="edit_status">
												<option value="">Select Status</option>
												<option value="1" '.$enableselect.'>Approved</option>
												<option value="2" '.$disableselect.'>Rejected</option>													
											</select>
											<div id="error_edit_status" class="val__msgbx"></div>
										</div>
										<div class="clear"></div>
									</div>
									<div class="content_form" role="user-name">
										<label  class="label_message" style="padding:0;">
										</label>	
										<div class="btn_cal">				
											<input type="submit" name="edit_message" id="edit_message" class="submit_button_profile school_color" value="Submit" onclick="return edit_school_message_validation()">
											<input type="hidden" value="'.$user_details['message_id'].'" name="message_id" id="message_id">
											<input type="hidden" value="'.$user_details['school_id'].'" name="school_id" id="school_id">
											<input type="hidden" value="'.$user_details['requested_count'].'" name="no_of_message" id="no_of_message">
											<input type="reset" name="edit_school" id="edit_school" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
										</div>
									</div>									
								</div>
							</div>
						</form>
						';
								
								
				echo $ret_result;
				exit;				
			}
			else
			{
				echo $ret_result;
				exit;
			}
		}
			
	}	
}

?>