<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_School extends Controller {

	function Manage_School()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
		$this->load->model('manage_school_model');
		$this->load->helper('security');
	}
	
	function index()
	{	
		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');
		
		if(isset($_POST['create_school']))
		{
			$this->load->library('form_validation');			
			$config = array(
				 array(
                     'field'   => 'school_name', 
                     'label'   => 'School Name', 
                     'rules'   => 'required'
                  ),
				 array(
                     'field'   => 'school_code', 
                     'label'   => 'School Code', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'place', 
                     'label'   => 'Place', 
                     'rules'   => 'required'
                  ),
                array(
                     'field'   => 'contact_no', 
                     'label'   => 'Contact No', 
                     'rules'   => 'required'
                  ),
                array(
                     'field'   => 'email', 
                     'label'   => 'Email', 
                     'rules'   => 'required'
                  )
			  
			  
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				$this->load->model('manage_school_model');
				
				$user_info = array();			
				
				$user_info['school_name'] = ucfirst($this->input->post('school_name'));
				$user_info['school_code'] = ucfirst($this->input->post('school_code'));
				$user_info['place'] = ucfirst($this->input->post('place'));
				$mobile_no= substr($this->input->post('contact_no'),-9);
				$user_info['contact_no']  = str_pad($mobile_no,13,'+254',STR_PAD_LEFT);
				$user_info['email'] =$this->input->post('email');
				$user_info['status'] =1;
				

				$result = $this->manage_school_model->add_school($user_info);
				if($result>0)
				{
					if($user_info['status']==1)
					{
						$admin_details_info = array();
						$admin_details_info['school_id'] = $result;
						$admin_details_info['email'] = $this->input->post('email');
						$admin_details_info['place'] = ucfirst($this->input->post('place'));
						$admin_details_info['created_date'] = date('Y-m-d');
						$result1= $this->manage_school_model->add_admin_details($admin_details_info);
						if($result1>0)
						{
							$admin_info = array();									
							$admin_info['username']='SCL-AD-'.str_pad($result1, 4, '0', STR_PAD_LEFT);
							$password = $this->randomPassword();
							$admin_info['password']= dohash($password, 'md5');
							$admin_info['users_details_id'] = $result1;
							$admin_info['role_id'] = 1;
							$admin_info['school_id'] = $result;

							$uresult = $this->manage_school_model->add_user_details($admin_info);
							
							if($uresult>0)
							{
								if(($this->input->post('email'))!='')
								{
									$message = '';
									$message .= 'You have successfully registered as Admin <br /><br />';
									$message .= 'E-mail Address: '.$this->input->post('email').'<br /><br />';
									$message .= 'User Name: '.$admin_info['username'].'<br /><br />';
									$message .= 'Password: '.$password.'<br /><br />';
									
									$this->load->library('email');
									$this->email->to($this->input->post('email'));
									$this->email->cc('muhammedilyasy20@gmail.com');
									$this->email->from('no-reply@school.com');
									$this->email->subject('Admin Details');
									$this->email->message($message);
									
									if ($this->email->send())
									{
										$this->success('<p class="success">Admin Registration has been created successfully</p>');
										redirect($_SERVER['HTTP_REFERER']);
										exit;
									}
									else
									{
										$this->success('<p class="success">Admin Registration has been created.Email Sending Failed</p>');
										redirect($_SERVER['HTTP_REFERER']);
									}
								}						
							}
						}

					}

					$this->success('<p class="success">School have been added successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}	
				
			
			}
		}
		if(isset($_POST['edit_school']))
		{
			$this->load->library('form_validation');			
			$config = array(
                 array(
                     'field'   => 'school_name', 
                     'label'   => 'School Name', 
                     'rules'   => 'required'
                  ),
                  array(
                     'field'   => 'school_code', 
                     'label'   => 'School Code', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'place', 
                     'label'   => 'Place', 
                     'rules'   => 'required'
                  ),
                array(
                     'field'   => 'contact_no', 
                     'label'   => 'Contact No', 
                     'rules'   => 'required'
                  )
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{			
				$this->load->model('manage_school_model');
				
				$user_info = array();	
				$user_id=$this->input->post('user_id');
				$user_mail_id['email']=$this->input->post('user_mail_id');
				$user_info['school_name'] = ucfirst($this->input->post('school_name'));
				$user_info['school_code'] = ucfirst($this->input->post('school_code'));
				$user_info['place'] = ucfirst($this->input->post('place'));
				$mobile_no= substr($this->input->post('contact_no'),-9);
				$user_info['contact_no']  = str_pad($mobile_no,13,'+254',STR_PAD_LEFT);
				$user_info['status'] =$this->input->post('edit_status');				
				
				
						
				
				$result = $this->manage_school_model->update_school($user_info,$user_id);	
				
				if($result>0)
				{
					
					$this->success('<p class="success">School have been updated successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
				else
				{
					$this->success('<p class="success">School have been  not updated</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
			}
		}
		$show_data['coorinator_array'] = $this->manage_school_model->get_all_schools();
		$this->load->view('manage_school_view',$show_data);		
	}

	
	private function success($message)
	{
		$userdata = array(
							'success'    => $message
						);
		$this->session->set_userdata($userdata);		
	}
	
	private function clearmessage()
	{
		$userdata = array(
							'success'    => ''
						);
		$this->session->set_userdata($userdata);
	}
	function randomPassword() 
	{
		$alphabet = "0123456789";
		$pass = array();
		$alphaLength = strlen($alphabet) - 1;
		for ($i = 0; $i < 8; $i++) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
		}
		return implode($pass);
	}
	
	function add()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='superadmin')||$this->session->userdata('user_code')=='super_admin')
		{
			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
												<h2>Add School</h2>
												<div class="close__btn2" onclick="closePopup()"></div>
											</div>
											<div class="loginmsg__box"></div>
											<form action="" name="school_registration" id="school_registration" enctype="multipart/form-data" method="post">
												<div class="">
													<div class="form">
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																School Name				
															</label>
															<div class="input__area">					
																<input type="text" value="" class="input " name="school_name" id="school_name" placeholder="School Name">
																<div id="error_school_name" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																School Code				
															</label>
															<div class="input__area">					
																<input type="text" value="" class="input " name="school_code" id="school_code" placeholder="School Code">
																<div id="error_school_code" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Place				
															</label>
															<div class="input__area">					
																<input type="text" value="" class="input " name="place" id="place" placeholder="Place">
																<div id="error_place" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Contact No			
															</label>
															<div class="input__area">					
																<input type="text" value="" class="input " name="contact_no" id="contact_no" placeholder="Contact No">
																<div id="error_contact_no" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Email			
															</label>
															<div class="input__area">					
																<input type="text" value="" class="input " name="email" id="email" placeholder="Email">
																<div id="error_email" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
															</label>	
															<div class="btn_cal">				
																<input type="submit" name="create_school" id="create_school" class="submit_button_profile school_color" value="Submit" onclick="return school_registration_validation()">
																<input type="reset" name="create_school" id="create_school" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
															</div>
														</div>
														
																								
													</div>
												</div>
											</form>
											';
													
									
					echo $ret_result;
					exit;
		}
	}
	
	function edit()
	{
		$user_details = array();
		$ret_result = '';
		$data=$_POST['id'];
		
		if($this->session->userdata('user_logged')=="yes:schooluser")
		{			
			$this->load->model('manage_school_model');
			$user_details = $this->manage_school_model->get_school_details($data);
			if(sizeof($user_details)>0)
			{
				$status = $user_details['status']==0?'<span class="s__pending">Pending</span>':'<span class="s__completed">Approved</span>';
				$disableselect =  $user_details['status']==0?'selected':'';
				$enableselect =  $user_details['status']==1?'selected':'';
				$disableselect =  $user_details['status']==2?'selected':'';

			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
							<h2>Edit School</h2>
							<div class="close__btn2" onclick="closePopup()"></div>
						</div>
						<div class="loginmsg__box"></div>
						<form action="" name="edit_school_registration" id="edit_school_registration" enctype="multipart/form-data" method="post">
							<div class="">
								<div class="form">
									<div class="content_form" role="user-name">
										<label style="padding:0;">
											School Name				
										</label>
										<div class="input__area">					
											<input type="text" value="'.$user_details['school_name'].'" class="input " name="school_name" id="school_name" placeholder="School Name">
											<div id="error_school_name" class="val__msgbx"></div>
										</div>
										<div class="clear"></div>
									</div>
									<div class="content_form" role="user-name">
										<label style="padding:0;">
											School Code			
										</label>
										<div class="input__area">					
											<input type="text" value="'.$user_details['school_code'].'" class="input " name="school_code" id="school_code" placeholder="School Code">
											<div id="error_school_code" class="val__msgbx"></div>
										</div>
										<div class="clear"></div>
									</div>
									<div class="content_form" role="user-name">
										<label style="padding:0;">
											Place				
										</label>
										<div class="input__area">					
											<input type="text" value="'.$user_details['place'].'" class="input" name="place" id="place" placeholder="Place">
											<div id="error_place" class="val__msgbx"></div>
										</div>
										<div class="clear"></div>
									</div>
									<div class="content_form" role="user-name">
										<label style="padding:0;">
											Contact No				
										</label>
										<div class="input__area">					
											<input type="text" value="'.$user_details['contact_no'].'" class="input" name="contact_no" id="contact_no" placeholder="Contact No">
											<div id="error_contact_no" class="val__msgbx"></div>
										</div>
										<div class="clear"></div>
									</div>
									<div class=" content_form">
										<label>Status</label>
										<select class="input arrow status_text" name="edit_status" id="edit_status">
											<option value="0" '.$disableselect.'>Pending</option>
											<option value="1" '.$enableselect.'>Approved</option>
											<option value="2" '.$disableselect.'>Suspended</option>													
										</select>
									</div>
									<div class="content_form" role="user-name">
										<label style="padding:0;">
										</label>	
										<div class="btn_cal">				
											<input type="submit" name="edit_school" id="edit_school" class="submit_button_profile school_color" value="Submit" onclick="return edit_school_registration_validation()">
											<input type="hidden" value="'.$user_details['school_id'].'" name="user_id" id="user_id">
											<input type="hidden" value="'.$user_details['email'].'" name="user_mail_id" id="user_mail_id">
											<input type="reset" name="edit_school" id="edit_school" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
										</div>
									</div>									
								</div>
							</div>
						</form>
						';
								
								
				echo $ret_result;
				exit;				
			}
			else
			{
				echo $ret_result;
				exit;
			}
		}
			
	}	
}

?>