<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_Function extends Controller {

	function Manage_Function()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
		$this->load->model('manage_function_model');
		$this->load->helper('security');
	}
	
	function index()
	{	
		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		
		if(isset($_POST['create_function']))
		{
			$this->load->library('form_validation');			
			$config = array(
				 array(
                     'field'   => 'name', 
                     'label'   => 'Function Name', 
                     'rules'   => 'required'
                  )
			  
			  
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				$this->load->model('manage_function_model');
				
				$user_info = array();			
				
				$user_info['name'] = ucfirst($this->input->post('name'));

				$result = $this->manage_function_model->add_function($user_info);
				if($result>0)
				{

					$this->success('<p class="success">Function have been added successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
				else
					{
					$this->success('<p class="success">Function have been updated successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}	
				
			
			}
		}
		if(isset($_POST['edit_function']))
		{
			$this->load->library('form_validation');			
			$config = array(
                 array(
                     'field'   => 'name', 
                     'label'   => 'Function Name', 
                     'rules'   => 'required'
                  )
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{			
				$this->load->model('manage_function_model');
				
				$user_info = array();	
				$user_id=$this->input->post('user_id');
				$user_info['name'] = ucfirst($this->input->post('name'));				
				
				$result = $this->manage_function_model->update_function($user_info,$user_id);	
	
				if($result>0)
				{
					$this->success('<p class="success">Function have been updated successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
				else
					{
					$this->success('<p class="success">Function have been updated failed</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
			}
		}
		$show_data['coorinator_array'] = $this->manage_function_model->get_all_function();
		$this->load->view('manage_function_view',$show_data);		
	}

	
	private function success($message)
	{
		$userdata = array(
							'success'    => $message
						);
		$this->session->set_userdata($userdata);		
	}
	
	private function clearmessage()
	{
		$userdata = array(
							'success'    => ''
						);
		$this->session->set_userdata($userdata);
	}
	function add()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='superadmin'))
		{
			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
												<h2>Add Function</h2>
												<div class="close__btn2" onclick="closePopup()"></div>
											</div>
											<div class="loginmsg__box"></div>
											<form action="" name="function_registration" id="function_registration" enctype="multipart/form-data" method="post">
												<div class="">
													<div class="form">
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Function Name				
															</label>
															<div class="input__area">					
																<input type="text" value="" class="input " name="name" id="name" placeholder="Function Name">
																<div id="error_name" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														
														<div class="content_form" role="user-name">
															<label style="padding:0;">
															</label>	
															<div class="btn_cal">				
																<input type="submit" name="create_function" id="create_function" class="submit_button_profile school_color" value="Submit" onclick="return function_registration_validation()">
																<input type="reset" name="create_function" id="create_function" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
															</div>
														</div>
														
																								
													</div>
												</div>
											</form>
											';
													
									
					echo $ret_result;
					exit;
		}
	}
	
	function edit()
	{
		$user_details = array();
		$ret_result = '';
		$data=$_POST['id'];
		
		if($this->session->userdata('user_logged')=="yes:schooluser")
		{			
			$this->load->model('manage_school_model');
			$user_details = $this->manage_function_model->get_function_details($data);
			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
							<h2>Edit School</h2>
							<div class="close__btn2" onclick="closePopup()"></div>
						</div>
						<div class="loginmsg__box"></div>
						<form action="" name="edit_function_registration" id="edit_function_registration" enctype="multipart/form-data" method="post">
							<div class="">
								<div class="form">
								<div class="content_form" role="user-name">
										<label style="padding:0;">
											Function Name				
										</label>
										<div class="input__area">					
											<input type="text" value="'.$user_details['name'].'" class="input " name="name" id="name" placeholder="School Name">
											<div id="error_name" class="val__msgbx"></div>
										</div>
										<div class="clear"></div>
									</div>
									
									<div class="content_form" role="user-name">
										<label style="padding:0;">
										</label>	
										<div class="btn_cal">				
											<input type="submit" name="edit_function" id="edit_function" class="submit_button_profile school_color" value="Submit" onclick="return edit_function_registration_validation()">
											<input type="hidden" value="'.$user_details['function_id'].'" name="user_id" id="user_id">
											<input type="reset" name="edit_function" id="edit_function" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
										</div>
									</div>									
								</div>
							</div>
						</form>
						';
								
								
				echo $ret_result;
				exit;				
		}
	}

}

?>