<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Exam_Result extends Controller {

	function Exam_Result()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
		$this->load->model('exam_result_model');
		$this->load->model('timetable_model');
		$this->load->helper('security');
	}
	
	function index()
	{	
		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');
		$show_data['announced_exam'] = array();
		$show_data['coorinator_array'] =array();

		if(isset($_POST['view_exam_result']))
		{
			$this->load->library('form_validation');			
			$config = array(
				array(
                     'field'   => 'exam_type', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'exam_sub_type', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'exam_sub_type_class', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'exam_sub_type_syllabus', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'exam', 
                     'rules'   => 'required'
                  )
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				$this->load->model('exam_result_model');

				$exam_class=$this->input->post('exam_sub_type_class');
				$exam_syllabus=$this->input->post('exam_sub_type_syllabus');
				$exam_id=$this->input->post('exam');
				$coorinator_array= $this->exam_result_model->get_all_result_exam($exam_class,$exam_syllabus,$exam_id);	
				if(sizeof($coorinator_array)>0)
				{
					$show_data['coorinator_array'] = $coorinator_array;
					
				}
				else
				{
					$show_data['data_found'] ='No Details Found';
					$show_data['coorinator_array'] =array();
				
				}
				
			
			}
		}
		if(isset($_POST['edit_exam_result']))
		{
			$this->load->library('form_validation');			
			$config = array(
               array(
                     'field'   => 'exam_type',  
                     'rules'   => 'required'
                  ),
				 array(
                     'field'   => 'student',  
                     'rules'   => 'required'
                  ),

				 array(
                     'field'   => 'mark_obtained',
                     'label'   => 'Mark Obtained',
                     'rules'   => 'required'
                  )
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{			
				
				$user_info = array();	
				$user_id=$this->input->post('user_id');		
				$user_info['exam_id'] = $this->input->post('exam_type');
				$user_info['student_id'] = $this->input->post('student');
				$user_info['mark_obtained'] = $this->input->post('mark_obtained');
				$pass_mark=$this->input->post('pass_mark');
				if($user_info['mark_obtained']>=$pass_mark)
				{
					$user_info['pass_flag'] =0;	
				}
				else
				{
					$user_info['pass_flag'] =1;
				}
	
				$result = $this->exam_result_model->update_exam_result($user_info,$user_id);	
	
				if($result>0)
				{
					$this->success('<p class="success">Exam Result have been updated successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
				else
					{
					$this->success('<p class="success">Exam Result have been updated failed</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
			}
		}
		if(isset($_POST['create_dowload_sheet']))
		{
			$this->load->library('form_validation');			
			$config = array(
				array(
                     'field'   => 'exam_type', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'exam_sub_type', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'exam_sub_type_class', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'exam_sub_type_syllabus', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'exam', 
                     'rules'   => 'required'
                  )
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				$this->load->model('exam_result_model');

				$exam_class=$this->input->post('exam_sub_type_class');
				$exam_syllabus=$this->input->post('exam_sub_type_syllabus');
				$exam_id=$this->input->post('exam');
				$exam_sub_type=$this->input->post('exam_sub_type');
				$exam_type=$this->input->post('exam_type');
				$student = $this->exam_result_model->get_student_details($exam_class,$exam_syllabus);
				

				$result = $this->exam_result_model->get_download($exam_id,$exam_type,$exam_sub_type); 
				
				// echo "<pre>";
				// print_r($result);die;
				$folder='timesheet/exam_result';
				if(sizeof($result)>0)
				{
					$name1 =$result['exam_name'];
					$name2=explode(" ", $name1);
					$name=$name2[0];
					$this->load->helper('amountinwords');

					$this->load->helper(array('timesheet', 'file'));

					$result=create_timesheet($result,$folder,$name,$student);
					if($result==1)
					{

					
						$path=base_url().'timesheet/exam_result/'.$name.date('dmY').'.xlsx';
						redirect($path);
						// header ('Content-Type: application/vnd.ms-excel; charset=utf-8');
				  //       header ('Content-Disposition: attachment; filename="'.$name.date('dmY').'.xlsx"'); 
				  //       header("Expires: 0");
				  //       header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
				  //       header("Cache-Control: private",false);
				  //       readfile($path);
						// exit();
					}
				}

			}
		}
		if(isset($_POST['create_upload_sheet']))
		{

			$this->load->library('form_validation');			
			$config = array(
				array(
                     'field'   => 'file_upload', 
                     'label'   => 'File Upload' 
                  )
			);
			$this->form_validation->set_rules($config);
			
			$result=$this->messagebulkupload();
				
		}
			if(isset($_GET['student_id']))
			{

				if(($_GET['student_id']==''))
				{
					redirect(base_url().'index.php/exam_result?exam_id=');
				}
	 			else if(($_GET['student_id']!=''))
				{
					if($this->session->userdata('user_type')=='parent')
					{
						$student_id=$_GET['student_id'];
						$user_id=$this->session->userdata('user_id');
						$division=$this->timetable_model->get_student_division($student_id);
						$division_id=$division['class_division_id'];
						$classid=$division['class_id'];
						$syllabus_id=$division['syllabus_id'];
						$show_data['select_student'] = $this->timetable_model->get_parent_students($user_id);
						$show_data['announced_exam'] = $this->exam_result_model->get_all_announced_exam($classid,$syllabus_id);
						
					}
				}
			}
			if(isset($_GET['exam_id']) && isset($_GET['student_id']))
			{

				if(($_GET['exam_id']=='') && ($_GET['student_id']==''))
				{
					redirect(base_url().'index.php/exam_result?exam_id=');
				}
	 			else if(($_GET['exam_id']!='') &&($_GET['student_id']!=''))
				{
					if(($this->session->userdata('user_type')=='parent')||($this->session->userdata('user_type')=='student'))
					{
						$student_id=$_GET['student_id'];
						$exam_id=$_GET['exam_id'];
						$user_id=$this->session->userdata('user_id');
						$division=$this->timetable_model->get_student_division($student_id);
						$division_id=$division['class_division_id'];
						$classid=$division['class_id'];
						$syllabus_id=$division['syllabus_id'];
						$show_data['select_student'] = $this->timetable_model->get_parent_students($user_id);
						$show_data['announced_exam'] = $this->exam_result_model->get_all_announced_exam($classid,$syllabus_id);
						$student_details = $this->exam_result_model->get_exam_result_student_details_student_view($exam_id,$user_id);
						if(sizeof($student_details)>0)
						{
							$show_data['coorinator_array'] =$student_details;
							
						}
						else
						{
							$show_data['data_found'] ='No Details Found';
							$show_data['coorinator_array']=array();
						}
					}

				}
			}

		if(isset($_GET['exam_id'])&& isset($_GET['classid'])&& isset($_GET['divisionid']))
		{

			if(($_GET['exam_id']=='')&& ($_GET['classid']=='')&&($_GET['divisionid']==''))
			{
				redirect(base_url().'index.php/exam_result?exam_id=');
			}
			else if(($_GET['exam_id']=='')&& ($_GET['classid']!='')&&($_GET['divisionid']==''))
			{
				if($this->session->userdata('user_type')=='admin')
				{
					$i=$_GET['classid'];
					$condition ="cd.class_id=".$i." AND c.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."'";
					$show_data['classid']=$i;
					$show_data['division_data']=$this->exam_result_model->get_all_divisions($condition);
					$show_data['announced_exam'] =array();
				}
				else if($this->session->userdata('user_type')=='tutor')
				{
					$i=$_GET['classid'];
					$show_data['classid']=$i;
					$user_id=$this->session->userdata('user_id');
					$show_data['division_data']=$this->exam_result_model->get_tutor_class_division($user_id,$i);
					$show_data['announced_exam'] =array();
				}
			}
			else if(($_GET['exam_id']=='')&& ($_GET['classid']!='')&&($_GET['divisionid']!=''))
			{
				$i=$_GET['classid'];
				$j=$_GET['divisionid'];
				if($this->session->userdata('user_type')=='admin')
				{
					$condition ="cd.class_id=".$i." AND c.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."'";;
					$show_data['division_data']=$this->exam_result_model->get_all_divisions($condition);
				}
				else if($this->session->userdata('user_type')=='tutor')
				{
					$i=$_GET['classid'];
					$show_data['classid']=$i;
					$user_id=$this->session->userdata('user_id');
					$show_data['division_data']=$this->exam_result_model->get_tutor_class_division($user_id,$i);
				}

				$syllabus_id=$this->exam_result_model->get_current_syllabus($i,$j);
				$show_data['announced_exam'] = $this->exam_result_model->get_all_announced_exam($i,$syllabus_id['syllabus_id']);
			}
			else if(($_GET['exam_id']!='')&& ($_GET['classid']!='')&&($_GET['divisionid']!=''))
			{
				$exam_id=$_GET['exam_id'];
				$i=$_GET['classid'];
				$j=$_GET['divisionid'];
				if($this->session->userdata('user_type')=='admin')
				{
					$condition ="cd.class_id=".$i." AND c.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."'";;
					$show_data['division_data']=$this->exam_result_model->get_all_divisions($condition);
					$student_details = $this->exam_result_model->get_exam_result_student_details($exam_id);
				}
				else if($this->session->userdata('user_type')=='tutor')
				{
					$i=$_GET['classid'];
					$show_data['classid']=$i;
					$user_id=$this->session->userdata('user_id');
					$show_data['division_data']=$this->exam_result_model->get_tutor_class_division($user_id,$i);
					$student_details = $this->exam_result_model->get_exam_result_student_details($exam_id);
				}
				if(sizeof($student_details)>0)
				{
					$show_data['coorinator_array'] =$student_details;
					
				}
				else
				{
					$show_data['data_found'] ='No Details Found';
					$show_data['coorinator_array']=array();
				}
			}

		}

		if($this->session->userdata('user_type')=='admin')
		{
			$condition=" WHERE school_id=".$this->session->userdata('school_id');
			$show_data['all_class'] = $this->exam_result_model->get_all_class($condition);
		}
		else if($this->session->userdata('user_type')=='tutor')
		{
			$condition="WHERE sct.tutor_id=".$this->session->userdata('user_id')." AND school_id=".$this->session->userdata('school_id');
			$all_class = $this->exam_result_model->get_class($condition);
			$show_data['all_class'] = $all_class;
		}
		else if($this->session->userdata('user_type')=='parent')
		{
			$user_id=$this->session->userdata('user_id');
			$show_data['select_student'] = $this->timetable_model->get_parent_students($user_id);
		}
		else if($this->session->userdata('user_type')=='student')
		{
			$user_id=$this->session->userdata('user_id');
			$division=$this->timetable_model->get_student_division($user_id);
			$division_id=$division['class_division_id'];
			$classid=$division['class_id'];
			$syllabus_id=$division['syllabus_id'];
			$show_data['announced_exam'] = $this->exam_result_model->get_all_announced_exam($classid,$syllabus_id);
		}
		
		$this->load->view('exam_result_view',$show_data);		
	}
	function messagebulkupload()
	{
		$uploaddir = 'timesheet/Result/'; 
		
		$file = $uploaddir .$_FILES['file_upload']['name']; 
		$file_name= $_FILES['file_upload']['name'];
	
		if (move_uploaded_file($_FILES['file_upload']['tmp_name'], $file))
		{ 
		
			$this->load->helper(array('timesheet', 'file'));
			$upload_array=read_sheet($file);		
			$exam_id=$upload_array[5]['C'];	
			$pass_mark=$upload_array[9]['C'];
			$upload_info=array();
			$delete_exam_result =$this->exam_result_model->delete_same_exam_result($exam_id);
			
			for($i=15;sizeof($upload_array)-15 >$i;$i++)
			{
				if($upload_array[$i]['B']=='' && $upload_array[$i]['C']=='')
				{
					break;
				}
				$data=array();
				$data=array('exam_id'=>$exam_id,'student_id'=>$upload_array[$i]['B'],'pass_mark'=>$pass_mark,'mark_obtained'=>$upload_array[$i]['D']);

				array_push($upload_info,$data);
			
				
			}
				// echo'<pre>';
				// print_r($upload_info);die;
			if(sizeof($upload_info)>0)
			{
				foreach($upload_info as $upload_details)
				{	
					if($upload_details['mark_obtained'] >=$upload_details['pass_mark'])
					{
						$pass_flag = 0;
					}
					else
					{
						$pass_flag= 1;
					}
					
					$info=array('exam_id'=>$upload_details['exam_id'],'student_id'=>$upload_details['student_id'],'mark_obtained'=>$upload_details['mark_obtained'],'pass_flag'=>$pass_flag);
					$this->exam_result_model->add_exam_result($info);
				}
				if($info>0)
				{
					$this->success('<p class="success">File Upload have been updated successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
				
			}				
		}
	}

	
	private function success($message)
	{
		$userdata = array(
							'success'    => $message
						);
		$this->session->set_userdata($userdata);		
	}
	
	private function clearmessage()
	{
		$userdata = array(
							'success'    => ''
						);
		$this->session->set_userdata($userdata);
	}
	function view_exam_result()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='admin')||($this->session->userdata('user_type')=='tutor'))
		{
			$exam_types = $this->exam_result_model->get_all_exam_types();
			$examname = $this->exam_result_model->get_all_exam_name();

			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
												<h2>View Exam Result </h2>
												<div class="close__btn2" onclick="closePopup()"></div>
											</div>
											<div class="loginmsg__box"></div>
											<form action="exam_result?exam_id=" name="exam_result_registration" id="exam_result_registration" enctype="multipart/form-data" method="post">
												<div class="">
													<div class="form">
														<div class="content_form" role="user-name">
															<label style="padding:0;font-family: font;">
																Exam Type	
															</label>
															<div class="input__area">					
																<select class="inputnew arrow2" name="exam_type" id="exam_type" onchange="get_exam_sub_types(this)">
					                                            	<option value="">Select Exam Type</option>';

					                                            		foreach ($exam_types as $exam_type) 
					                                            		{
					                                            			$ret_result.='<option value="'.$exam_type['exam_type_id'].'">'.$exam_type['exam_type_name'].'</option>';
					                                            		}


															    $ret_result.='</select><div id="error_exam_type" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Exam Sub Type		
															</label>
															<div class="input__area">	
																<select class="inputnew arrow2" name="exam_sub_type" id="exam_sub_type" onchange="get_exam_sub_types_class(this)">
																	<option value="">Select Exam Sub Type</option>
																</select>
																<div id="error_exam_sub_type" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Class		
															</label>
															<div class="input__area">	
																<select class="inputnew arrow2" name="exam_sub_type_class" id="exam_sub_type_class" onchange="get_exam_sub_types_syllabus(this)">
																	<option value="">Select Class</option>
																</select>
																<div id="error_exam_sub_type_class" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Syllabus		
															</label>
															<div class="input__area">	
																<select class="inputnew arrow2" name="exam_sub_type_syllabus" id="exam_sub_type_syllabus" onchange="get_all_exam_details(this)">
																	<option value="">Select Syllabus</option>
																</select>
																<div id="error_exam_sub_type_syllabus" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Exam		
															</label>
															<div class="input__area">	
																<select class="inputnew arrow2" name="exam" id="exam">
																	<option value="">Select Exam</option>
																</select>
																<div id="error_exam" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
															</label>	
															<div class="btn_cal">				
																<input type="submit" name="view_exam_result" id="view_exam_result" class="submit_button_profile school_color" value="Submit" onclick="return add_exam_result_validation()">
																<input type="reset" name="view_exam_result" id="view_exam_result" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
															</div>
														</div>										
													</div>
												</div>
											</form>
											';
													
									
					echo $ret_result;
					exit;
		}
	}
	
	function edit()
	{
		$ret_result = '';
		$exam_result_id=$_POST['exam_result_id'];
		
		if($this->session->userdata('user_logged')=="yes:schooluser")
		{			
			$user_details = $this->exam_result_model->get_exam_details($exam_result_id);
			// echo "<pre>";
			// print_r($user_details);die;

			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
							<h2>Edit Semester Exam</h2>
							<div class="close__btn2" onclick="closePopup()"></div>
						</div>
						<div class="loginmsg__box"></div>
						<form action="" name="edit_exam_result_registration" id="edit_exam_result_registration" enctype="multipart/form-data" method="post">
							<div class="">
								<div class="form">
									<div class="content_form" role="user-name">
										<label style="padding:0;font-family: font;">
											Exam Name	
										</label>
										<div class="input__area">					
											<input type="text" class="input adddate "value="'.$user_details['exam_name'].'" name="exam_name" id="exam_name" readonly>	
											<input type="hidden"name="exam_type"  value="'.$user_details['exam_id'].'" id="exam_type">
										</div>
										<div class="clear"></div>
									</div>
									<div id="division_id">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Student Name		
											</label>
											<div class="input__area">	
												<input type="text" class="input adddate " value="'.$user_details['first_name'].''.$user_details['last_name'].'" name="student_name" id="student_name" readonly>	
												<input type="hidden"name="student"  value="'.$user_details['student_id'].'" id="student">
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Max Mark 	
											</label>
											<input type="text" class="input adddate "value="'.$user_details['maximum_mark'].'" name="maximum_mark" id="maximum_mark" readonly>	
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Pass Mark 	
											</label>
											<input type="text" class="input adddate "value="'.$user_details['pass_mark'].'" name="pass_mark" id="pass_mark" readonly>	
										</div>
									</div>
									<div class="content_form" role="user-name">
										<label style="padding:0;">
											Mark Obtained				
										</label>
										<div class="input__area">					
											<input type="text" value="'.$user_details['mark_obtained'].'"class="input adddate" name="mark_obtained" id="mark_obtained" placeholder="Mark Obtained" onblur="check_mark_enter(this.value)">
											<div id="error_mark_obtained" class="val__msgbx"></div>
										</div>
										<div class="clear"></div>
									</div>
									<div class="content_form" role="user-name">
										<label style="padding:0;">
										</label>	
										<div class="btn_cal">				
											<input type="submit" name="edit_exam_result" id="create_exam_result" class="submit_button_profile school_color" value="Submit" onclick="return edit_exam_result_validation()">
											<input type="hidden" value="'.$user_details['exam_result_id'].'" name="user_id" id="user_id">
											<input type="reset" name="edit_exam_result" id="create_exam_result" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
										</div>
									</div>									
								</div>
							</div>
						</form>
						';
								
								
				echo $ret_result;
				exit;				
		}
	}

	function get_exam_sub_type_details()
	{
		$result='';
		if(isset($_POST['exam_type_id'])&&$_POST['exam_type_id']!='')
		{	

			$exam_type_id=$_POST['exam_type_id'];
			$exam_sub_type=$this->exam_result_model->get_all_exam_sub_types($exam_type_id);
			

			if(sizeof($exam_sub_type)>0)
			{
				$result.='<option value="">Select Exam Sub Type</option>';
				foreach($exam_sub_type as $exam_sub)
				{
					$result.='<option value="'.$exam_sub['exam_sub_type_id'].'">'.$exam_sub['exam_sub_type_name'].'</option>';
				}				
			}
			else
			{
				$result.='<option value="">No Exam Sub Type</option>';	
			}	
		}
		echo $result;
		exit();
	}
	function get_exam_sub_type_class_details()
	{
		$result='';
		if(isset($_POST['exam_sub_type_id'])&&$_POST['exam_sub_type_id']!='')
		{	
			$exam_sub_type_id=$_POST['exam_sub_type_id'];
			if(($this->session->userdata('user_type')=='admin'))
			{
				$exam_sub_type_class=$this->exam_result_model->get_all_exam_sub_type_class($exam_sub_type_id);
			}
			else if($this->session->userdata('user_type')=='tutor')
			{
				$user_id=$this->session->userdata('user_id');
				$exam_sub_type_class=$this->exam_result_model->get_all_exam_sub_type_class_tutor($exam_sub_type_id,$user_id);
			}
				

			if(sizeof($exam_sub_type_class)>0)
			{
				$result.='<option value="">Select Class</option>';
				foreach($exam_sub_type_class as $exam_class)
				{
					$result.='<option value="'.$exam_class['class_id'].'">'.$exam_class['number'].'</option>';
				}				
			}
			else
			{
				$result.='<option value="">No Class</option>';	
			}	
		}
		echo $result;
		exit();
	}
	function get_exam_sub_type_syllabus_details()
	{
		$result='';
		if(isset($_POST['exam_sub_type_id'])&&$_POST['exam_sub_type_id']!='' && isset($_POST['class_id']) && $_POST['class_id']!='')
		{	

			$exam_sub_type_id=$_POST['exam_sub_type_id'];
			$class_id=$_POST['class_id'];
			if(($this->session->userdata('user_type')=='admin'))
			{
				$exam_sub_type_syllabus=$this->exam_result_model->get_all_exam_sub_type_syllabus($exam_sub_type_id,$class_id);
			}
			else if($this->session->userdata('user_type')=='tutor')
			{
				$user_id=$this->session->userdata('user_id');
				$exam_sub_type_syllabus=$this->exam_result_model->get_all_exam_sub_type_syllabus_tutor($exam_sub_type_id,$class_id,$user_id);
			}
			
			if(sizeof($exam_sub_type_syllabus)>0)
			{
				$result.='<option value="">Select Syllabus</option>';
				foreach($exam_sub_type_syllabus as $exam_syllabus)
				{
					$result.='<option value="'.$exam_syllabus['syllabus_id'].'">'.$exam_syllabus['syllabus_name'].'</option>';
				}				
			}
			else
			{
				$result.='<option value="">No Syllabus</option>';	
			}	
		}
		echo $result;
		exit();
	}
	function get_exam_detail()
	{
		$result='';
		if(isset($_POST['exam_sub_type_id'])&&$_POST['exam_sub_type_id']!=''&& isset($_POST['class_id']) && $_POST['class_id']!=''&& isset($_POST['syllabus_id']) && $_POST['syllabus_id']!='')
		{	
			$syllabus_id=$_POST['syllabus_id'];
			$exam_sub_type_id=$_POST['exam_sub_type_id'];
			$class_id=$_POST['class_id'];
			$select_exam=$this->exam_result_model->get_all_exam_details($exam_sub_type_id,$class_id,$syllabus_id);

			if(sizeof($select_exam)>0)
			{
				$result.='<option value="">Select Exam</option>';
				foreach($select_exam as $exam)
				{
					$result.='<option value="'.$exam['exam_id'].'">'.$exam['exam_name'].'</option>';
				}				
			}
			else
			{
				$result.='<option value="">No Exam</option>';	
			}	
		}
		echo $result;
		exit();
	}

	function get_student_details()
	{
		$result='';
		if(isset($_POST['exam_id'])&&$_POST['exam_id']!='')
		{	

			$exam_id=$_POST['exam_id'];

			$class_id=$this->exam_result_model->get_class_id($exam_id);
			$student_name=$this->exam_result_model->get_all_student($class_id['class_id']);
			

			if(sizeof($student_name)>0)
			{
				$result.='<div class="content_form" role="user-name">
								<label style="padding:0;">
									Student Name		
								</label>
								<div class="input__area">	
								<select class="inputnew arrow2" name="student" id="student">
									<option value="">select</option>';
				foreach($student_name as $student)
				{
					$result.='<option value="'.$student['student_id'].'">'.$student['first_name'].''.$student['last_name'].'</option>';
				}				
			}
				$result.='</select><div id="error_student" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
								<div class="content_form" role="user-name">
									<label style="padding:0;">
										Max Mark 	
									</label>
									<input type="text" class="input adddate "value="'.$student['maximum_mark'].'" name="maximum_mark" id="maximum_mark" readonly>	
								</div>
								<div class="content_form" role="user-name">
									<label style="padding:0;">
										Pass Mark 	
									</label>
									<input type="text" class="input adddate "value="'.$student['pass_mark'].'" name="pass_mark" id="pass_mark" readonly>	
								</div>';	
		}
		echo $result;
		exit();
	}
		function downloadsheet()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='admin')||($this->session->userdata('user_type')=='tutor'))
		{
			$exam_types = $this->exam_result_model->get_all_exam_types();
			$examname = $this->exam_result_model->get_all_exam_name();


			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
												<h2>Download Sheet </h2>
												<div class="close__btn2" onclick="closePopup()"></div>
											</div>
											<div class="loginmsg__box"></div>
											<form action="" name="download_sheet_registration" id="download_sheet_registration" enctype="multipart/form-data" method="post">
												<div class="">
													<div class="form">
														<div class="content_form" role="user-name">
															<label style="padding:0;font-family: font;">
																Exam Type	
															</label>
															<div class="input__area">					
																<select class="inputnew arrow2" name="exam_type" id="exam_type" onchange="get_exam_sub_types(this)">
					                                            	<option value="">Select Exam Type</option>';

					                                            		foreach ($exam_types as $exam_type) 
					                                            		{
					                                            			$ret_result.='<option value="'.$exam_type['exam_type_id'].'">'.$exam_type['exam_type_name'].'</option>';
					                                            		}


															    $ret_result.='</select><div id="error_exam_type" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Exam Sub Type		
															</label>
															<div class="input__area">	
																<select class="inputnew arrow2" name="exam_sub_type" id="exam_sub_type" onchange="get_exam_sub_types_class(this)">
																	<option value="">Select Exam Sub Type</option>
																</select>
																<div id="error_exam_sub_type" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Class		
															</label>
															<div class="input__area">	
																<select class="inputnew arrow2" name="exam_sub_type_class" id="exam_sub_type_class" onchange="get_exam_sub_types_syllabus(this)">
																	<option value="">Select Class</option>
																</select>
																<div id="error_exam_sub_type_class" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Syllabus		
															</label>
															<div class="input__area">	
																<select class="inputnew arrow2" name="exam_sub_type_syllabus" id="exam_sub_type_syllabus" onchange="get_all_exam_details(this)">
																	<option value="">Select Syllabus</option>
																</select>
																<div id="error_exam_sub_type_syllabus" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
																Exam		
															</label>
															<div class="input__area">	
																<select class="inputnew arrow2" name="exam" id="exam">
																	<option value="">Select Exam</option>
																</select>
																<div id="error_exam" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
															</label>	
															<div class="btn_cal">				
																<input type="submit" name="create_dowload_sheet" id="create_dowload_sheet" class="submit_button_profile school_color" value="Submit" onclick="return add_download_sheet_validation()">
																<input type="reset" name="create_dowload_sheet" id="create_dowload_sheet" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
															</div>
														</div>
														
																								
													</div>
												</div>
											</form>
											';
													
									
					echo $ret_result;
					exit;
		}
	}
	function uploadsheet()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='admin')||($this->session->userdata('user_type')=='tutor'))
		{
			 $ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Upload Sheet</h2>
								<div class="close__btn2" onclick="closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="create_upload" id="create_upload" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form ">
										<div class="content_form" role="user-name">
												<label style="padding:0;">
													Uploaded File			
												</label>
												<div class="input__area">					
													<input type="file" value="" class="input " name="file_upload" id="file_upload" placeholder="File Upload">
													<div id="error_file_upload" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
											</label>	
											<div class="btn_cal">				
												<input type="submit" name="create_upload_sheet" id="create_upload_sheet" class="submit_button_profile school_color" value="Submit" onclick="return create_upload_validation()">
												<input type="reset" name="create_upload_sheet" id="create_upload_sheet" class="submit_button_profile cancel_btn_align_school school_color" value="Cancel">
											</div>
										</div>
																			
									</div>
								</div>
							</form>
							';									
									
					echo $ret_result;
					// exit;
		}
	}
	function view_exam_details()
	{
		$ret_result = '';
		$exam_result_id=$_POST['exam_result_id'];
		
		if(($this->session->userdata('user_type')=='parent')||($this->session->userdata('user_type')=='student'))
		{			
			$user_details = $this->exam_result_model->get_exam_details($exam_result_id);
			// echo "<pre>";
			// print_r($user_details);die;

			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
							<h2>View Semester Exam</h2>
							<div class="close__btn2" onclick="closePopup()"></div>
						</div>
						<div class="loginmsg__box"></div>
						<form action="" name="edit_exam_result_registration" id="edit_exam_result_registration" enctype="multipart/form-data" method="post">
							<div class="">
								<div class="form">
									<div class="content_form" role="user-name">
										<label style="padding:0;font-family: font;width:111px;">
											Exam Name	
										</label>
										<div class="input__area">					
											<input type="text" class="exam_view_student"value="'.$user_details['exam_name'].'" name="exam_name" id="exam_name" readonly>	
											<input type="hidden"name="exam_type"  value="'.$user_details['exam_id'].'" id="exam_type">
										</div>
										<div class="clear"></div>
									</div>
									<div id="division_id">
										<div class="content_form" role="user-name">
											<label style="padding:0;width:111px;">
												Student Name		
											</label>
											<div class="input__area">	
												<input type="text" class="exam_view_student" value="'.strtoupper($user_details['first_name']).'	'.strtoupper($user_details['last_name']).'" name="student_name" id="student_name" readonly>	
												<input type="hidden"name="student"  value="'.$user_details['student_id'].'" id="student">
											</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;width:112px;">
												Maximum Mark 	
											</label>
											<input type="text" class="exam_view_student"value="'.$user_details['maximum_mark'].'" name="maximum_mark" id="maximum_mark" readonly>	
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;width:111px;">
												Pass Mark 	
											</label>
											<input type="text" class="exam_view_student"value="'.$user_details['pass_mark'].'" name="pass_mark" id="pass_mark" readonly>	
										</div>
									</div>
									<div class="content_form" role="user-name">
										<label style="padding:0;width:111px;">
											Mark Obtained				
										</label>
										<div class="input__area">					
											<input type="text" value="'.$user_details['mark_obtained'].'"class="exam_view_student" name="mark_obtained" id="mark_obtained" placeholder="Mark Obtained" readonly>
											<div id="error_mark_obtained" class="val__msgbx"></div>
										</div>
										<div class="clear"></div>
									</div>									
								</div>
							</div>
						</form>
						';
								
								
				echo $ret_result;
				exit;				
		}
	}
}
?>