<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Cal extends Controller {

	function Cal()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
		$this->load->model('cal_model');
	}
	
	function index()
	{
		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');

		$show_data['getmonth']='';
		$show_data['getyear']='';
		if(isset($_GET['month'])||(isset($_GET['year'])))
		{
			$show_data['getmonth']=$_GET['month'];
			$show_data['getyear']=$_GET['year'];
		}
		
		if(isset($_POST['create_event']))
		{
			$this->load->library('form_validation');			
			$config = array(
               array(
                     'field'   => 'event_date', 
                     'label'   => 'Event Date', 
                     'rules'   => 'required'
                  ),
                array(
                     'field'   => 'event_time', 
                     'label'   => 'Event Time'
                  ),
               array(
                     'field'   => 'title', 
                     'label'   => 'Title', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'description', 
                     'label'   => 'Description', 
                     'rules'   => 'required'
                  )  
				);

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				
				$event_info = array();				

				$var_date = $this->input->post('event_date');
				$event_date = date("Y-m-d", strtotime($var_date) );
				
				if($event_date < date("Y-m-d"))
				{
					$show_data['error']="Can't add an event before ".date("Y-m-d");
				}

				else
				{
					$event_info['school_id'] = $this->session->userdata('school_id');
					$event_info['event_date'] = $event_date;
					$event_times = $this->input->post('event_time');
					$event_timing = $this->input->post('event_timing');
					$event_info['event_time'] = $event_times.' '.$event_timing;

					$event_info['title'] = $this->input->post('title');
					$event_info['description'] = $this->input->post('description');

					if(isset($_FILES['event_pic'])&&$_FILES['event_pic']['name']!='')
					{
						$uploaddir = 'images/calendar/';
						
						$test = explode('.',$_FILES['event_pic']['name']);
			
						$ext = strtolower($test[sizeof($test)-1]);
						
						if($ext=='png'||$ext=='jpg'||$ext=='jpeg')
						{
							$length = strlen($_FILES['event_pic']['name'])-strlen($ext)-1;
							
							$config['file_name'] = preg_replace('/[^A-Za-z0-9]/', '', substr($_FILES['event_pic']['name'], 0, $length)).strtotime("now").'.jpg';
							
							$file = $uploaddir .$config['file_name']; 
							$file_name= $config['file_name'];
							
							if (move_uploaded_file($_FILES['event_pic']['tmp_name'], $file))
							{				
								$this->makeThumbnails($uploaddir, $file_name);
								$event_info['event_image'] = $file_name;
							}
						}
					}


					$result = $this->cal_model->add_eventdetails($event_info);
					if(sizeof($result)>0)
					{
						$this->success('<p class="success">Event Added Successfully</p>');
						redirect($_SERVER['HTTP_REFERER']);
					}
					else
					{
						$this->success('<p class="error">Event Not Added</p>');
					}
				}
			}
		}
		if(isset($_POST['create_holiday']))
		{

			$this->load->library('form_validation');			
			$config = array(
               array(
                     'field'   => 'holiday_date', 
                     'label'   => 'Holiday Date', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'holiday_title', 
                     'label'   => 'Holiday Title', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'description', 
                     'label'   => 'Description', 
                     'rules'   => 'required'
                  )  
				);

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				
				$holiday_info = array();				

				$var_date = $this->input->post('holiday_date');
				$holiday_date = date("Y-m-d", strtotime($var_date) );
				
				if($holiday_date < date("Y-m-d"))
				{
					$show_data['error']="Can't add an event before ".date("Y-m-d H:i:s");
				}

				else
				{
					$holiday_info['school_id'] = $this->session->userdata('school_id');
					$holiday_info['holiday_date'] = $holiday_date;
					$holiday_info['calendar_year_id'] = $this->input->post('calendar_year_id');
					$holiday_info['holiday_title'] = $this->input->post('holiday_title');
					$holiday_info['description'] = $this->input->post('description');

					
					// $result = $this->cal_model->add_weekend_holiday_($start_date,$end_date);
					$result = $this->cal_model->add_holiday_details($holiday_info);
					$calendar_year=$this->cal_model->get_current_calendar_year();
					
					$start_date=$calendar_year['start_date'];
				    $end_date=$calendar_year['end_date'];
				    $start = strtotime($start_date);
					$end = strtotime($end_date);
					$result = array();
					while ($start <= $end)
					 {
					    if ((date('N', $start) > 5) && (date('N', $start) <= 7))
					    {
					        $current = date('Y/m/d', $start);
					        $result[] = $current;
					    }

					    $start += 86400;

					}
					foreach ($result as $holiday_date) 
					{
						$holiday_info=array();
						$holiday_info['school_id'] = $this->session->userdata('school_id');
						$holiday_info['calendar_year_id'] =$calendar_year['calendar_year_id'];
						$holiday_info['holiday_date'] =$holiday_date;
						$holiday_info['holiday_title'] ='Public Holiday';
						$holiday_info['description'] ='Public Holiday';
						$results = $this->cal_model->add_holiday_details($holiday_info);
					}

					if(sizeof($result)>0)
					{
						$this->success('<p class="success">Holiday Added Successfully</p>');
						redirect($_SERVER['HTTP_REFERER']);
					}
					else
					{
						$this->success('<p class="error">Holiday Not Added</p>');
					}
				}
			}
		}
		if(isset($_POST['edit_event']))
		{

			$this->load->library('form_validation');			
			$config = array(
               array(
                     'field'   => 'event_date', 
                     'label'   => 'Event Date', 
                     'rules'   => 'required'
                  ),
                array(
                     'field'   => 'event_time', 
                     'label'   => 'Event Time'
                  ),
               array(
                     'field'   => 'title', 
                     'label'   => 'Title', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'description', 
                     'label'   => 'Description', 
                     'rules'   => 'required'
                  )  
				);

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				
				$event_info = array();				
				$event_id = $this->input->post('event_id');
				$var_date = $this->input->post('event_date');
				$event_date = date("Y-m-d", strtotime($var_date) );
				
				if($event_date < date("Y-m-d"))
				{
					$show_data['error']="Can't add an event before ".date("Y-m-d");
				}

				else
				{
					$event_info['event_date'] = $event_date;
					$event_times = $this->input->post('event_time');
					$event_timing = $this->input->post('event_timing');
					$event_info['event_time'] = $event_times.' '.$event_timing;

					$event_info['title'] = $this->input->post('title');
					$event_info['description'] = $this->input->post('description');

					if(isset($_FILES['event_pic'])&&$_FILES['event_pic']['name']!='')
					{
						$uploaddir = 'images/calendar/';
						
						$test = explode('.',$_FILES['event_pic']['name']);
			
						$ext = strtolower($test[sizeof($test)-1]);
						
						if($ext=='png'||$ext=='jpg'||$ext=='jpeg')
						{
							$length = strlen($_FILES['event_pic']['name'])-strlen($ext)-1;
							
							$config['file_name'] = preg_replace('/[^A-Za-z0-9]/', '', substr($_FILES['event_pic']['name'], 0, $length)).strtotime("now").'.jpg';
							
							$file = $uploaddir .$config['file_name']; 
							$file_name= $config['file_name'];
							
							if (move_uploaded_file($_FILES['event_pic']['tmp_name'], $file))
							{				
								$this->makeThumbnails($uploaddir, $file_name);
								$event_info['event_image'] = $file_name;
							}
						}
					}


					$result = $this->cal_model->update_event_details($event_info,$event_id);
					if(sizeof($result)>0)
					{
						$this->success('<p class="success">Event Details Successfully Updated</p>');
						redirect($_SERVER['HTTP_REFERER']);
					}
					else
					{
						$this->success('<p class="error">Event Details Not Updated</p>');
					}
				}
			}	
		}
		$show_data['event_date']=$this->cal_model->get_eventdate();
		$show_data['holiday_date']=$this->cal_model->get_holiday_date();
		$this->load->view('cal_view',$show_data);
	}

	private function makeThumbnails($updir, $img)
	{
		$thumbnail_width = 240;
		$thumbnail_height = 240;
		$thumb_beforeword = "thumb/";		
		$arr_image_details = getimagesize("$updir".''."$img"); // pass id to thumb name
		$original_width = $arr_image_details[0];
		$original_height = $arr_image_details[1];
		if ($original_width > $original_height) {
			$new_width = $thumbnail_width;
			$new_height = intval($original_height * $new_width / $original_width);
		} else {
			$new_height = $thumbnail_height;
			$new_width = intval($original_width * $new_height / $original_height);
		}
		$dest_x = intval(($thumbnail_width - $new_width) / 2);
		$dest_y = intval(($thumbnail_height - $new_height) / 2);
		if ($arr_image_details[2] == 1) {
			$imgt = "ImageGIF";
			$imgcreatefrom = "ImageCreateFromGIF";
		}
		if ($arr_image_details[2] == 2) {
			$imgt = "ImageJPEG";
			$imgcreatefrom = "ImageCreateFromJPEG";
		}
		if ($arr_image_details[2] == 3) {
			$imgt = "ImagePNG";
			$imgcreatefrom = "ImageCreateFromPNG";
		}		
		if ($imgt) {
			$old_image = $imgcreatefrom("$updir".''."$img");
			$new_image = imagecreatetruecolor($thumbnail_width, $thumbnail_height);
			ImageCopyResampled($new_image, $old_image, $dest_x, $dest_y, 0, 0, $new_width, $new_height, $original_width, $original_height);
			$imgt($new_image, "$updir" . "$thumb_beforeword" . "$img");
		}
	}

	function event()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin')||($this->session->userdata('user_type')=='tutor')||($this->session->userdata('user_type')=='parent')||($this->session->userdata('user_type')=='student'))
		{

			$current_date=$this->input->post('clickdate');

			$calendar_events=$this->cal_model->get_calendar_events($current_date);			

				if(sizeof($calendar_events)>0)
				{			
					$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
							<div class="event_head">EVENT DETAILS</div>
							<div class="close__btn close__btn4" onclick="closePopup()"></div>
						</div>
						<div class="loginmsg__box"></div>
						<form action="" name="" id="" enctype="multipart/form-data" method="post">
								<div class="form">	

									<div class="eventpopup_content">';
										foreach ($calendar_events as $calendar) 
										{
		
								$ret_result.='<div class="event_title">'.$calendar['title'].'</div>
											<input type="hidden" value="'.$current_date.'" name="current_date" id="current_date">


											<div class="event_date">'.$calendar['event_date'].'</div>
												

											<div class="event_description">'.$calendar['description'].'</div>';

											if($calendar["event_image"]!='')
											{
												$ret_result.='<div class="event_image">
												<img src="'.base_url()."images/calendar/".$calendar["event_image"].'" class="admin_profilepic" style="height:250px; width:420px;"></div>';
											}
											else
											{
												$ret_result.='';
											}
											if(($this->session->userdata('user_type')=='admin'))
											{
												$ret_result.='<div class="edit_homework"><a href="javascript:void(0)" class="edit_homework" onclick="edit_calendar('.$calendar['id'].');">Edit</a></div><br>';
											}	
										$ret_result.='</div><hr class="hrz_line">';
										}								
					$ret_result.='</div>
						</form>
						';		
								
					echo $ret_result;
				}
				// else
				// {
				// 	$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
				// 			<div class="noevent_head">NO EVENT DETAILS</div>
				// 			<div class="close__btn close__btn4" onclick="closePopup()"></div>
				// 		</div>';
				// 		echo $ret_result;
				// }
		}
	}

	function add_event()
	{

		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
		{
			$ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
    						<script src="'. base_url().'js/script_validation.js"></script>
   


				<script>
		        $(document).ready(function(){
		        $("#event_date").datepicker({
		            minDate: 0,
					changeMonth: true,
					changeYear: true,
					showButtonPanel: true,
					dateFormat: "dd-mm-yy",          
		          });
		        });  
		      </script>



			<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Add Event</h2>
								<div class="close__btn3 close__btn4" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="add_calendar_events_validation" id="add_calendar_events_validation" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Event Date				
											</label>
												<div class="input__area">					
													<input type="text" value="" class="input" name="event_date" id="event_date" placeholder="Event Date">
													<div id="error_event_date" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>

										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Event Time				
											</label>
												<div class="drop">			
													<select name="event_time" id="event_time" class="event_time event_time_1">
														<option value="">Select Event Time</option>
														<option value="1">1</option>
														<option value="2">2</option>
														<option value="3">3</option>
														<option value="4">4</option>
														<option value="5">5</option>
														<option value="6">6</option>
														<option value="7">7</option>
														<option value="8">8</option>
														<option value="9">9</option>
														<option value="10">10</option>
														<option value="11">11</option>
														<option value="12">12</option>
													</select>	
													<div class="time_dropdown_arrow"></div>
													<div class="clear"></div>
												</div>

												<div class="drop_1">
													<select name="event_timing" id="event_timing" class="event_time event_time_2"> 
														<option value="AM">AM</option>
														<option value="PM">PM</option>
													</select>
													<div class="time_dropdown_arrow_1"></div>
												</div>
										</div>


										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Title			
											</label>
												<div class="input__area">				
													<input type="text" value="" class="input" name="title" id="title" placeholder="Title">
													<div id="error_title" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>
										
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Description				
											</label>	
												<div class="input__area">				
													<textarea value="" class="input" name="description" id="description" placeholder="Description"></textarea>
													<div id="error_description" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>


										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Event Pic				
											</label>				
												<input type="file" value="" class="event_pic" name="event_pic" id="event_pic">
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												&nbsp;				
											</label>	
												<div class="btn_cal">				
													<input type="submit" name="create_event" id="create_event" class="submit_button4" value="Submit" onclick="return calendar_events()">
													<input type="reset" name="create_event" id="create_event" class="submit_button4 cancel_btn_align" value="Cancel">
												</div>
										</div>										
									</div>
								</div>
							</form>
							';						
					echo $ret_result;
		}
	}
	function add_holiday()
	{

		$ret_result='';
		$calendar_year=$this->cal_model->get_current_calendar_year();
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
		{
			$ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
    						<script src="'. base_url().'js/script_validation.js"></script>
   


				<script>
		        $(document).ready(function(){
		        $("#holiday_date").datepicker({
		            minDate: 0,
					changeMonth: true,
					changeYear: true,
					showButtonPanel: true,
					dateFormat: "dd-mm-yy",          
		          });
		        });  
		      </script>



			<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Add Holiday</h2>
								<div class="close__btn3 close__btn4" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="add_holiday_calendar_events_validation" id="add_holiday_calendar_events_validation" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											Calendar year '.$calendar_year['calendar_year_name'].'
											<input type="hidden" id="calendar_year_id" name="calendar_year_id" value="'.$calendar_year['calendar_year_id'].'">
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Holiday Date				
											</label>
												<div class="input__area">					
													<input type="text" value="" class="input" name="holiday_date" id="holiday_date" placeholder="Holiday Date">
													<div id="error_holiday_date" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Holiday Title			
											</label>
												<div class="input__area">				
													<input type="text" value="" class="input" name="holiday_title" id="holiday_title" placeholder="Holiday Title">
													<div id="error_holiday_title" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>
										
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Description				
											</label>	
												<div class="input__area">				
													<textarea value="" class="input" name="description" id="description" placeholder="Description"></textarea>
													<div id="error_description" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												&nbsp;				
											</label>	
												<div class="btn_cal">				
													<input type="submit" name="create_holiday" id="create_holiday" class="submit_button4" value="Submit" onclick="return holiday_calendar_events()">
													<input type="reset" name="create_holiday" id="create_holiday" class="submit_button4 cancel_btn_align" value="Cancel">
												</div>
										</div>										
									</div>
								</div>
							</form>
							';						
					echo $ret_result;
		}
	}
	function edit_event()
	{
		$event_id = $_POST['id'];
		$selected_event = $this->cal_model->get_current_event_detail($event_id);
		$event_timing = $selected_event['event_time'];
	    $hw_time_split = explode(" ",$event_timing);
	    $hw_time = $hw_time_split[0];
	    $meridiem = $hw_time_split[1];
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='admin'))
		{
			$ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
    						<script src="'. base_url().'js/script_validation.js"></script>
   


				<script>
		        $(document).ready(function(){
		        $("#event_date").datepicker({
		            minDate: 0,
					changeMonth: true,
					changeYear: true,
					showButtonPanel: true,
					dateFormat: "dd-mm-yy",          
		          });
		        });  
		      </script>



			<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Edit Event</h2>
								<div class="close__btn3 close__btn4" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="edit_calendar_events_validation" id="edit_calendar_events_validation" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Event Date				
											</label>
												<div class="input__area">					
													<input type="text" value="'.$selected_event['event_date'].'" class="input" name="event_date" id="event_date" placeholder="Event Date">
													<div id="error_event_date" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>
											<input type="hidden" value="'.$event_id.'" class="input" name="event_id" id="event_id">
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Event Time				
											</label>
											<div class="input__area">
												<div class="drop">			
													<select name="event_time" id="event_time" class="event_time event_time_1">
														<option value="">Select Event Time</option>';
														for($time=1;$time<=12;$time++)
														{
															$selected = $hw_time == $time?'selected':'';
															$ret_result.='<option value="'.$time.'" '.$selected.'>'.$time.'</option>';
														}
													$ret_result.='</select>
														<div class="time_dropdown_arrow"></div>
															
												</div>
												<div id="error_event_time" class="val__msgbx"></div>
											</div>
											
									


												<div class="drop_1">
													<select name="event_timing" id="event_timing" class="event_time event_time_2">';
													if($meridiem=='AM')
													{
														$ret_result.='<option value="AM">AM</option>
																		<option value="PM">PM</option>';
													}
													else if($meridiem=='PM')
													{
														$ret_result.='<option value="PM">PM</option>
																		<option value="AM">AM</option>';
													}
													$ret_result.='</select>
													<div id=" " class="val__msgbx"></div>
													<div class="time_dropdown_arrow"></div>

													<div class="clear"></div>
												</div>
										</div>


										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Title			
											</label>
												<div class="input__area">				
													<input type="text" value="'.$selected_event['title'].'"class="input" name="title" id="title" placeholder="Title">
													<div id="error_title" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>
										
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Description				
											</label>	
												<div class="input__area">				
													<textarea  class="input" name="description" id="description" placeholder="Description">'.$selected_event['description'].'</textarea>
													<div id="error_description" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>


										<div class="content_form" role="user-name">
											<label style="padding:0;">
												Event Pic				
											</label>				
												<input type="file" value="" class="event_pic" name="event_pic" id="event_pic">
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
												&nbsp;				
											</label>	
												<div class="btn_cal">				
													<input type="submit" name="edit_event" id="edit_event" class="submit_button4" value="Submit" onclick="return edit_calendar_events()">
													<input type="reset" name="edit_event" id="edit_event" class="submit_button4 cancel_btn_align" value="Cancel">
												</div>
										</div>										
									</div>
								</div>
							</form>
							';						
					echo $ret_result;
		}
	}
	private function success($message) {
        $userdata = array(
            'success' => $message
        );
        $this->session->set_userdata($userdata);
    }

    private function clearmessage() {
        $userdata = array(
            'success' => ''
        );
        $this->session->set_userdata($userdata);
    }
}
?>