<?php
class Attendanceclass extends controller{

	function Attendanceclass()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
		$this->load->model('attendanceclass_model');
		$this->load->model('homework_model');
		$this->load->model('class_list_model');
		
	}
	
  	function index()
  	{
  		
  		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        // $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');

		/*----------------- pagination starts -----------------------*/

		$this->load->helper('form');
	 	$this->load->helper('url');
	 	$this->load->library('table');
		$this->load->library('pagination');
		

		// Config setup
		$num_rows=$this->db->count_all("SL_day_absence");

	 	$config['base_url'] = base_url().'index.php/attendanceclass';
	 	$config['total_rows'] = $num_rows;
	 	$config['per_page'] = 9;
	 	$config['num_links'] = $num_rows;
	 	$config['use_page_numbers'] = TRUE;
	 	$this->pagination->initialize($config);

		$total_pages = ceil($num_rows / $config['per_page']); 

			if (isset($_GET["page"])) { $page  = $_GET["page"]; } else { $page=1; };

			$start_from = ($page-1) * $config['per_page'];
			$end_to = $config['per_page']; 

			$show_data['total_pages'] = $total_pages;
			//$show_data['attendance_class_details'] = $this->attendanceclass_model->fetch_data($start_from,$end_to);
			//print_r($show_data['teachers_data']);die;

		/*------------------------- end ---------------------------*/


		if(isset($_POST['create_attendance']))
		{
			$this->load->library('form_validation');			
			$config = array(
               array(
                     'field'   => 'class', 
                     'label'   => 'Class', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'division', 
                     'label'   => 'Division', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'student', 
                     'label'   => 'Student', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'attendance_date', 
                     'label'   => 'Attendance Date', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'status_reason', 
                     'label'   => 'Reason',
                  ),
               array(
                     'field'   => 'period_id', 
                     'label'   => 'Period',
                  ),
               array(
                     'field'   => 'period_status_reason', 
                     'label'   => 'Reason',
                  )
				);

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				
				$attendance_info = array();				
				$type= $this->input->post('day_wise');
				$attendance_info['class_id'] = $this->input->post('class');
				$attendance_info['division_id'] = $this->input->post('division');
				$attendance_info['student_id'] = $this->input->post('student');
				$attendance_date = $this->input->post('attendance_date');
				$date = date("Y-m-d", strtotime($attendance_date) );
				$attendance_info['date_of_absence_present'] = $date;
				$attendance_info['day_period_wise'] = $this->input->post('day_wise');
				if($type=='day_wise')
				{
					$attendance_info['absent_present_status'] ='A';
					$attendance_info['reason'] = $this->input->post('status_reason');
				}
				
				$attendance_info['period_absent_present_status'] = 'A';
				
				$details=$this->input->post('period_id');
				$period_id=explode('_', $details);
				$period = $period_id[0];
				$subject_id = $period_id[1];

				$attendance_info['period_id'] =$period;
				if($subject_id!='')
				{
					$attendance_info['subject_id'] =$subject_id;
				}
				$attendance_info['period_absent_reason'] = $this->input->post('period_status_reason');

				$result = $this->attendanceclass_model->add_attendance_details($attendance_info);
				if(sizeof($result)>0)
				{
					$this->success('<p class="success">Absence Added Successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
				else
				{
					$this->success('<p class="error">Absence Not Added</p>');
				}	
			}
		}
		if(isset($_POST['create_dowload_sheet_period']))
		{
			$this->load->library('form_validation');			
			$config = array(
				array(
                     'field'   => 'class_peroid', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'division_period', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'subject', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'attendance_date', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'attendance_to_date', 
                     'rules'   => 'required'
                  )
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				$this->load->model('attendanceclass_model');
				
				$result_info = array();
				$division= $this->input->post('division_period');
				$subject= $this->input->post('subject');
				$type= $this->input->post('day_wise');
				$from_date= $this->input->post('attendance_date');
				$to_date= $this->input->post('attendance_to_date');
			    $date_from = strtotime($from_date); // Convert date to a UNIX timestamp  
			      
			    // Specify the end date. This date can be any English textual format   
			    $date_to = strtotime($to_date); // Convert date to a UNIX timestamp  
			      
			    // Loop from the start date to end date and output all dates inbetween  
			    for ($date=$date_from; $date<=$date_to; $date+=86400) 
			    {  
			        $selected_date[]=date("d/m", $date);
			    }

				$result= $this->attendanceclass_model->get_student_class_details($division,$subject);
				$student= $this->attendanceclass_model->get_all_student_class_details($division);
				$folder='timesheet/attendance';
				if(sizeof($result)>0)
				{
					$name =$result[0]['division_name'];
					$this->load->helper('amountinwords');

					$this->load->helper(array('timesheet', 'file'));

					$result=Create_Attendance_timesheet($result,$folder,$name,$student,$selected_date,$type);
					if($result==1)
					{

					
						$path=base_url().'timesheet/attendance/'.$name.date('dmY').'.xlsx';
						redirect($path);
						// header ('Content-Type: application/vnd.ms-excel; charset=utf-8');
				  //       header ('Content-Disposition: attachment; filename="'.$name.date('dmY').'.xlsx"'); 
				  //       header("Expires: 0");
				  //       header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
				  //       header("Cache-Control: private",false);
				  //       readfile($path);
						// exit();
					}
				}

			}
		}
		if(isset($_POST['create_dowload_sheet']))
		{
			$this->load->library('form_validation');			
			$config = array(
				array(
                     'field'   => 'class', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'division', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'attendance_date', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'attendance_to_date', 
                     'rules'   => 'required'
                  )
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				$this->load->model('attendanceclass_model');
				
				$result_info = array();
				$division= $this->input->post('division');
				$type= $this->input->post('day_wise');
				$from_date= $this->input->post('attendance_date');
				$to_date= $this->input->post('attendance_to_date');

			    $date_from = strtotime($from_date);    
			    $date_to = strtotime($to_date); 
			    for ($date=$date_from; $date<=$date_to; $date+=86400) 
			    {  
			        $selected_date[]=date("d/m", $date);
			    }
			   
				$result= $this->attendanceclass_model->get_student_class_day_wise_details($division);
				$student= $this->attendanceclass_model->get_all_student_class_details($division);
				$folder='timesheet/attendance';
				if(sizeof($result)>0)
				{
					$name =$result[0]['division_name'];
					$this->load->helper('amountinwords');

					$this->load->helper(array('timesheet', 'file'));

					$result=Create_Attendance_timesheet($result,$folder,$name,$student,$selected_date,$type);
					if($result==1)
					{

					
						$path=base_url().'timesheet/attendance/'.$name.date('dmY').'.xlsx';
						redirect($path);
						// header ('Content-Type: application/vnd.ms-excel; charset=utf-8');
				  //       header ('Content-Disposition: attachment; filename="'.$name.date('dmY').'.xlsx"'); 
				  //       header("Expires: 0");
				  //       header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
				  //       header("Cache-Control: private",false);
				  //       readfile($path);
						// exit();
					}
				}

			}
		}
		if(isset($_POST['create_upload_sheet']))
		{

			$this->load->library('form_validation');			
			$config = array(
				array(
                     'field'   => 'file_upload', 
                     'label'   => 'File Upload' 
                  )
			);
			$this->form_validation->set_rules($config);
			
			$result=$this->messagebulkupload();
				
			
		}

			$condition='';
			$show_data['getmonth']='';
			$show_data['getyear']='';

			$selected = $_GET['month'];
			$selectedyear = $_GET['year'];

			$now = date('Y-m-d');
			$day = date("d",strtotime($now));
			$selected_month = date($selected,strtotime($now));
			$selected_year = date($selectedyear,strtotime($now));
			$month = date("m",strtotime($now));
			$year = date("Y",strtotime($now));

			if(($selected_month!='')||($selected_year!=''))
			{
				if(($selected_month <= $month)&&($selected_year <= $year))
				{
					if(($selected_month == $month)&&($selected_year == $year))
					{
						$first = date('Y-m-d', mktime(0, 0, 0, $selected_month, 1, $selected_year));
						$last = date('Y-m-d', mktime(0, 0, 0, $selected_month, $day, $selected_year));
					}
					else
					{
						$first = date('Y-m-d', mktime(0, 0, 0, $selected_month, 1, $selected_year));
						$last = date('Y-m-t', mktime(0, 0, 0, $selected_month, 1, $selected_year));
					}


					$thisTime = strtotime($first);
					$endTime = strtotime($last);

					while($thisTime <= $endTime)
					{
						$thisDate[] = date('d-m-Y', $thisTime);
						//echo $thisDate."<br>";

						$thisTime = strtotime('+1 day', $thisTime); // increment for loop
					}

					$show_data['selected_date'] = $thisDate;
				}
				else
				{
					$thisDate = array();
					$show_data['error'] = "No data found";
				}

				$show_data['num_of_days'] = sizeof($show_data['selected_date']);
			}


			// if(isset($_GET['month'])||(isset($_GET['year'])))
			// {
			// 	$month = $_GET['month'];
			// 	$year = $_GET['year'];

			// 	$num_of_days = cal_days_in_month(CAL_GREGORIAN, $month, $year);
			// 	$show_data['num_of_days'] = $num_of_days;
			// }

			// echo $this->session->userdata('user_id');die;
			if($this->session->userdata('user_type')=='tutor')
			{
				$division_id = $this->attendanceclass_model->get_tutor_class($this->session->userdata('user_id'));
				// print_r($division_id);die;
				if(sizeof($division_id)>0)
				{
					foreach($division_id as $division_id)
					{
						$division_id = $division_id['class_division_id'];
					}
				}
				else
				{
					$division_id = 0;
				}
				$condition="WHERE da.division_id=".$division_id;
				$show_data['attendance_class_details'] = $this->attendanceclass_model->get_all_attendance_details($condition,$start_from,$end_to);
					
				if(isset($_GET['month'])||(isset($_GET['year'])))
				{
					$condition='';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

					$condition = " da.division_id=".$division_id." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
					$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);
				}
				if(isset($_GET['divisionid'])||isset($_GET['classid']))
				{
					$condition = '';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

		          	// $class=$_GET['classid'];
		          	// $division=$_GET['divisionid'];

				  	if(($_GET['classid'])=='')
					{
				 		redirect(base_url().'index.php/attendanceclass?page=1&month='.date('m').'&year='.date('Y').'&classid=1');		
					}

					else
					{
						$i=$_GET['classid'];
						$condition = "da.class_id=".$i." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);
					}

					if((($_GET['classid'])!='')&&isset($_GET['divisionid'])&&($_GET['divisionid'])!='')
					{
						$classid=$_GET['classid'];
						$divisionid=$_GET['divisionid'];
						$condition = "da.class_id=".$classid." AND da.division_id=".$divisionid." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);

					}
				}
			}
			else if($this->session->userdata('user_type')=='student')
			{
				$division_id = $this->homework_model->get_student_class($this->session->userdata('user_id'));
				// echo "<pre>";
				// print_r($division_id);die;
				if(sizeof($division_id)>0)
				{
					foreach($division_id as $division_id)
					{
						$division_id = $division_id;
					}
				}
				else
				{
					$division_id = 0;
				}
				$condition="WHERE da.division_id=".$division_id;
				$show_data['attendance_class_details'] = $this->attendanceclass_model->get_all_attendance_details($condition,$start_from,$end_to);
				
				if(isset($_GET['month'])||(isset($_GET['year'])))
				{
					$condition='';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

					$condition = " da.division_id=".$division_id." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
					$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);
				}
				if(isset($_GET['divisionid'])||isset($_GET['classid']))
				{
					$condition = '';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

		          	// $class=$_GET['classid'];
		          	// $division=$_GET['divisionid'];

				  	if(($_GET['classid'])=='')
					{
				 		redirect(base_url().'index.php/attendanceclass?page=1&month='.date('m').'&year='.date('Y').'&classid=1');		
					}

					else
					{
						$i=$_GET['classid'];
						$condition = "AND da.class_id=".$i." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);
					}

					if(($_GET['classid']!='')&&isset($_GET['divisionid'])&&($_GET['divisionid'])!='')
					{
						$classid=$_GET['classid'];
						$divisionid=$_GET['divisionid'];
						$condition = "da.division_id=".$division_id." AND da.class_id=".$classid." AND da.division_id=".$divisionid." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);

					}
				}
			}
			else if($this->session->userdata('user_type')=='parent')
			{
				$division_id = $this->homework_model->get_parentstudent_class($this->session->userdata('user_id'));
				if(sizeof($division_id)>0)
				{
					foreach($division_id as $division_id)
					{
						$division_id = $division_id;
					}
				}
				else
				{
					$division_id =0;
				}
				$condition="WHERE da.division_id=".$division_id;
				$show_data['attendance_class_details'] = $this->attendanceclass_model->get_all_attendance_details($condition,$start_from,$end_to);
				if(isset($_GET['month'])||(isset($_GET['year'])))
				{
					$condition='';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

					$condition = " da.division_id=".$division_id." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
					$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);
				}
				if(isset($_GET['divisionid'])||isset($_GET['classid']))
				{
					$condition = '';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

		          	// $class=$_GET['classid'];
		          	// $division=$_GET['divisionid'];

				  	if(($_GET['classid'])=='')
					{
				 		redirect(base_url().'index.php/attendanceclass?page=1&month='.date('m').'&year='.date('Y').'&classid=1');		
					}

					else
					{
						$i=$_GET['classid'];
						$condition = "da.class_id=".$i." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);
					}

					if((($_GET['classid'])!='')&&isset($_GET['divisionid'])&&($_GET['divisionid'])!='')
					{
						$classid=$_GET['classid'];
						$divisionid=$_GET['divisionid'];
						$condition = "da.division_id=".$division_id." AND da.class_id=".$classid." AND da.division_id=".$divisionid." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);

					}
				}
			}
			else if($this->session->userdata('user_type')=='admin')
			{
				$condition="";
				$show_data['attendance_class_details'] = $this->attendanceclass_model->get_all_attendance_details($condition,$start_from,$end_to);
				if(isset($_GET['month'])||(isset($_GET['year']))&&(isset($_GET['classid'])||(isset($_GET['divisionid']))))
				{
					$condition='';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

					$condition = " da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
					$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);
	
				}
				if(isset($_GET['divisionid'])||isset($_GET['classid']))
				{
					$condition = '';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

		          	// $class=$_GET['classid'];
		          	// $division=$_GET['divisionid'];

				  	if(($_GET['classid'])=='')
					{
				 		redirect(base_url().'index.php/attendanceclass?page=1&month='.date('m').'&year='.date('Y'));	
					}

					else
					{
						$i=$_GET['classid'];
						$condition = "da.class_id=".$i." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);
					}

					if((($_GET['classid'])!='')&&isset($_GET['divisionid'])&&($_GET['divisionid'])!='')
					{
						$classid=$_GET['classid'];
						$divisionid=$_GET['divisionid'];
						$condition = "da.class_id=".$classid." AND da.division_id=".$divisionid." AND da.date_of_absence_present LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendanceclass_model->get_student_details_class_list($condition,$start_from,$end_to);

					}
				}
			}


			if(isset($_GET['studentid']))
			{
				$studentid_class = $_GET['studentid'];
				$show_data['attendance_class_details'] = $this->attendanceclass_model->get_attendance_details($studentid_class);
			}


		if(isset($_GET['classid']))
		{
            $show_data['getmonth']=$_GET['month'];
			$show_data['getyear']=$_GET['year'];

			if(($_GET['classid'])=='')
			{
		 		redirect(base_url().'index.php/attendanceclass?page=1&month='.date('m').'&year='.date('Y').'&classid=1');		
			}
			else
			{
				$i=$_GET['classid'];
				$condition='';
				if($this->session->userdata('user_type')=='tutor')
				{
					$userid=$this->session->userdata('user_id');
					$condition = "class_id=".$i." AND sct.tutor_id=".$userid;
					$show_data['division_data']=$this->attendanceclass_model->get_all_division($condition);
					$show_data['classid']=$i;
				}
				else if($this->session->userdata('user_type')=='parent')
				{
					$userid=$this->session->userdata('user_id');
					$condition = "cd.class_id=".$i." AND s.parent_id=".$userid;
					$show_data['division_data']=$this->attendanceclass_model->get_parentstudent_class($condition);
					$show_data['classid']=$i;
				}
				else if($this->session->userdata('user_type')=='admin')
				{
					$condition = "class_id=".$i;
					$show_data['division_data']=$this->attendanceclass_model->get_all_division($condition);
					$show_data['classid']=$i;
				}
			}
		}

			$condition='';
			// echo $this->session->userdata('user_id');die;
			if($this->session->userdata('user_type')=='tutor')
			{
				$condition="WHERE sct.tutor_id=".$this->session->userdata('user_id');
				$all_class = $this->attendanceclass_model->get_class($condition);
				$show_data['all_class'] = $all_class;
				$show_data['login_user_id'] = $this->session->userdata('user_id');
			}
			else if($this->session->userdata('user_type')=='student')
			{
				$division_id = $this->homework_model->get_student_class($this->session->userdata('user_id'));
				if(sizeof($division_id)>0)
				{
					foreach($division_id as $division_id)
					{
						$division_id = $division_id;
					}
				}
				else
				{
					$division_id = 0;
				}
				$condition="WHERE cd.id=".$division_id;
				$all_class = $this->attendanceclass_model->get_class($condition);
				$show_data['all_class'] = $all_class;
				$show_data['login_user_id'] = $this->session->userdata('user_id');
			}
			else if($this->session->userdata('user_type')=='parent')
			{
				$division_id = $this->homework_model->get_parentstudent_class($this->session->userdata('user_id'));
				if(sizeof($division_id)>0)
				{
					foreach($division_id as $division_id)
					{
						$division_id = $division_id;
					}
				}
				else
				{
					$division_id = 0;
				}
				$condition="WHERE cd.id=".$division_id;
				$all_class = $this->attendanceclass_model->get_class($condition);
				$show_data['all_class'] = $all_class;
				$show_data['login_user_id'] = $this->session->userdata('user_id');
			}
			else if($this->session->userdata('user_type')=='admin')
			{
				$condition="";
				$show_data['all_class'] = $this->attendanceclass_model->get_all_class($condition);
				$show_data['login_user_id'] = '';
			}

		//$show_data['all_class'] = $this->attendanceclass_model->get_class();
		$this->load->view('attendance_class_view',$show_data);

	}
	function messagebulkupload()
	{
		$uploaddir = 'timesheet/attendance_upload/'; 
		
		$file = $uploaddir .$_FILES['file_upload']['name']; 
		$file_name= $_FILES['file_upload']['name'];
	
		if (move_uploaded_file($_FILES['file_upload']['tmp_name'], $file))
		{ 
		
			$this->load->helper(array('timesheet', 'file'));
			$upload_array=read_sheet_attendance($file);
							
			$class_id=$upload_array['class_id'] ;
			$division_id=$upload_array['division_id'];	
			$subject_id=$upload_array['subject_id'];
			$upload_info=array();
			if($subject_id!='')
			{
				foreach ($upload_array['data'] as $student) 
				{
					
					
					foreach ($student['absent_date'] as $absent)
					{
						$data=array();

						$tempDate =date('d/m',strtotime($absent));
						$DateObj2 = new DateTime($absent);
						$absent_date = date("Y-m-d",strtotime($tempDate));
						$absent_day=date('w', strtotime( $tempDate));
						$condition="WHERE tt.class_division_id=".$division_id." AND tt.subject_child_id=".$subject_id." AND tt.day_of_week=".$absent_day." AND st.student_id=".$student['student_id'];
						$all_details = $this->attendanceclass_model->get_attendance_details_student($condition);
						if(sizeof($all_details)>0)
						{
							foreach ($all_details as $absent_period)
							{
			
							
								$data=array(
									'class_id'			=>$class_id,
									'division_id'		=>$division_id,
									'subject_id'		=>$subject_id,
									'student_id'		=>$student['student_id'],
									'date_of_absence_present'=>$absent_date,
									'day_period_wise'	=>'period_wise',
									'period_id'			=>$absent_period['period_id'],
									'period_absent_present_status'=>'A'
									);
								$result =$this->attendanceclass_model->add_attendance_details($data);

							}
						
						}

					}
				}
			}
			else
			{
			
				foreach ($upload_array['data'] as $student) 
				{
					
					
					foreach ($student['absent_date'] as $absent)
					{
						$data=array();

						$tempDate =date('d/m',strtotime($absent));
						$DateObj2 = new DateTime($absent);
						$absent_date = date("Y-m-d",strtotime($tempDate));
						$absent_day=date('w', strtotime( $tempDate));
						$condition="WHERE tt.class_division_id=".$division_id." AND tt.day_of_week=".$absent_day." AND st.student_id=".$student['student_id'];
						$all_details = $this->attendanceclass_model->get_attendance_day_wise_details_student($condition);
						
						if(sizeof($all_details)>0)
						{
							$data=array(
									'class_id'			=>$class_id,
									'division_id'		=>$division_id,
									'student_id'		=>$student['student_id'],
									'date_of_absence_present'=>$absent_date,
									'day_period_wise'	=>'day_wise',
									'absent_present_status'=>'A'
									);
								$result =$this->attendanceclass_model->add_attendance_details($data);

							}

					}
				}
				// echo "<pre>";
				// print_r($data);die;

			}
			if($result>0)
			{
				$this->success('<p class="success">File Upload have been updated successfully</p>');
				redirect($_SERVER['HTTP_REFERER']);
			}
				
						
		}
	}

	function add_attendance()
	{
		$ret_result='';
		$this->load->model('addclass_model');
		$this->load->model('adddivision_model');
		

		$select_class = $this->attendanceclass_model->get_tutor_all_class($this->session->userdata('user_id'));
		$division = $this->adddivision_model->get_division_details1();
		$day_of_week = $this->attendanceclass_model->get_day_of_week();

		$select_period = $this->attendanceclass_model->get_all_period();
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='tutor'))
		{
			$ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
    						<script src="'. base_url().'js/script_validation.js"></script>
   


				<script>
		        $(document).ready(function(){
		        $("#attendance_date").datepicker({
		            maxDate: 0,
					changeMonth: true,
					changeYear: true,
					showButtonPanel: true,
					dateFormat: "dd-mm-yy",
					yearRange:"2015:", 

		            onSelect: function(dateText, inst) {

			            var dateToday = new Date();
						var todayDate = dateToday.toLocaleDateString("en-GB");
						var todayDateNumber = dateToday.getDate();

							var weekday = new Array(7);
							weekday[0]=  "Sunday";
							weekday[1] = "Monday";
							weekday[2] = "Tuesday";
							weekday[3] = "Wednesday";
							weekday[4] = "Thursday";
							weekday[5] = "Friday";
							weekday[6] = "Saturday";

							var dateSelect = $(this).datepicker("getDate");	       
							var todaysDay = weekday[dateToday.getDay()];
			    			var dayOfWeek = $.datepicker.formatDate("DD", dateSelect);
			    		    var division_id = document.getElementById("division").value;


			    		  var pathstring = String(window.location);
						  var patharray  = pathstring.split("/");   
						  var path=patharray[0]+"//"+patharray[2]+"/"+patharray[3];
						  var url = path+"/index.php/attendanceclass/get_period_select";

						  $.post(url,{dayOfWeek:dayOfWeek,division_id:division_id},function(data) {

						  	    if(data!="")
							    {

							        $("#period_id").html(data);

							    }
							    
						  });
			        	}
		        	});          
		        });
					
		      </script>

		      

		      <div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Add Attendance</h2>
								<div class="close__btn3 close__btn4" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="add_attendance_validation" id="add_attendance_validation" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
			
										<div class="field" role="user-name">
											<label style="padding:0;">
												Class				
											</label>
												<div class="input__area">				
													<select class="input arrow" name="class" id="class" onchange="get_division_attendance(this,'.$div="'D'".')">
		                                            	<option value="">Select Class</option>';

		                                            		foreach ($select_class as $class) 
		                                            		{
		                                            			$ret_result.='<option value="'.$class['id'].'">'.$class['number'].'</option>';
		                                            		}
												    $ret_result.='</select>
												   <div id="error_class" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>

										<div class="field" role="user-name">
											<label style="padding:0;">
												Division			
											</label>
											<div class="input__area">	
												<select class="input arrow" name="division" id="division" onchange="get_student_attendance(this)">
													<option value="">Select Division</option>
												</select>
													<div id="error_division" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="field" role="user-name">
											<label style="padding:0;">
												Student			
											</label>
											<div class="input__area">	
												<select class="input arrow" name="student" id="student">
													<option value="">Select Student</option>
												</select>
													<div id="error_student" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="field" role="user-name">
											<label style="padding:0;">
												Absent Date				
											</label>
												<div class="input__area">					
													<input type="text" value="" class="input" name="attendance_date" id="attendance_date" placeholder="Attendance Date">
													<p id="datepicker-date-selected"></p>
													<p id="datepicker-day-of-week"></p>
													<div id="error_attendance_date" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>
										<div class="field" role="user-name">
											<label style="padding:0;">
												&nbsp;				
											</label>
											<div class="input__area">
												<input type="radio" value="day_wise" name="day_wise" id="day_wise" onclick="get_day_wise(this,'."'A'".')" checked> Day Wise
												<input type="radio" value="period_wise" name="day_wise" id="period_wise" onclick="get_day_wise(this,'."'A'".')"> Period Wise
												<div id="error_day_wise" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										
										<div id="day_wise_select">
											

												<div id="reason_status" >
													<div class="field" role="user-name">
														<label style="padding:0;">
															Reason
														</label>
														<div class="input__area">
															<textarea class="input" name="status_reason" id="status_reason"></textarea>
															<div id="" class="val__msgbx"></div>
														</div>
														<div class="clear"></div>
													</div>
												</div>
											</div>

											<div id="period_wise_select" style="display:none;">

												<div id="period_reason_status" style="display:none;">

													<div class="field" role="user-name">
														<label style="padding:0;">
															Period
														</label>
														<div class="input__area">
															<select name="period_id" id="period_id" class="input arrow" onchange="get_time_table_subject(this)">
																<option value="">Select Period</option>

																</select>
															<div id="error_period_id" class="val__msgbx"></div>
														</div>
														<div class="clear"></div>
													</div>

													<div class="field" role="user-name">
														<label style="padding:0;">
															Reason
														</label>
														<div class="input__area">
															<textarea class="input" name="period_status_reason" id="period_status_reason"></textarea>
															<div id="" class="val__msgbx"></div>
														</div>
														<div class="clear"></div>
													</div>

												</div>
											</div>



										<div class="field" role="user-name">
											<label style="padding:0;">
												&nbsp;				
											</label>	
												<div class="btn_cal">
													<input type="submit" name="create_attendance" id="create_attendance_period" class="submit_button4 submit_button4_attendance" value="Submit" onclick="return attendance_period_validation()" style="display:none;">				
													<input type="submit" name="create_attendance" id="create_attendance" class="submit_button4 submit_button4_attendance" value="Submit" onclick="return attendance_validation()">
													<input type="reset" name="create_attendance" id="create_attendance" class="submit_button4 cancel_btn_align submit_button4_attendance" value="Cancel">
												</div>
										</div>										
									</div>
								</div>
							</form>
							';						
					echo $ret_result;
		}
	}

	function get_division()
	{
		$result='<option value="">Select Division</option>';
		if(isset($_POST['class_id'])&&$_POST['class_id']!='')
		{

			$class_id=$_POST['class_id'];
		
			$this->load->model('assigntutor_model');
			$this->load->model('attendanceclass_model');
	
			$division_name=$this->assigntutor_model->get_all_division($class_id);
	
			if(sizeof($division_name)>0)
			{
				foreach($division_name as $division)
				{
					$result.='<option value="'.$division['id'].'">'.$division['name'].'</option>';
				}			
			}
		}
		echo $result;
		exit();
	}

	function get_student_name()
	{
		$result='<option value="">Select Student</option>';
		if((isset($_POST['class_id'])&&$_POST['class_id']!='')&&(isset($_POST['division_id'])&&$_POST['division_id']!=''))
		{	

			$class_id=$_POST['class_id'];
			$division_id=$_POST['division_id'];

			$student_name=$this->attendanceclass_model->get_all_student($class_id,$division_id);	
	
			if(sizeof($student_name)>0)
			{
				foreach($student_name as $name)
				{
					$result.='<option value="'.$name['student_id'].'">'.$name['first_name'].' '.$name['last_name'].'</option>  ';
				}			
			}
		}
		echo $result;
		exit();
	}
	function get_period_select()
	{
		$day_of_week=$_POST['dayOfWeek'];
		$division_id=$_POST['division_id'];
		$result='<option value="">Select Period</option>';
		if((isset($_POST['division_id'])&&$_POST['division_id']!='') && (isset($_POST['dayOfWeek'])&&$_POST['dayOfWeek']!=''))
		{	
			
			$day_id=$this->attendanceclass_model->get_current_day($day_of_week);
			$period_name=$this->attendanceclass_model->get_all_period_Select($division_id,$day_id['id']);	

			if(sizeof($period_name)>0)
			{
				foreach($period_name as $period)
				{
					$result.='<option value="'.$period['period_id'].'_'.$period['subject_id'].'">'.$period['period'].'-'.$period['name'].'</option>  ';
				}		
			}
		}
		echo $result;
		exit();
	}
	 private function success($message) {
        $userdata = array(
            'success' => $message
        );
        $this->session->set_userdata($userdata);
    }

    private function clearmessage() {
        $userdata = array(
            'success' => ''
        );
        $this->session->set_userdata($userdata);
    }
    function download_sheet()
	{
		$ret_result='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='tutor'))
		{
			$this->load->model('adddivision_model');
			$select_class = $this->attendanceclass_model->get_tutor_all_class($this->session->userdata('user_id'));
			$division = $this->adddivision_model->get_division_details1();

			$ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
    						<script src="'. base_url().'js/script_validation.js"></script>
   


				<script>
			        $(document).ready(function(){
				        $("#attendance_date").datepicker({
				            maxDate: 0,
							changeMonth: true,
							changeYear: true,
							showButtonPanel: true,
							dateFormat: "dd-mm-yy",
							yearRange:"2015:",
						});
							$("#attendance_to_date").datepicker({
				            maxDate: 0,
							changeMonth: true,
							changeYear: true,
							showButtonPanel: true,
							dateFormat: "dd-mm-yy",
							yearRange:"2015:",
						});

					});
				</script>';


			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
												<h2>Download Sheet </h2>
												<div class="close__btn2" onclick="period_closePopup()"></div>
											</div>
											<div class="loginmsg__box"></div>
											<form action="" name="attendance_download_sheet_registration" id="attendance_download_sheet_registration" enctype="multipart/form-data" method="post">
												<div class="">
													<div class="form">
												<div class="field" role="user-name">
													<label style="padding:0;">
														&nbsp;				
													</label>
													<div class="input__area">
														<input type="radio" value="day_wise" name="day_wise" id="day_wise" onclick="get_day_wise_attendance(this)" checked > Day Wise
														<input type="radio" value="period_wise" name="day_wise" id="period_wise" onclick="get_day_wise_attendance(this)" > Period Wise
														<div id=" " class="val__msgbx"></div>
													</div>
													<div class="clear"></div>
												</div>
												<div id="day_wise_selected">
													<div class="field" role="user-name">
														<label style="padding:0;">
															Class				
														</label>
															<div class="input__area">				
																<select class="input arrow" name="class" id="class" onchange="get_division_attendance(this,'.$div="'D'".');check_attendace_class_list_student(this.value,'.$div="'D'".')">
					                                            	<option value="">Select Class</option>';

					                                            		foreach ($select_class as $class) 
					                                            		{
					                                            			$ret_result.='<option value="'.$class['id'].'">'.$class['number'].'</option>';
					                                            		}
															    $ret_result.='</select>
															   <div id="error_class" class="val__msgbx"></div>
															</div>
														<div class="clear"></div>
													</div>

													<div class="field" role="user-name">
														<label style="padding:0;">
															Division			
														</label>
														<div class="input__area">	

															<select class="input arrow" name="division" id="division" onchange="check_attendace_class_division_student(this,'.$div="'D'".')">
																<option value="">Select Division</option>
															</select>
																<div id="error_division" class="val__msgbx"></div>
														</div>
														<div class="clear"></div>
													</div>
													
												</div>
												<div id="period_wise_selected" style="display:none;">
													<div class="field" role="user-name">
														<label style="padding:0;">
															Class				
														</label>
															<div class="input__area">				
																<select class="input arrow" name="class_peroid" id="class_peroid" onchange="get_division_attendance(this,'.$div="'P'".');check_attendace_class_list_student(this.value,'.$div="'P'".')">
					                                            	<option value="">Select Class</option>';

					                                            		foreach ($select_class as $class) 
					                                            		{
					                                            			$ret_result.='<option value="'.$class['id'].'">'.$class['number'].'</option>';
					                                            		}
															    $ret_result.='</select>
															   <div id="error_class_peroid" class="val__msgbx"></div>
															</div>
														<div class="clear"></div>
													</div>

													<div class="field" role="user-name">
														<label style="padding:0;">
															Division			
														</label>
														<div class="input__area">	
															<select class="input arrow" name="division_period" id="division_period" onchange="check_attendace_class_division_student(this,'.$div="'P'".');get_class_division_subject_attendance(this)">
																<option value="">Select Division</option>
															</select>
																<div id="error_division_period" class="val__msgbx"></div>
														</div>
														<div class="clear"></div>
													</div>
													<div class="content_form" role="user-name">
														<label style="padding:0;">
															Subject				
														</label>
														<div class="input__area">
															<select class="input arrow" name="subject" id="subject">
					                                            	<option value="">Select Subject</option>
					                                        </select>
														 <div id="error_subject" class="val__msgbx"></div>
														</div>
														<div class="clear"></div>
													</div>
												</div>
												<div class="field" role="user-name">
													<label style="padding:0;">
														From Date				
													</label>
														<div class="input__area">					
															<input type="text" value="" class="input" name="attendance_date" id="attendance_date" placeholder="Attendance From Date">
															<p id="datepicker-date-selected"></p>
															<p id="datepicker-day-of-week"></p>
															<div id="error_attendance_date" class="val__msgbx"></div>
														</div>
													<div class="clear"></div>
												</div>
												<div class="field" role="user-name">
													<label style="padding:0;">
														To Date				
													</label>
														<div class="input__area">					
															<input type="text" value="" class="input" name="attendance_to_date" id="attendance_to_date" placeholder="Attendance To Date">
															<p id="datepicker-date-selected"></p>
															<p id="datepicker-day-of-week"></p>
															<div id="error_attendance_to_date" class="val__msgbx"></div>
														</div>
													<div class="clear"></div>
												</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
															</label>	
															<div class="btn_cal">				
																<input type="submit" name="create_dowload_sheet" id="create_dowload_sheet" class="submit_button4 submit_button4_attendance" value="Submit" onclick="return attendance_download_sheet_validation()">
																<input type="submit" name="create_dowload_sheet_period" id="create_dowload_sheet_period" class="submit_button4 submit_button4_attendance" value="Submit" onclick="return attendance_period_wise_download_sheet_validation()" style="display:none;">	
																<input type="reset" name="cancel_dowload_sheet" id="cancel_dowload_sheet" class="submit_button4 cancel_btn_align submit_button4_attendance" value="Cancel">
															</div>
														</div>
														
																								
													</div>
												</div>
											</form>
											';
													
									
					echo $ret_result;
					exit;
		}
	}
	function check_class_list_students() 
	{
        if (isset($_POST['class_id'])) 
        {
            $class_id = $_POST['class_id'];
            $user_name=$this->session->userdata('user_code');
            $condition = "where class_id='".$class_id."'";
            $this->load->model('class_list_model');
            $user_details = $this->class_list_model->check_class_list_student($condition);
            // print_r($user_details);die;
            if ($user_details['student_count']!=0) {
                echo 1;
            } else {
                echo 0;
            }
        }
    }
	function check_class_list_division_student() 
	{
        if (isset($_POST['division_id'])) 
        {
            $division_id = $_POST['division_id'];
            $user_name=$this->session->userdata('user_code');
            $condition = "where cd.id='".$division_id."'";
            $this->load->model('class_list_model');
            $user_details = $this->class_list_model->check_class_list_student($condition);
            if ($user_details['student_count']!=0) {
                echo 1;
            } else {
                echo 0;
            }
        }
    }
    function get_division_subject()
	{
		$result='';
		if(isset($_POST['division_id'])&&$_POST['division_id']!='')
		{	

			$division_id=$_POST['division_id'];
			$this->load->model('homework_model');
			$subject_name=$this->homework_model->get_all_division_subject($division_id,$this->session->userdata('user_id'));
			if(sizeof($subject_name)>0)
			{
				$result.='<option value="">Select Subject</option>';
				foreach($subject_name as $subject)
				{

					$result.='<option value="'.$subject['id'].'">'.$subject['name'].'</option>';
					}				
			}
				
		}
		echo $result;
		exit();
	}
	function uploadsheet()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='tutor'))
		{
			 $ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Upload Sheet</h2>
								<div class="close__btn2" onclick="closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="create_attendance_upload" id="create_attendance_upload" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form ">
										<div class="content_form" role="user-name">
												<label style="padding:0;">
													Uploaded File			
												</label>
												<div class="input__area">					
													<input type="file" value="" class="input " name="file_upload" id="file_upload" placeholder="File Upload">
													<div id="error_file_upload" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
											</label>	
											<div class="btn_cal">				
												<input type="submit" name="create_upload_sheet" id="create_upload_sheet" class="submit_button4 submit_button4_attendance" value="Submit" onclick="return create_attendance_upload_validation()">
												<input type="reset" name="create_upload_sheet" id="create_upload_sheet" class="submit_button4 cancel_btn_align submit_button4_attendance" value="Cancel">
											</div>
										</div>
																			
									</div>
								</div>
							</form>
							';									
									
					echo $ret_result;
					// exit;
		}
	
	}	
}
?>