<?php
class Attendance extends controller{

	function Attendance()
	{
		parent::Controller();
		if($this->session->userdata('user_logged')!="yes:schooluser")
		{
			redirect(base_url().'index.php/login');
			exit;
		}
		$this->load->model('attendance_model');
		$this->load->model('homework_model');
		$this->load->model('class_list_model');
		$this->load->model('timetable_model');
		
	}
	
  	function index()
  	{
  		
  		$show_data = array();
        $show_data['error'] = '';
        $show_data['success'] = $this->session->userdata('success');
        // $this->clearmessage();
		$show_data['name']=$this->session->userdata('user_name');
		$show_data['propic']=$this->session->userdata('profile_pic');

		if(isset($_POST['create_attendance']))
		{
			$this->load->library('form_validation');			
			$config = array(
               array(
                     'field'   => 'class', 
                     'label'   => 'Class', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'division', 
                     'label'   => 'Division', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'student', 
                     'label'   => 'Student', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'attendance_date', 
                     'label'   => 'Attendance Date', 
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'status_reason', 
                     'label'   => 'Reason',
                  ),
               array(
                     'field'   => 'period_id', 
                     'label'   => 'Period',
                  ),
               array(
                     'field'   => 'period_status_reason', 
                     'label'   => 'Reason',
                  )
				);

			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				
				$attendance_info = array();				
				$type= $this->input->post('day_wise');
				$attendance_info['class_id'] = $this->input->post('class');
				$attendance_info['division_id'] = $this->input->post('division');
				$attendance_info['student_id'] = $this->input->post('student');
				$attendance_date = $this->input->post('attendance_date');
				$date = date("Y-m-d", strtotime($attendance_date) );
				$attendance_info['date_of_absence_present'] = $date;
				$attendance_info['day_period_wise'] = $this->input->post('day_wise');
				if($type=='day_wise')
				{
					$attendance_info['absent_present_status'] ='A';
					$attendance_info['reason'] = $this->input->post('status_reason');
				}
				
				$attendance_info['period_absent_present_status'] = 'A';
				
				$details=$this->input->post('period_id');
				$period_id=explode('_', $details);
				$period = $period_id[0];
				$subject_id = $period_id[1];

				$attendance_info['period_id'] =$period;
				if($subject_id!='')
				{
					$attendance_info['subject_id'] =$subject_id;
				}
				$attendance_info['period_absent_reason'] = $this->input->post('period_status_reason');

				$result = $this->attendance_model->add_attendance_details($attendance_info);
				if(sizeof($result)>0)
				{
					$this->success('<p class="success">Absence Added Successfully</p>');
					redirect($_SERVER['HTTP_REFERER']);
				}
				else
				{
					$this->success('<p class="error">Absence Not Added</p>');
				}	
			}
		}
		if(isset($_POST['create_dowload_sheet']))
		{
			$this->load->library('form_validation');			
			$config = array(
				array(
                     'field'   => 'class', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'division', 
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'attendance_date', 
                     'rules'   => 'required'
                  )
			);
			$this->form_validation->set_rules($config);
			if($this->form_validation->run() != false)
			{
				$this->load->model('attendance_model');
				
				$result_info = array();
				$division= $this->input->post('division');
				$attendance_date= $this->input->post('attendance_date');
			   	
				$result= $this->attendance_model->get_student_class_day_wise_details($division);
				

				// $student= $this->attendance_model->get_all_student_class_details($division);
				$folder='timesheet/attendance';
				if(sizeof($result)>0)
				{
					$name =$result[0]['division_name'];
					$this->load->helper('amountinwords');

					$this->load->helper(array('timesheet', 'file'));

					$result=Create_Attendance_timesheet($result,$folder,$name,$attendance_date);
					if($result==1)
					{

					
						$path=base_url().'timesheet/attendance/'.$name.date('dmY').'.xlsx';
						redirect($path);
						// header ('Content-Type: application/vnd.ms-excel; charset=utf-8');
				  //       header ('Content-Disposition: attachment; filename="'.$name.date('dmY').'.xlsx"'); 
				  //       header("Expires: 0");
				  //       header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
				  //       header("Cache-Control: private",false);
				  //       readfile($path);
						// exit();
					}
				}

			}
		}
		if(isset($_POST['create_upload_sheet']))
		{

			$this->load->library('form_validation');			
			$config = array(
				array(
                     'field'   => 'file_upload', 
                     'label'   => 'File Upload' 
                  )
			);
			$this->form_validation->set_rules($config);
			
			$result=$this->messagebulkupload();
				
			
		}

			$condition='';
			$show_data['getmonth']='';
			$show_data['getyear']='';
			if(isset($_GET['month'])||(isset($_GET['year'])))
			{
				$condition='';
				$show_data['getmonth']=$_GET['month'];
				$show_data['getyear']=$_GET['year'];

				$month = $_GET['month'];
				$year = $_GET['year'];

				$condition = "(holiday_date LIKE '".$year."-%".$month."-%') AND school_id=".$this->session->userdata('school_id');
				$holiday_count=$this->attendance_model->get_holiday_month_count($condition);

				$no_days_month=cal_days_in_month(CAL_GREGORIAN, $month, $year);
				$no_working_days=$no_days_month-$holiday_count['holiday_count'];
				$condition = " absent_date LIKE '".$year."-%".$month."-%'";
				$absent_count=$this->attendance_model->get_absent_month_count($condition);
				// $show_data['holiday_count']=$holiday_count['holiday_count'];
				$show_data['no_working_days']=$no_working_days;
			}

			$selected = $_GET['month'];
			$selectedyear = $_GET['year'];

			$now = date('Y-m-d');
			$day = date("d",strtotime($now));
			$selected_month = date($selected,strtotime($now));
			$selected_year = date($selectedyear,strtotime($now));
			$month = date("m",strtotime($now));
			$year = date("Y",strtotime($now));

			

			if(($selected_month!='')||($selected_year!=''))
			{
				$month_date=array();
				if(($selected_month <= $month)||($selected_year <= $year))
				{
					if(($selected_month == $month)&&($selected_year == $year))
					{
						$first = date('Y-m-d', mktime(0, 0, 0, $selected_month, 1, $selected_year));
						$last = date('Y-m-d', mktime(0, 0, 0, $selected_month, $day, $selected_year));
					}
					else
					{
						$first = date('Y-m-d', mktime(0, 0, 0, $selected_month, 1, $selected_year));
						$last = date('Y-m-t', mktime(0, 0, 0, $selected_month, 1, $selected_year));
					}


					$thisTime = strtotime($first);
					$endTime = strtotime($last);
					$condition = " (holiday_date LIKE '".$selected_year."-%".$selected_month."-%') AND school_id=".$this->session->userdata('school_id');
					$holiday_date=$this->attendance_model->get_holiday_month($condition);
					while($thisTime <= $endTime)
					{
						$thisDate[] = date('Y-m-d', $thisTime);
						//echo $thisDate."<br>";

						$thisTime = strtotime('+1 day', $thisTime); // increment for loop
					}
					if(sizeof($holiday_date)>0)
					{
						foreach ($holiday_date as $holiday)
						{
							$date_holiday[]=$holiday['holiday_date'];	
						}
						$month_date=array_diff($thisDate,$date_holiday);

						$show_data['selected_date'] = $month_date;
						$show_data['num_of_days'] = sizeof($show_data['selected_date']);
					}
					else
					{
						$show_data['selected_date'] = $thisDate;
					}
				}
				else
				{
					$thisDate = array();
					$show_data['error'] = "No data found";
				}
				if(isset($_GET['divisionid']) && ($_GET['divisionid'])!='')
				{
					foreach ($thisDate as $month_date)
					{
						$condition = "absent_date='".$month_date."' AND class_division_id=".$_GET['divisionid']." AND present_flag=0";
						$show_data['attendance_class_count'][$month_date]=$this->attendance_model->get_student_details_class_list_count($condition);
					}
				}
				
			}

			if($this->session->userdata('user_type')=='tutor')
			{
				$division_id = $this->attendance_model->get_tutor_class($this->session->userdata('user_id'));
				// print_r($division_id);die;
				if(sizeof($division_id)>0)
				{
					foreach($division_id as $division_id)
					{
						$division_id = $division_id['id'];
					}
				}
				else
				{
					$division_id = 0;
				}
				$condition="WHERE da.class_division_id=".$division_id." AND s.school_id=".$this->session->userdata('school_id');
				$show_data['attendance_class_details'] = $this->attendance_model->get_all_attendance_details($condition);
					
				if(isset($_GET['month'])||(isset($_GET['year'])))
				{
					$condition='';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

					$condition = " cd.id=".$division_id." AND c.school_id=".$this->session->userdata('school_id')." AND s.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."' AND da.absent_date LIKE '".$year."-%".$month."-%'";
					$show_data['attendance_class_details']=$this->attendance_model->get_student_details_class_list($condition);
				}
				if(isset($_GET['divisionid'])||isset($_GET['classid']))
				{
					$condition = '';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

		          	// $class=$_GET['classid'];
		          	// $division=$_GET['divisionid'];

				  	if(($_GET['classid'])=='')
					{
				 		redirect(base_url().'index.php/attendance?page=1&month='.date('m').'&year='.date('Y').'&classid=1');		
					}

					else
					{
						$i=$_GET['classid'];
						$condition = "cd.class_id=".$i." AND c.school_id=".$this->session->userdata('school_id')." AND s.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."' AND da.absent_date LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendance_model->get_student_details_class_list($condition);
					}

					if((($_GET['classid'])!='')&&isset($_GET['divisionid'])&&($_GET['divisionid'])!='')
					{
						$classid=$_GET['classid'];
						$divisionid=$_GET['divisionid'];
						$condition = "cd.class_id=".$classid." AND cd.id=".$divisionid." AND s.school_id=".$this->session->userdata('school_id')." AND c.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."' AND da.absent_date LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendance_model->get_student_details_class_list($condition);

					}
				}
			}
			else if($this->session->userdata('user_type')=='student')
			{
				if(isset($_GET['month'])||(isset($_GET['year'])))
				{

					$condition='';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];
					$month = $_GET['month'];
					$year = $_GET['year'];
					$student_id=$this->session->userdata('user_id');
					$show_data['login_user_id'] = $this->session->userdata('user_id');	
					$division=$this->timetable_model->get_student_division($student_id);
					$division_id=$division['class_division_id'];
					$classid=$division['class_id'];

					foreach ($thisDate as $month_date)
					{
						$condition = "absent_date='".$month_date."' AND class_division_id=".$division_id." AND present_flag=0";
						$show_data['attendance_class_count'][$month_date]=$this->attendance_model->get_student_details_class_list_count($condition);
					}

					$condition = "cd.id=".$division_id." AND c.school_id=".$this->session->userdata('school_id')." AND s.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."' AND cd.class_id=".$classid." AND cd.id=".$division_id." AND da.absent_date LIKE '".$year."-%".$month."-%' AND da.student_id=".$student_id;
					$attendance_class_details=$this->attendance_model->get_student_details_class_list($condition);
					// echo "<pre>";
					// print_r($attendance_class_details);die;
					if(($attendance_class_details)>0)
					{
						$show_data['attendance_class_details'] =$attendance_class_details;
					}
				}
			}
			else if($this->session->userdata('user_type')=='parent')
			{
				if(isset($_GET['month'])||(isset($_GET['year']))||(isset($_GET['student_id'])))
				{
					if(isset($_GET['student_id']) && ($_GET['student_id'])!='')
					{

						$condition='';
						$show_data['getmonth']=$_GET['month'];
						$show_data['getyear']=$_GET['year'];
						$month = $_GET['month'];
						$year = $_GET['year'];
						$student_id=$_GET['student_id'];

						$division=$this->timetable_model->get_student_division($student_id);
						$division_id=$division['class_division_id'];
						$classid=$division['class_id'];

						foreach ($thisDate as $month_date)
						{
							$condition = "absent_date='".$month_date."' AND class_division_id=".$division_id." AND present_flag=0";
							$show_data['attendance_class_count'][$month_date]=$this->attendance_model->get_student_details_class_list_count($condition);
						}

						$condition = "cd.id=".$division_id." AND c.school_id=".$this->session->userdata('school_id')." AND s.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."' AND cd.class_id=".$classid." AND cd.id=".$division_id." AND da.absent_date LIKE '".$year."-%".$month."-%' AND da.student_id=".$student_id;
						$attendance_class_details=$this->attendance_model->get_student_details_class_list($condition);
						// echo "<pre>";
						// print_r($attendance_class_details);die;
						if(($attendance_class_details)>0)
						{
							$show_data['attendance_class_details'] =$attendance_class_details;
						}
					}
				}

			}
			else if($this->session->userdata('user_type')=='admin')
			{
				$condition=" ";
				$show_data['attendance_class_details'] = $this->attendance_model->get_all_attendance_details($condition);
				if(isset($_GET['month'])||(isset($_GET['year']))&&(isset($_GET['classid'])||(isset($_GET['divisionid']))))
				{
					$condition='';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

						// $condition = " da.absent_date='".$month_date."'";
						// $show_data['attendance_class_details']=$this->attendance_model->get_student_details_class_list($condition,$start_from,$end_to);
					$condition = " da.absent_date LIKE '".$year."-%".$month."-%' AND c.school_id=".$this->session->userdata('school_id')." AND s.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."'";
					$show_data['attendance_class_details']=$this->attendance_model->get_student_details_class_list($condition);
	
				}
				if(isset($_GET['classid'])||isset($_GET['divisionid']))
				{
					$condition = '';
					$show_data['getmonth']=$_GET['month'];
					$show_data['getyear']=$_GET['year'];

					$month = $_GET['month'];
					$year = $_GET['year'];

		          	// $class=$_GET['classid'];
		          	// $division=$_GET['divisionid'];

				  	if(($_GET['classid'])=='')
					{
				 		redirect(base_url().'index.php/attendance?page=1&month='.date('m').'&year='.date('Y'));	
					}

					else
					{
						$i=$_GET['classid'];
						$condition = "cd.class_id=".$i." AND c.school_id=".$this->session->userdata('school_id')." AND s.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."' AND da.absent_date LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendance_model->get_student_details_class_list($condition);
					}

					if((($_GET['classid'])!='')&&isset($_GET['divisionid'])&&($_GET['divisionid'])!='')
					{
						$classid=$_GET['classid'];
						$divisionid=$_GET['divisionid'];
						$condition = "cd.class_id=".$classid." AND c.school_id=".$this->session->userdata('school_id')." AND s.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."' AND cd.id=".$divisionid." AND da.absent_date LIKE '".$year."-%".$month."-%'";
						$show_data['attendance_class_details']=$this->attendance_model->get_student_details_class_list($condition);
						// echo "<pre>";
						// print_r($show_data['attendance_class_details']);die;
					}
				}
			}

		if(isset($_GET['classid']))
		{
            $show_data['getmonth']=$_GET['month'];
			$show_data['getyear']=$_GET['year'];

			if(($_GET['classid'])=='')
			{
		 		redirect(base_url().'index.php/attendance?page=1&month='.date('m').'&year='.date('Y').'&classid=1');		
			}
			else
			{
				$i=$_GET['classid'];
				$condition='';
				if($this->session->userdata('user_type')=='tutor')
				{
					$userid=$this->session->userdata('user_id');
					$condition = "class_id=".$i." AND sct.tutor_id=".$userid." AND cd.end_date='".date('2099-12-12 23:59:59')."'" ;
					$show_data['division_data']=$this->attendance_model->get_all_division($condition);
					$show_data['classid']=$i;
				}
				else if($this->session->userdata('user_type')=='admin')
				{
					$condition = "cd.class_id=".$i." AND c.school_id=".$this->session->userdata('school_id')." AND cd.end_date='".date('2099-12-12 23:59:59')."'";
					$show_data['classid']=$i;
					$show_data['division_data']=$this->attendance_model->get_all_divisions($condition);
				}
			}
		}

			$condition='';
			// echo $this->session->userdata('user_id');die;
			if($this->session->userdata('user_type')=='tutor')
			{
				$condition="WHERE sct.tutor_id=".$this->session->userdata('user_id')." AND c.school_id=".$this->session->userdata('school_id');
				$all_class = $this->attendance_model->get_class($condition);
				$show_data['all_class'] = $all_class;
				$show_data['login_user_id'] = $this->session->userdata('user_id');
			}
			else if($this->session->userdata('user_type')=='parent')
			{
				$user_id=$this->session->userdata('user_id');
				$show_data['select_student'] = $this->timetable_model->get_parent_students($user_id);
				$show_data['login_user_id'] = $this->session->userdata('user_id');	
			}
			else if($this->session->userdata('user_type')=='admin')
			{
				$condition="WHERE school_id=".$this->session->userdata('school_id');
				$show_data['all_class'] = $this->attendance_model->get_all_class($condition);
				$show_data['login_user_id'] = '';
			}


		//$show_data['all_class'] = $this->attendance_model->get_class();
		$this->load->view('attendance_view',$show_data);

	}
	function messagebulkupload()
	{
		$uploaddir = 'timesheet/attendance_upload/'; 
		
		$file = $uploaddir .$_FILES['file_upload']['name']; 
		$file_name= $_FILES['file_upload']['name'];
	
		if (move_uploaded_file($_FILES['file_upload']['tmp_name'], $file))
		{ 
		
			$this->load->helper(array('timesheet', 'file'));
			$upload_array=read_sheet_attendance($file);
			$class_id=$upload_array['class_id'] ;
			$division_id=$upload_array['division_id'];	
			$date=$upload_array['date'];
			$calendar_year_id=$upload_array['calendar_year_id'];
			$data1=array();
			$data2=array();
			$delete_attendance =$this->attendance_model->check_exisit_attendance_details($division_id,$calendar_year_id,date("Y-m-d",strtotime($date)));
			$result1 ='';
			$result2 ='';
			foreach ($upload_array['data'] as $absent) 
			{
				if(sizeof($upload_array['data'])>0)
				{

					if(($absent['status']=='A')||($absent['status']=='a'))
					{
						if($absent['reason']=='')
						{
							$data1=array(
							'class_division_id'		=>$division_id,
							'student_id'		=>$absent['student_id'],
							'calendar_year_id'=>$calendar_year_id,
							'absent_date'=>date("Y-m-d",strtotime($date)),
							'reason'	=>'no reason',
							'present_flag'=>0
							);

						}
						else
						{
							$data1=array(
								'class_division_id'		=>$division_id,
								'student_id'		=>$absent['student_id'],
								'calendar_year_id'=>$calendar_year_id,
								'absent_date'=>date("Y-m-d",strtotime($date)),
								'reason'	=>$absent['reason'],
								'present_flag'=>0
								);
						}
						$result1 =$this->attendance_model->add_attendance_details($data1);
					 
					}
					else
					{
  						$data2=array(
							'class_division_id'		=>$division_id,
							'student_id'		=>$absent['student_id'],
							'calendar_year_id'=>$calendar_year_id,
							'absent_date'=>date("Y-m-d",strtotime($date)),
							'present_flag'=>1
							);
					 $result2 =$this->attendance_model->add_attendance_details($data2);
					}
					
					
					
					
				}
			}
			if($result1>0||$result2>0)
			{
				$this->success('<p class="success">File Upload have been updated successfully</p>');
				redirect($_SERVER['HTTP_REFERER']);
			}
									
		}
	}

	function add_attendance()
	{
		$ret_result='';
		$this->load->model('addclass_model');
		$this->load->model('adddivision_model');
		

		$select_class = $this->attendance_model->get_tutor_all_class($this->session->userdata('user_id'));
		$division = $this->adddivision_model->get_division_details1();
		$day_of_week = $this->attendance_model->get_day_of_week();

		$select_period = $this->attendance_model->get_all_period();
		if($this->session->userdata('user_logged')=="yes:schooluser"&&($this->session->userdata('user_type')=='tutor'))
		{
			$ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
    						<script src="'. base_url().'js/script_validation.js"></script>
   


				<script>
		        $(document).ready(function(){
		        $("#attendance_date").datepicker({
		            maxDate: 0,
					changeMonth: true,
					changeYear: true,
					showButtonPanel: true,
					dateFormat: "dd-mm-yy",
					yearRange:"2015:", 

		            onSelect: function(dateText, inst) {

			            var dateToday = new Date();
						var todayDate = dateToday.toLocaleDateString("en-GB");
						var todayDateNumber = dateToday.getDate();

							var weekday = new Array(7);
							weekday[0]=  "Sunday";
							weekday[1] = "Monday";
							weekday[2] = "Tuesday";
							weekday[3] = "Wednesday";
							weekday[4] = "Thursday";
							weekday[5] = "Friday";
							weekday[6] = "Saturday";

							var dateSelect = $(this).datepicker("getDate");	       
							var todaysDay = weekday[dateToday.getDay()];
			    			var dayOfWeek = $.datepicker.formatDate("DD", dateSelect);
			    		    var division_id = document.getElementById("division").value;


			    		  var pathstring = String(window.location);
						  var patharray  = pathstring.split("/");   
						  var path=patharray[0]+"//"+patharray[2]+"/"+patharray[3];
						  var url = path+"/index.php/attendance/get_period_select";

						  $.post(url,{dayOfWeek:dayOfWeek,division_id:division_id},function(data) {

						  	    if(data!="")
							    {

							        $("#period_id").html(data);

							    }
							    
						  });
			        	}
		        	});          
		        });
					
		      </script>

		      

		      <div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Add Attendance</h2>
								<div class="close__btn3 close__btn4" onclick="period_closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="add_attendance_validation" id="add_attendance_validation" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form">
			
										<div class="field" role="user-name">
											<label style="padding:0;">
												Class				
											</label>
												<div class="input__area">				
													<select class="input arrow" name="class" id="class" onchange="get_division_attendance(this,'.$div="'D'".')">
		                                            	<option value="">Select Class</option>';

		                                            		foreach ($select_class as $class) 
		                                            		{
		                                            			$ret_result.='<option value="'.$class['id'].'">'.$class['number'].'</option>';
		                                            		}
												    $ret_result.='</select>
												   <div id="error_class" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>

										<div class="field" role="user-name">
											<label style="padding:0;">
												Division			
											</label>
											<div class="input__area">	
												<select class="input arrow" name="division" id="division" onchange="get_student_attendance(this)">
													<option value="">Select Division</option>
												</select>
													<div id="error_division" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										<div class="field" role="user-name">
											<label style="padding:0;">
												Student			
											</label>
											<div class="input__area">	
												<select class="input arrow" name="student" id="student">
													<option value="">Select Student</option>
												</select>
													<div id="error_student" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>

										<div class="field" role="user-name">
											<label style="padding:0;">
												Absent Date				
											</label>
												<div class="input__area">					
													<input type="text" value="" class="input" name="attendance_date" id="attendance_date" placeholder="Attendance Date">
													<p id="datepicker-date-selected"></p>
													<p id="datepicker-day-of-week"></p>
													<div id="error_attendance_date" class="val__msgbx"></div>
												</div>
											<div class="clear"></div>
										</div>
										<div class="field" role="user-name">
											<label style="padding:0;">
												&nbsp;				
											</label>
											<div class="input__area">
												<input type="radio" value="day_wise" name="day_wise" id="day_wise" onclick="get_day_wise(this,'."'A'".')" checked> Day Wise
												<input type="radio" value="period_wise" name="day_wise" id="period_wise" onclick="get_day_wise(this,'."'A'".')"> Period Wise
												<div id="error_day_wise" class="val__msgbx"></div>
											</div>
											<div class="clear"></div>
										</div>
										
										<div id="day_wise_select">
											

												<div id="reason_status" >
													<div class="field" role="user-name">
														<label style="padding:0;">
															Reason
														</label>
														<div class="input__area">
															<textarea class="input" name="status_reason" id="status_reason"></textarea>
															<div id="" class="val__msgbx"></div>
														</div>
														<div class="clear"></div>
													</div>
												</div>
											</div>

											<div id="period_wise_select" style="display:none;">

												<div id="period_reason_status" style="display:none;">

													<div class="field" role="user-name">
														<label style="padding:0;">
															Period
														</label>
														<div class="input__area">
															<select name="period_id" id="period_id" class="input arrow" onchange="get_time_table_subject(this)">
																<option value="">Select Period</option>

																</select>
															<div id="error_period_id" class="val__msgbx"></div>
														</div>
														<div class="clear"></div>
													</div>

													<div class="field" role="user-name">
														<label style="padding:0;">
															Reason
														</label>
														<div class="input__area">
															<textarea class="input" name="period_status_reason" id="period_status_reason"></textarea>
															<div id="" class="val__msgbx"></div>
														</div>
														<div class="clear"></div>
													</div>

												</div>
											</div>



										<div class="field" role="user-name">
											<label style="padding:0;">
												&nbsp;				
											</label>	
												<div class="btn_cal">
													<input type="submit" name="create_attendance" id="create_attendance_period" class="submit_button4 submit_button4_attendance" value="Submit" onclick="return attendance_period_validation()" style="display:none;">				
													<input type="submit" name="create_attendance" id="create_attendance" class="submit_button4 submit_button4_attendance" value="Submit" onclick="return attendance_validation()">
													<input type="reset" name="create_attendance" id="create_attendance" class="submit_button4 cancel_btn_align submit_button4_attendance" value="Cancel">
												</div>
										</div>										
									</div>
								</div>
							</form>
							';						
					echo $ret_result;
		}
	}

	function get_division()
	{
		$result='<option value="">Select Division</option>';
		if(isset($_POST['class_id'])&&$_POST['class_id']!='')
		{

			$class_id=$_POST['class_id'];
		
			$this->load->model('assigntutor_model');
			$this->load->model('attendance_model');
	
			$division_name=$this->assigntutor_model->get_all_division($class_id);
	
			if(sizeof($division_name)>0)
			{
				foreach($division_name as $division)
				{
					$result.='<option value="'.$division['id'].'">'.$division['name'].'</option>';
				}			
			}
		}
		echo $result;
		exit();
	}

	function get_student_name()
	{
		$result='<option value="">Select Student</option>';
		if((isset($_POST['class_id'])&&$_POST['class_id']!='')&&(isset($_POST['division_id'])&&$_POST['division_id']!=''))
		{	

			$class_id=$_POST['class_id'];
			$division_id=$_POST['division_id'];

			$student_name=$this->attendance_model->get_all_student($class_id,$division_id);	
	
			if(sizeof($student_name)>0)
			{
				foreach($student_name as $name)
				{
					$result.='<option value="'.$name['student_id'].'">'.$name['first_name'].' '.$name['last_name'].'</option>  ';
				}			
			}
		}
		echo $result;
		exit();
	}
	function get_period_select()
	{
		$day_of_week=$_POST['dayOfWeek'];
		$division_id=$_POST['division_id'];
		$result='<option value="">Select Period</option>';
		if((isset($_POST['division_id'])&&$_POST['division_id']!='') && (isset($_POST['dayOfWeek'])&&$_POST['dayOfWeek']!=''))
		{	
			
			$day_id=$this->attendance_model->get_current_day($day_of_week);
			$period_name=$this->attendance_model->get_all_period_Select($division_id,$day_id['id']);	

			if(sizeof($period_name)>0)
			{
				foreach($period_name as $period)
				{
					$result.='<option value="'.$period['period_id'].'_'.$period['subject_id'].'">'.$period['period'].'-'.$period['name'].'</option>  ';
				}		
			}
		}
		echo $result;
		exit();
	}
	 private function success($message) {
        $userdata = array(
            'success' => $message
        );
        $this->session->set_userdata($userdata);
    }

    private function clearmessage() {
        $userdata = array(
            'success' => ''
        );
        $this->session->set_userdata($userdata);
    }
    function download_sheet()
	{
		$ret_result='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='tutor'))
		{
			$this->load->model('adddivision_model');
			$select_class = $this->attendance_model->get_tutor_all_class($this->session->userdata('user_id'));
			$division = $this->adddivision_model->get_division_details1();

			$ret_result.='<script src="'. base_url().'js/jquery-1.9.1.js"></script>
    						<script src="'. base_url().'js/jquery-ui.js"></script>
    						<script src="'. base_url().'js/script_validation.js"></script>
   


				<script>
			        $(document).ready(function(){
				        $("#attendance_date").datepicker({
				            maxDate: 0,
							changeMonth: true,
							changeYear: true,
							showButtonPanel: true,
							dateFormat: "dd-mm-yy",
							yearRange:"2015:",
						});

					});
				</script>';


			$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
												<h2>Download Sheet </h2>
												<div class="close__btn2" onclick="period_closePopup()"></div>
											</div>
											<div class="loginmsg__box"></div>
											<form action="" name="new_attendance_download_sheet_registration" id="new_attendance_download_sheet_registration" enctype="multipart/form-data" method="post">
												<div class="">
													<div class="form">
														<div class="field" role="user-name">
															<label style="padding:0;">
																Class				
															</label>
																<div class="input__area">				
																	<select class="input arrow" name="class" id="class" onchange="get_division_attendance(this,'.$div="'D'".');check_attendace_class_list_student(this.value,'.$div="'D'".')">
						                                            	<option value="">Select Class</option>';

						                                            		foreach ($select_class as $class) 
						                                            		{
						                                            			$ret_result.='<option value="'.$class['id'].'">'.$class['number'].'</option>';
						                                            		}
																    $ret_result.='</select>
																   <div id="error_class" class="val__msgbx"></div>
																</div>
															<div class="clear"></div>
														</div>

														<div class="field" role="user-name">
															<label style="padding:0;">
																Division			
															</label>
															<div class="input__area">	

																<select class="input arrow" name="division" id="division" onchange="check_attendace_class_division_student(this,'.$div="'D'".')">
																	<option value="">Select Division</option>
																</select>
																	<div id="error_division" class="val__msgbx"></div>
															</div>
															<div class="clear"></div>
														</div>
														<div class="field" role="user-name">
															<label style="padding:0;">
																Attendance Date				
															</label>
																<div class="input__area">					
																	<input type="text" value="" class="input" name="attendance_date" id="attendance_date" placeholder="Attendance Date">
																	<div id="error_attendance_date" class="val__msgbx"></div>
																</div>
															<div class="clear"></div>
														</div>
														<div class="content_form" role="user-name">
															<label style="padding:0;">
															</label>	
															<div>				
																<input type="submit" name="create_dowload_sheet" id="create_dowload_sheet" class="submit_button4 submit_button4_attendance" value="Submit" onclick="return new_attendance_download_sheet_validation()">
																<input type="reset" name="cancel_dowload_sheet" id="cancel_dowload_sheet" class="submit_button4 cancel_btn_align submit_button4_attendance" value="Cancel">
															</div>
														</div>
														
																								
													</div>
												</div>
											</form>
											';
													
									
					echo $ret_result;
					exit;
		}
	}
	function check_class_list_students() 
	{
        if (isset($_POST['class_id'])) 
        {
            $class_id = $_POST['class_id'];
            $user_name=$this->session->userdata('user_code');
            $condition = "where class_id='".$class_id."'";
            $this->load->model('class_list_model');
            $user_details = $this->class_list_model->check_class_list_student($condition);
            // print_r($user_details);die;
            if ($user_details['student_count']!=0) {
                echo 1;
            } else {
                echo 0;
            }
        }
    }
	function check_class_list_division_student() 
	{
        if (isset($_POST['division_id'])) 
        {
            $division_id = $_POST['division_id'];
            $user_name=$this->session->userdata('user_code');
            $condition = "where cd.id='".$division_id."'";
            $this->load->model('class_list_model');
            $user_details = $this->class_list_model->check_class_list_student($condition);
            if ($user_details['student_count']!=0) {
                echo 1;
            } else {
                echo 0;
            }
        }
    }
    function get_division_subject()
	{
		$result='';
		if(isset($_POST['division_id'])&&$_POST['division_id']!='')
		{	

			$division_id=$_POST['division_id'];
			$this->load->model('homework_model');
			$subject_name=$this->homework_model->get_all_division_subject($division_id,$this->session->userdata('user_id'));
			if(sizeof($subject_name)>0)
			{
				$result.='<option value="">Select Subject</option>';
				foreach($subject_name as $subject)
				{

					$result.='<option value="'.$subject['id'].'">'.$subject['name'].'</option>';
					}				
			}
				
		}
		echo $result;
		exit();
	}
	function uploadsheet()
	{
		$ret_result='';
		if($this->session->userdata('user_logged')=="yes:schooluser" && ($this->session->userdata('user_type')=='tutor'))
		{
			 $ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
								<h2>Upload Sheet</h2>
								<div class="close__btn2" onclick="closePopup()"></div>
							</div>
							<div class="loginmsg__box"></div>
							<form action="" name="create_attendance_upload" id="create_attendance_upload" enctype="multipart/form-data" method="post">
								<div class="">
									<div class="form ">
										<div class="content_form" role="user-name">
												<label style="padding:0;">
													Uploaded File			
												</label>
												<div class="input__area">					
													<input type="file" value="" class="input " name="file_upload" id="file_upload" placeholder="File Upload">
													<div id="error_file_upload" class="val__msgbx"></div>
												</div>
												<div class="clear"></div>
										</div>
										<div class="content_form" role="user-name">
											<label style="padding:0;">
											</label>	
											<div >				
												<input type="submit" name="create_upload_sheet" id="create_upload_sheet" class="submit_button4 submit_button4_attendance" value="Submit" onclick="return create_attendance_upload_validation()">
												<input type="reset" name="create_upload_sheet" id="create_upload_sheet" class="submit_button4 cancel_btn_align submit_button4_attendance" value="Cancel">
											</div>
										</div>
																			
									</div>
								</div>
							</form>
							';									
									
					echo $ret_result;
					// exit;
		}
	
	}	
	function view_attendance()
	{
		$ret_result='';
		if(isset($_POST['division_id']) && $_POST['division_id']!=''&& (isset($_POST['calendar_year_id']) && $_POST['calendar_year_id']!=''))
		{
				$division_id=$_POST['division_id'];
				$calendar_year_id=$_POST['calendar_year_id'];
				$current_date=$_POST['date'];
				$date=date('Y-m-d',strtotime($current_date));
				switch ($this->session->userdata('user_type'))
				{
					case 'student':$student_details_attendance=$this->attendance_model->find_student_attendance_details($division_id,$calendar_year_id,$this->session->userdata('user_id'),$date);break;
					case 'parent':$student_details_attendance=$this->attendance_model->find_student_parent_attendance_details($division_id,$calendar_year_id,$this->session->userdata('user_id'),$date);break;
				}
				 // echo "<pre>";
				 // print_r($student_details_attendance);die;
			 	$condition = " sat.absent_date='".$date."' AND sat.class_division_id=".$division_id." AND c.school_id=".$this->session->userdata('school_id')." AND st.school_id=".$this->session->userdata('school_id')." AND sat.calendar_year_id=".$calendar_year_id." AND cd.end_date='".date('2099-12-12 23:59:59')."' AND sat.present_flag=0";
			 	$student_details=$this->attendance_model->get_student_attendance_details($condition);
				if(($this->session->userdata('user_type')=='admin')||($this->session->userdata('user_type')=='tutor'))
			 	{
				 	$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
									<h2>View Attendance Details</h2>
									<div class="close__btn2" onclick="closePopup()"></div>
								</div>
								<div class="loginmsg__box"></div>
								<form action="" name="create_attendance_upload" id="create_attendance_upload" enctype="multipart/form-data" method="post">
									<div class="">
										<div class="form ">';
											if(sizeof($student_details)>0)
											{
											 $ret_result.='<table id="rtable" class="display" cellspacing="0" width="100px" margin-top="5px">
											  	<thead>
									            	<tr>
									            		<th class="table_head">Student Name</th>
									            		<th class="table_head">class</th>
									                	<th class="table_head">Absent Date</th>
									                	<th class="table_head">Reason</th>
									                </tr>
									            </thead>
									            <tbody>';
													foreach ($student_details as $absent_date)
													 {
														$DateTimeObj = new DateTime($absent_date['absent_date']);
	                                    				$absentddate = $DateTimeObj->format('d-m-Y');
														$ret_result.='<tr>
														<td><input type="text" style="text-align:center;" value="'.ucwords($absent_date['first_name']).' '.ucwords($absent_date['last_name']).'" class="input_attendance" readonly></td>
												                  	<td><input type="text" style="text-align:center;" value="'.$absent_date['number'].'-'.$absent_date['name'].'" class="input_attendance" readonly></td>
												                  	<td><input type="text" style="text-align:center;" value="'.$absentddate.'" class="input_attendance" readonly></td>
												                  	<td><input type="text" style="text-align:center;" value="'.ucwords($absent_date['reason']).'" class="input_attendance" readonly></td>
												                  	<tr>';
													}
													$ret_result.='</tbody>
													</table></div>';
												
																	
												$ret_result.='</div>
													</div>
												</form>';									
																	
													echo $ret_result;
													// exit;
											}
											else
											{
												$ret_result.='<div style="margin-left:20x;">No Absent Found</div>';
												echo $ret_result;
													// exit;
											}
				}
				else if(($this->session->userdata('user_type')=='parent')||($this->session->userdata('user_type')=='student'))
				{
					$ret_result.='<div class="pogin__popuphd" style="text-transform:uppercase">
									<h2>View Attendance Details</h2>
									<div class="close__btn2" onclick="closePopup()"></div>
								</div>
								<div class="loginmsg__box"></div>
								<form action="" name="create_attendance_upload" id="create_attendance_upload" enctype="multipart/form-data" method="post">
									<div class="">
										<div class="form ">';
											if(sizeof($student_details_attendance)>0)
											{
												$ret_result.='<table id="rtable" class="display" cellspacing="0" width="100px" margin-top="5px">
												  	<thead>
										            	<tr>
										            		<th class="table_head">Student Name</th>
										            		<th class="table_head">class</th>
										                	<th class="table_head">Absent Date</th>
										                	<th class="table_head">Reason</th>
										                </tr>
										            </thead>
										            <tbody>';
										            $DateTimeObj = new DateTime($student_details_attendance['absent_date']);
		                                    	    $absentddate = $DateTimeObj->format('d-m-Y');
											 		$ret_result.='<tr>
																	<td><input type="text" style="text-align:center;" value="'.ucwords($student_details_attendance['first_name']).' '.ucwords($student_details_attendance['last_name']).'" class="input_attendance" readonly></td>
												                  	<td><input type="text" style="text-align:center;" value="'.$student_details_attendance['number'].'-'.$student_details_attendance['name'].'" class="input_attendance" readonly></td>
												                  	<td><input type="text" style="text-align:center;" value="'.$absentddate.'" class="input_attendance" readonly></td>
												                  	<td><input type="text" style="text-align:center;" value="'.ucwords($student_details_attendance['reason']).'" class="input_attendance" readonly></td>
													       		  <tr>
													  </tbody>
													</table>
													</div>
												</div>
												</form>';									
									            echo $ret_result;
											}
											else
											{
												$ret_result.='<div style="margin-left:20x;">No Absent Found</div>';
												echo $ret_result;
													// exit;
											}

				}
			}
		}			
   }