(function (factory) {
    if (typeof define === "function" && define.amd) {
        define(["jquery"], factory);
    } else {
        factory(jQuery);
    }
})(function ($) {

    "use strict";

    var log = function (o) {
            try {
                console.log(o)
            } catch (e) {}
        };

    function CropImage($element) {
        this.$container = $element;

        this.$imageView = this.$container.find(".image-view");
        this.$image = this.$imageView.find("img");
		this.$crop_again = this.$container.find("#crop_again");
        this.$imageModal = this.$container.find("#image-modal");
        this.$loading = this.$container.find(".loading");

        this.$imageForm = this.$imageModal.find(".image-form");
        this.$imageUpload = this.$imageForm.find(".image-upload");
        this.$imageSrc = this.$imageForm.find(".image-src");
        this.$imageData = this.$imageForm.find(".image-data");
        this.$imageInput = this.$imageForm.find(".image-input");
        this.$imageSave = this.$imageForm.find(".image-save");

        this.$imageWrapper = this.$imageModal.find(".image-wrapper");
		this.$imagePreview = this.$imageModal.find(".image-preview");

        this.init();
        log(this);
    }

    CropImage.prototype = {
        constructor: CropImage,

        support: {
            fileList: !!$("<input type=\"file\">").prop("files"),
            fileReader: !!window.FileReader,
            formData: !!window.FormData
        },

        init: function () {
            this.support.datauri = this.support.fileList && this.support.fileReader;

            if (!this.support.formData) {
                this.initIframe();
            }

			
			
            this.initTooltip();
            this.initModal();
            this.addListener();
        },

        addListener: function () {
			this.$imageModal.modal("show");
			this.$imageView.on("click", $.proxy(this.click, this));
		    this.$crop_again.on("click", $.proxy(this.click, this));
            this.$imageInput.on("change", $.proxy(this.change, this));
            this.$imageForm.on("submit", $.proxy(this.submit, this));
        },

        removeListener: function () {
        },

        initTooltip: function () {
            this.$imageView.tooltip({
                placement: "bottom"
            });
        },

        initModal: function () {
            this.$imageModal.modal("hide");
            this.initPreview();
        },

        initPreview: function () {
			
            var url = this.$image.attr("src");
			this.$imagePreview.empty().html('<img src="' + url + '">');
        },

        initIframe: function () {
            var iframeName = "image-iframe-" + Math.random().toString().replace(".", ""),
                $iframe = $('<iframe name="' + iframeName + '" style="display:none;"></iframe>'),
                firstLoad = true,
                _this = this;

            this.$iframe = $iframe;
            this.$imageForm.attr("target", iframeName).after($iframe);

            this.$iframe.on("load", function () {
                var data,
                    win,
                    doc;

                try {
                    win = this.contentWindow;
                    doc = this.contentDocument;

                    doc = doc ? doc : win.document;
                    data = doc ? doc.body.innerText : null;
                } catch (e) {}

                if (data) {
                    _this.submitDone(data);
                } else {
                    if (firstLoad) {
                        firstLoad = false;
                    } else {
                        _this.submitFail("Image upload failed!");
                    }
                }

                _this.submitEnd();
            });
        },

        click: function () {
            this.$imageModal.modal("show");
			this.$imageWrapper.empty();
			$('#imageW').val('');
			$('#imageH').val('');
        },

        change: function () {
            var files,
                file;

            if (this.support.datauri) {
                files = this.$imageInput.prop("files");

                if (files.length > 0) {
                    file = files[0];

                    if (this.isImageFile(file)) {
                        this.read(file);
                    }
                }
            } else {
                file = this.$imageInput.val();

                if (this.isImageFile(file)) {
                    this.syncUpload();
                }
            }
        },

        submit: function () {
            if (!this.$imageSrc.val() && !this.$imageInput.val()) {
                return false;
            }

            if (this.support.formData) {
                this.ajaxUpload();
                return false;
            }
        },

        isImageFile: function (file) {
            if (file.type) {
                return /^image\/\w+$/.test(file.type);
            } else {
                return /\.(jpg|jpeg|png|gif)$/.test(file);
            }
        },

        read: function (file) {
            var _this = this,
                fileReader = new FileReader();
				
            fileReader.readAsDataURL(file);

            fileReader.onload = function () {
                _this.url = this.result
                _this.startCropper();
            };
        },

        startCropper: function () {
		
            var _this = this;
			if (this.active) {
                this.$img.cropper("setImgSrc", this.url);
            } else {
			    this.$img = $('<img src="' + this.url + '"  >');
				this.$imageWrapper.empty().html(this.$img);
				this.$img.cropper({
                    aspectRatio: 10/7,
					//autoCrop: false,
					dragCrop: false,
					data: {
                    x: 420,
                    y: 50,
                    width: 640,
                    height: 360
                },
                    preview: this.$imagePreview.selector,
                    done: function (data) {
					$('#imageW').val(data.width);
					$('#imageH').val(data.height);
					
				    var json = [
                            '{"x":' + data.x,
                            '"y":' + data.y,
                            '"height":' + data.height,
                            '"width":' + data.width + "}"
                        ].join();

                        _this.$imageData.val(json);
						 
                    }
                });

                this.active = true;
            }
        },

        stopCropper: function () {
            if (this.active) {
                this.$img.cropper("disable");
                this.$img.data("cropper", null).remove();
                this.active = false;
            }
        },

        ajaxUpload: function () {
            var url = this.$imageForm.attr("action"),
                data = new FormData(this.$imageForm[0]),
                _this = this;
							
		    $.ajax(url, {
                type: "post",
                data: data,
                processData: false,
                contentType: false,

                beforeSend: function () {
					  _this.submitStart();
                },

                success: function (data) {
				//alert(data);
                    _this.submitDone(data);
                },

                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    _this.submitFail(textStatus || errorThrown);
                },

                complete: function () {
                    _this.submitEnd();
                }
            });
        },

        syncUpload: function () {
            this.$imageSave.click();
        },

        submitStart: function () {
            this.$loading.fadeIn();
        },

        submitDone: function (data) {
            log(data);

            try {
                data = $.parseJSON(data);
            } catch (e) {};
						
            if (data && data.state === 200) {
                if (data.result) {
				     this.url = data.result;

                    if (this.support.datauri || this.uploaded) {
                        this.uploaded = false;
                        this.cropDone();
                    } else {
                        this.uploaded = true;
                        this.$imageSrc.val(this.url);
                        this.startCropper();
                    }

                    this.$imageInput.val("");
                } else if (data.message) {
                    this.alert(data.message);
                }
            } else {
				     this.alert("Failed to response");
            }
        },

        submitFail: function (msg) {
            this.alert(msg);
        },

        submitEnd: function () {
            this.$loading.fadeOut();
        },

        cropDone: function () {
            this.$imageSrc.val("");
            this.$imageData.val("");
            this.$image.attr("src", this.url);
            this.stopCropper();
            this.$imageModal.modal("hide");
			
			//$('#img_pop_up').hide();
        },

        alert: function (msg) {
            var $alert = [
                '<div class="alert alert-danger avater-alert">',
                    '<button type="button" class="close" data-dismiss="alert">&times;</button>',
                    msg,
                '</div>'
                ].join("");

            this.$imageUpload.after($alert);
        }
    };

    $(function () {
        //delay('hi');
        var example = new CropImage($("#image_crop"));


    });
});
